/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.DeleteChildrenHelper;
import com.raplix.rolloutexpress.ui.web.DeleteConfirmNode;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.string.StringUtil;
import org.apache.struts.util.MessageResources;

public abstract class StandardObjectDeleteNode
extends UITreeNode {
    protected ObjectID mObjectID = null;
    protected String mName = "";
    protected String mDescription = "";
    protected boolean mIsUndeletable = false;
    protected int mRowLevel = 0;
    protected String mPrologue = "";
    protected String mContents = "";
    protected MessageResources messages = ApplicationResources.getMessageResources();
    private int mNumDeletableRelatedItems = 0;

    public StandardObjectDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        this.mType = UITreeNodeType.LEAF;
        DeleteSessionCandidateStatus status = candidate.getStatus();
        this.mIsUndeletable = status.equals(DeleteSessionCandidateStatus.IN_USE) || status.equals(DeleteSessionCandidateStatus.NOT_DELETABLE);
        StandardObject object = this.getObject(candidate);
        this.mObjectID = object.getObjectID();
        this.mName = object.getName();
        this.mDescription = StringUtil.normalizeEmpty(object.getDescription());
        this.preRender();
    }

    public abstract int getDeleteConfirmColspan();

    public abstract String getDeleteContext();

    public int getNumDeletableRelatedItems() {
        return this.mNumDeletableRelatedItems;
    }

    public abstract StandardObject getObject(DeleteSessionCandidate var1) throws RaplixException;

    public void getDescendents(DeleteSessionCandidate candidate) throws RaplixException {
        this.getDescendents(candidate, null);
    }

    public void getDescendents(DeleteSessionCandidate candidate, String headerMessage) throws RaplixException {
        if (this.mIsUndeletable) {
            PersistenceManagerException pme = (PersistenceManagerException)candidate.getException();
            String errMsg = pme.getMessage();
            DeleteConfirmNode confirmNode = new DeleteConfirmNode(errMsg, 2, this.getDeleteConfirmColspan());
            this.addChild(confirmNode);
            if (pme instanceof ObjectInUseException) {
                UsingObject[] blockers = ((ObjectInUseException)pme).getUsingObjects();
                for (int j = 0; j < blockers.length; ++j) {
                    DeleteConfirmNode blockerNode = new DeleteConfirmNode(blockers[j], 2, this.getDeleteConfirmColspan());
                    blockerNode.setTree(this.mTree);
                    confirmNode.addChild(blockerNode);
                }
            }
        } else if (candidate.getChildren() != null) {
            DeleteChildrenHelper dch = new DeleteChildrenHelper(this, this.getDeleteConfirmColspan(), this.mNumDeletableRelatedItems, candidate.getChildren(), this.getDeleteContext(), headerMessage);
            this.mNumDeletableRelatedItems = dch.getNumDeletableRelatedItems();
        }
    }

    public void preRender() throws RaplixException {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(this.mName);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(this.mDescription);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }

    public void addChild(UITreeNode node) {
        this.mChildren.add(node);
        node.setTree(this.mTree);
        this.mType = UITreeNodeType.BRANCH_CLOSED;
    }

    public String finishRender(StringBuffer sb, String path) {
        String rowspanStr = "rowspan=\"" + this.getVisibleChildCount() + "\"";
        this.mPrologue = "<tr>\n" + Util.introStandardCell(rowspanStr, this.mRowLevel) + Util.standardCellStart(0, "nowrap", this.mRowLevel);
        return this.mPrologue + sb + this.mContents;
    }

    public void finishOpen() {
    }

    public void finishClose() {
    }

    protected String getJavascriptFunction() {
        return "sendTree";
    }
}

