/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.servlet.http.HttpSession;

public class ServletSessionBroker {
    private LinkedList mLinkedList;
    private HttpSession mHttpSession;
    private int MAX_LIST_SIZE = 25;
    public static String SERVLET_SESSION_BROKER_KEY = "servlet_session_broker_key";

    public ServletSessionBroker(HttpSession inHttpSession) {
        this.mHttpSession = inHttpSession;
        this.mLinkedList = new LinkedList();
    }

    public synchronized void put(String key, Object o) {
        if (this.mHttpSession.getAttribute(key) != null) {
            this.mLinkedList.remove(key);
        } else if (this.mLinkedList.size() >= this.MAX_LIST_SIZE) {
            String oldestKey = (String)this.mLinkedList.removeLast();
            this.mHttpSession.removeAttribute(oldestKey);
        }
        this.mLinkedList.addFirst(key);
        this.mHttpSession.setAttribute(key, o);
    }

    public static ServletSessionBroker getBroker(HttpSession session) {
        ServletSessionBroker ssb = (ServletSessionBroker)session.getAttribute(SERVLET_SESSION_BROKER_KEY);
        if (ssb == null) {
            ssb = new ServletSessionBroker(session);
            session.setAttribute(SERVLET_SESSION_BROKER_KEY, (Object)ssb);
        }
        return ssb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("List size is: ");
        sb.append(this.mLinkedList.size());
        sb.append("<br>\n\n");
        ListIterator iter = this.mLinkedList.listIterator(0);
        while (iter.hasNext()) {
            sb.append(iter.next());
            sb.append("<br>\n");
        }
        sb.append("\n\n");
        return sb.toString();
    }
}

