/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletPreferenceBroker {
    private HttpSession mHttpSession;
    public static String SERVLET_PREFERENCE_BROKER_KEY = "servlet_preference_broker_key";
    private static String STRING_PREFIX = "servlet_preference_string_";
    private static String BOOLEAN_PREFIX = "servlet_preference_boolean_";

    public ServletPreferenceBroker(HttpSession inHttpSession) {
        this.mHttpSession = inHttpSession;
        this.mHttpSession.setAttribute(STRING_PREFIX + Preference.CATEGORY, (Object)ServletListBean.DEFAULT_CATEGORY_FILTER.toString());
        this.mHttpSession.setAttribute(BOOLEAN_PREFIX + Preference.SHOW_HIDDEN_GLOBAL, (Object)new Boolean(false));
        this.mHttpSession.setAttribute(STRING_PREFIX + Preference.FILE_PATH, (Object)ServletListBean.DEFAULT_FOLDER_FILTER.toString());
        this.mHttpSession.setAttribute(BOOLEAN_PREFIX + Preference.FLAT_VIEW, (Object)new Boolean(false));
        this.mHttpSession.setAttribute(STRING_PREFIX + Preference.BROWSE_HOST, (Object)"");
        this.mHttpSession.setAttribute(STRING_PREFIX + Preference.BROWSE_DIRECTORY, (Object)"");
        this.mHttpSession.setAttribute(STRING_PREFIX + Preference.BROWSE_COMPONENT_TYPE, (Object)"");
    }

    public static ServletPreferenceBroker getBroker(HttpSession session) {
        ServletPreferenceBroker spb = (ServletPreferenceBroker)session.getAttribute(SERVLET_PREFERENCE_BROKER_KEY);
        if (spb == null) {
            spb = new ServletPreferenceBroker(session);
            session.setAttribute(SERVLET_PREFERENCE_BROKER_KEY, (Object)spb);
        }
        return spb;
    }

    public String trackString(Preference p, HttpServletRequest request) {
        String latest;
        if (request != null && (latest = request.getParameter(p.toString())) != null) {
            this.setString(p, latest);
        }
        return this.getString(p);
    }

    public void setString(Preference p, String latest) {
        this.mHttpSession.setAttribute(STRING_PREFIX + p.toString(), (Object)latest);
    }

    public String getString(Preference p) {
        return (String)this.mHttpSession.getAttribute(STRING_PREFIX + p.toString());
    }

    public void setBoolean(Preference p, Boolean latest) {
        this.mHttpSession.setAttribute(BOOLEAN_PREFIX + p.toString(), (Object)latest);
    }

    public boolean trackBoolean(Preference p, HttpServletRequest request) {
        if (request != null && request.getMethod().equals("POST")) {
            String latest = request.getParameter(p.toString());
            this.mHttpSession.setAttribute(BOOLEAN_PREFIX + p.toString(), (Object)new Boolean(latest != null));
        }
        Object o = this.mHttpSession.getAttribute(BOOLEAN_PREFIX + p.toString());
        return (Boolean)o;
    }
}

