/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.MultiObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQuery;
import com.raplix.rolloutexpress.persist.query.NoSuchOrderException;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.ObjectOrderFactory;
import com.raplix.rolloutexpress.persist.query.ResultCount;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import com.raplix.util.regex.GlobPattern;
import com.raplix.util.regex.RegEx;
import com.raplix.util.regex.RegExSyntaxException;

public abstract class ServletListBean
extends ServletBean {
    public static final int DEFAULT_PAGE = 1;
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final CategoryID DEFAULT_CATEGORY_FILTER = Category.ANY_CATEGORY_ID;
    public static final FolderID DEFAULT_FOLDER_FILTER = FolderID.ROOT_FOLDER_ID;
    private int mPageCount = 0;
    private int mCurrentPage = 1;
    private int mFirstPos = 0;
    private int mLastPos = 0;
    private int mTotalItemCount = 0;
    private boolean mShowHidden = false;
    private String mSortName = "";
    private String mFindName = "";
    private String mFindDescription = "";
    private String mIsFindFiltered = "false";
    private CategoryID mCategoryFilter = DEFAULT_CATEGORY_FILTER;
    private String[] mCategoryIDs = new String[0];
    private String[] mCategoryNames = new String[0];
    private String mFilePathFilter = DEFAULT_FOLDER_FILTER.toString();
    private boolean mFlatView = false;
    private boolean mReadFiltersFromSession = true;

    public int getPageCount() {
        return this.mPageCount;
    }

    public int getCurrentPage() {
        return this.mCurrentPage;
    }

    public int getFirstPos() {
        return this.mFirstPos;
    }

    public int getLastPos() {
        return this.mLastPos;
    }

    public int getTotalItemCount() {
        return this.mTotalItemCount;
    }

    public boolean getShowHidden() {
        return this.mShowHidden;
    }

    public String getSortName() {
        return this.mSortName;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public String[] getCategoryIDs() {
        return this.mCategoryIDs;
    }

    public String[] getCategoryNames() {
        return this.mCategoryNames;
    }

    public String getFindName() {
        return this.mFindName;
    }

    public String getFindDescription() {
        return this.mFindDescription;
    }

    public String getIsFindFiltered() {
        return this.mIsFindFiltered;
    }

    public String getFilePathFilter() {
        return this.mFilePathFilter;
    }

    public boolean getFlatView() {
        return this.mFlatView;
    }

    public boolean getReadFiltersFromSession() {
        return this.mReadFiltersFromSession;
    }

    public void setPageCount(int pageCount) {
        this.mPageCount = pageCount;
    }

    public void setCurrentPage(int currentPage) {
        this.mCurrentPage = currentPage;
    }

    public void setFirstPos(int firstPos) {
        this.mFirstPos = firstPos;
    }

    public void setLastPos(int lastPos) {
        this.mLastPos = lastPos;
    }

    public void setTotalItemCount(int totalItemCount) {
        this.mTotalItemCount = totalItemCount;
    }

    public void setShowHidden(boolean showHidden) {
        this.mShowHidden = showHidden;
    }

    public void setSortName(String sortName) {
        this.mSortName = sortName;
    }

    public void setFindName(String findName) {
        this.mFindName = findName;
    }

    public void setFindDescription(String findDescription) {
        this.mFindDescription = findDescription;
    }

    public void setIsFindFiltered(String isFindFiltered) {
        this.mIsFindFiltered = isFindFiltered;
    }

    public void setCategoryFilter(CategoryID categoryID) {
        this.mCategoryFilter = categoryID;
    }

    public void setFilePathFilter(String filePath) {
        this.mFilePathFilter = filePath;
    }

    public void setFlatView(boolean isFlatView) {
        this.mFlatView = isFlatView;
    }

    public void setReadFiltersFromSession(boolean inRead) {
        this.mReadFiltersFromSession = inRead;
    }

    protected abstract void generateList() throws RaplixException;

    protected void prepQuery(MultiObjectQuery query, ObjectOrder sortOrder) throws RaplixException {
        this.loadFilters(query);
        query.setObjectOrder(sortOrder);
        query.setPageSize(this.getDefaultPageSize());
        query.setPageNum(this.mCurrentPage);
        ResultCount count = query.selectCount();
        if (count.getLastPos() == -1 && count.getTotalItemCount() > 0) {
            count.setPageNum(count.getPageCount());
            query.setPageNum(count.getPageCount());
        }
        this.setFirstPos(count.getFirstPos());
        this.setLastPos(count.getLastPos());
        this.setTotalItemCount(count.getTotalItemCount());
        this.setPageCount(count.getPageCount());
        this.setCurrentPage(count.getPageNum());
    }

    protected void loadAdditionalFilters(MultiObjectQuery query) throws RaplixException {
    }

    protected void loadAdditionalFindFilters(MultiObjectQuery query) throws RaplixException {
    }

    protected int getDefaultPageSize() {
        return 20;
    }

    public ObjectOrder getSortOrderByName(ObjectOrderFactory factory, String sortName) {
        ObjectOrder order;
        try {
            order = factory.getObjectOrder(sortName);
        }
        catch (NoSuchOrderException nsoe) {
            order = this.getDefaultSortOrder();
        }
        return order;
    }

    public ObjectOrder getDefaultSortOrder() {
        return null;
    }

    public boolean getCanBeHidden() {
        return false;
    }

    protected void loadFilters(MultiObjectQuery query) throws RaplixException {
        if (query instanceof MultiStandardObjectQuery) {
            if (this.mShowHidden) {
                ((MultiStandardObjectQuery)query).setVisibilityFilter(null);
            } else {
                ((MultiStandardObjectQuery)query).setVisibilityFilter(Visibility.VISIBLE);
            }
            if (this.mIsFindFiltered.equals("true")) {
                this.loadDefaultFindFilters((MultiStandardObjectQuery)query);
            }
        }
        if (this.mIsFindFiltered.equals("true")) {
            this.loadAdditionalFindFilters(query);
        }
        this.loadAdditionalFilters(query);
    }

    protected void loadDefaultFindFilters(MultiStandardObjectQuery query) {
        if (!this.mFindName.equals("")) {
            query.setNameFilter(GlobPattern.create("*" + this.mFindName + "*"));
        }
        if (!this.mFindDescription.equals("")) {
            query.setDescriptionFilter(GlobPattern.create("*" + this.mFindDescription + "*"));
        }
    }

    public void loadCategoryFilters() throws RaplixException {
        CategoriesBean cb = new CategoriesBean();
        cb.loadCategoryFilters();
        this.mCategoryIDs = cb.getCategoryIDs();
        this.mCategoryNames = cb.getCategoryNames();
    }

    protected static VersionRange constructVersionRangeForFilter(String versionNumber) {
        VersionRange range = null;
        String startVersionNumber = versionNumber;
        String endVersionNumber = versionNumber;
        try {
            if (!RegEx.match(RegEx.createPreciseWildcard("([0-9]+).([0-9]+)"), versionNumber)) {
                if (RegEx.match(RegEx.createPreciseWildcard("[0-9]+"), versionNumber)) {
                    startVersionNumber = versionNumber + "." + 0;
                    endVersionNumber = versionNumber + "." + Short.MAX_VALUE;
                } else {
                    startVersionNumber = "-1.0";
                    endVersionNumber = "-1.0";
                }
            }
        }
        catch (RegExSyntaxException e) {
            // empty catch block
        }
        try {
            range = new VersionRange(new VersionNumber(startVersionNumber), true, new VersionNumber(endVersionNumber), true);
        }
        catch (RaplixException e) {
            // empty catch block
        }
        return range;
    }
}

