/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.UIError;
import java.util.Collections;
import java.util.Vector;
import org.apache.struts.util.MessageResources;

public class ServletErrors {
    private String majorError = "";
    private Vector minorErrors = new Vector();
    protected static MessageResources mWebUIMessages = ApplicationResources.getMessageResources();

    public boolean getIsEmpty() {
        return (this.majorError == null || this.majorError.equals("")) && (this.minorErrors == null || this.minorErrors.isEmpty());
    }

    public boolean isSeverityPresent(Severity severity) {
        if (this.getIsEmpty()) {
            return false;
        }
        for (int i = 0; i < this.minorErrors.size(); ++i) {
            UIError uie = (UIError)this.minorErrors.get(i);
            if (!uie.getSeverity().equals(severity)) continue;
            return true;
        }
        return false;
    }

    public void sort() {
        Collections.sort(this.minorErrors, UIError.SEVERITY_ORDER);
    }

    public String getMajorError() {
        return this.majorError;
    }

    public void setMajorError(String error) {
        this.majorError = error;
    }

    public void setMajorErrorKey(String messageKey) {
        this.majorError = mWebUIMessages.getMessage(messageKey);
    }

    public void setMajorErrorROXKey(String messageKey) {
        this.majorError = ROXMessageManager.messageAsString(messageKey);
    }

    public void addMinorError(String message, Severity severity) {
        UIError uie = new UIError(message, severity);
        this.minorErrors.add(uie);
    }

    public void addMinorError(String message) {
        this.addMinorError(message, UIError.DEFAULT_SEVERITY);
    }

    public void addMinorError(RaplixException exception) {
        this.addMinorError(exception.getMessage(), exception.getSeverity());
    }

    public void addMinorError(ROXEvent event) {
        String message = "";
        message = event instanceof ExceptionInterface ? ((ExceptionInterface)((Object)event)).getExceptionDescription() : event.getMessage();
        this.addMinorError(message, Severity.mapEventSeverity(event.getSeverity()));
    }

    public void addMinorErrorKey(String messageKey) {
        this.addMinorError(mWebUIMessages.getMessage(messageKey), UIError.DEFAULT_SEVERITY);
    }

    public void addMinorErrorKey(String messageKey, Object param1) {
        this.addMinorError(mWebUIMessages.getMessage(messageKey, param1), UIError.DEFAULT_SEVERITY);
    }

    public void addMinorErrorKey(String messageKey, Object param1, Object param2) {
        this.addMinorError(mWebUIMessages.getMessage(messageKey, param1, param2), UIError.DEFAULT_SEVERITY);
    }

    public void addMinorErrorKey(String messageKey, Severity severity) {
        this.addMinorError(mWebUIMessages.getMessage(messageKey), severity);
    }

    public void addMinorErrorKey(String messageKey, Object param1, Severity severity) {
        this.addMinorError(mWebUIMessages.getMessage(messageKey, param1), severity);
    }

    public void addMinorErrorKey(String messageKey, Object param1, Object param2, Severity severity) {
        this.addMinorError(mWebUIMessages.getMessage(messageKey, param1, param2), severity);
    }

    public void addMinorErrorROXKey(String messageKey) {
        this.addMinorError(ROXMessageManager.messageAsString(messageKey), UIError.DEFAULT_SEVERITY);
    }

    public void addMinorErrorROXKey(String messageKey, Object[] inArguments) {
        this.addMinorError(ROXMessageManager.messageAsString(messageKey, inArguments), UIError.DEFAULT_SEVERITY);
    }

    public void addMinorErrorROXKey(String messageKey, Severity severity) {
        this.addMinorError(ROXMessageManager.messageAsString(messageKey), severity);
    }

    public void addMinorErrorROXKey(String messageKey, Object[] inArguments, Severity severity) {
        this.addMinorError(ROXMessageManager.messageAsString(messageKey, inArguments), severity);
    }

    public UIError[] getMinorErrors() {
        this.sort();
        return this.minorErrors.toArray(new UIError[0]);
    }
}

