/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.ui.web.ServletBean;

public class RenameBean
extends ServletBean {
    private String mName = "";
    private String mOriginalName = "";
    private String mFilePath = "";
    private boolean mCloseWindow = false;
    private String mObjectType = "";

    public String getName() {
        return this.mName;
    }

    public String getOriginalName() {
        return this.mOriginalName;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public boolean getCloseWindow() {
        return this.mCloseWindow;
    }

    public String getObjectType() {
        return this.mObjectType;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setOriginalName(String originalName) {
        this.mOriginalName = originalName;
    }

    public void setCloseWindow(boolean closeWindow) {
        this.mCloseWindow = closeWindow;
    }

    public void setObjectType(String objectType) {
        this.mObjectType = objectType;
    }

    public void parseFullName() {
        String fullPath = this.mOriginalName;
        if (fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        int lastSlashIndex = fullPath.lastIndexOf("/");
        this.mFilePath = fullPath.substring(0, lastSlashIndex + 1);
        this.mName = fullPath.substring(lastSlashIndex + 1);
    }

    public boolean validateName() {
        boolean retVal = false;
        try {
            if ("folder".equals(this.mObjectType) || "folders".equals(this.mObjectType)) {
                Folder.validateName(this.mName);
                retVal = true;
            } else if ("component".equals(this.mObjectType) || "components".equals(this.mObjectType)) {
                Component.validateName(this.mName);
                retVal = true;
            } else if ("plan".equals(this.mObjectType) || "plans".equals(this.mObjectType)) {
                ExecutionPlan.validateName(this.mName);
                retVal = true;
            }
        }
        catch (RaplixException raplixException) {
            // empty catch block
        }
        return retVal;
    }
}

