/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.RenameBean;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class RenameAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_RENAME_FOLDER = "error.rename.folder";
    public static final String MSG_ERROR_RENAME_COMPONENT = "error.rename.component";
    public static final String MSG_ERROR_RENAME_PLAN = "error.rename.plan";
    public static final String MSG_ERROR_INVALID_NAME = "error.rename.invalidName";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = RenameAction.assertGetParam(request, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through RenameAction:" + mode, this);
        }
        if (mode.equals("init")) {
            this.handleInit(request, servletInfo);
        } else if (mode.equals("rename")) {
            this.handleRename(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
    }

    private void handleRename(HttpServletRequest request, ServletInfo servletInfo) {
        RenameBean bean = (RenameBean)servletInfo.getBean();
        String name = RenameAction.assertGetParam(request, "name");
        this.readFromRequest(request, bean);
        bean.parseFullName();
        bean.setName(name);
        if (bean.validateName()) {
            bean.setCloseWindow(true);
        } else {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorMessageKey(bean.getObjectType()));
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_INVALID_NAME, name);
        }
        servletInfo.setDestPage("/rename.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleInit(HttpServletRequest request, ServletInfo servletInfo) {
        RenameBean bean = (RenameBean)servletInfo.getBean();
        this.readFromRequest(request, bean);
        String originalName = RenameAction.assertGetParam(request, "originalName");
        String objectType = RenameAction.assertGetParam(request, "objectType");
        bean.setOriginalName(originalName);
        bean.parseFullName();
        bean.setObjectType(objectType);
        servletInfo.setDestPage("/rename.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void readFromRequest(HttpServletRequest request, RenameBean bean) {
        bean.setObjectType(RenameAction.assertGetParam(request, "objectType"));
        bean.setOriginalName(RenameAction.assertGetParam(request, "originalName"));
    }

    private String getMajorMessageKey(String objectType) {
        String msgKey = "";
        if ("folder".equals(objectType)) {
            msgKey = MSG_ERROR_RENAME_FOLDER;
        } else if ("component".equals(objectType)) {
            msgKey = MSG_ERROR_RENAME_COMPONENT;
        } else if ("plan".equals(objectType)) {
            msgKey = MSG_ERROR_RENAME_PLAN;
        }
        return msgKey;
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = RenameAction.assertGetParam(inRequest, "mode");
        String objectType = RenameAction.assertGetParam(inRequest, "objectType");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("getMajorError with mode: " + mode, this);
        }
        if (mode.equals("init") || mode.equals("rename")) {
            return this.getMajorMessageKey(objectType);
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to RenameAction.");
    }

    public String getDefaultPage() {
        return "/rename.jsp";
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new RenameBean();
    }

    protected boolean isPopup(HttpServletRequest request) {
        return true;
    }
}

