/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.ServerWebUIApplication;
import com.raplix.rolloutexpress.WebUIApplicationInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.AttributeConstants;
import com.raplix.rolloutexpress.ui.web.HttpMultipartRequestWrapper;
import com.raplix.rolloutexpress.ui.web.PageConstants;
import com.raplix.rolloutexpress.ui.web.ParameterConstants;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Permission;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.util.MessageResources;

public abstract class ROXServlet
extends HttpServlet
implements AttributeConstants,
PageConstants,
ParameterConstants {
    private static final String MSG_FATAL_ERROR = "ui.web.FATAL_ERROR";
    private static final String CHARACTER_ENCODING = "UTF-8";
    private static WebUIApplicationInterface mApplication;
    private static boolean mIsMonolithicApp;
    protected static MessageResources mMessages;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequestCatchErrors(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequestCatchErrors(request, response);
    }

    protected void handleRequestCatchErrors(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.handleRequest(request, response);
        }
        catch (Throwable t) {
            ServletErrors errors = new ServletErrors();
            errors.setMajorError(mMessages.getMessage("error.runtime.major"));
            if (this.isPopup(request)) {
                errors.addMinorError(mMessages.getMessage("error.runtime.popup.minor"));
            } else {
                errors.addMinorError(mMessages.getMessage("error.runtime.minor"));
            }
            Logger.error(ROXMessageManager.messageAsString(MSG_FATAL_ERROR), t, this);
            request.setAttribute("error.location", (Object)errors);
            String errorPage = this.isPopup(request) ? "/popuperrorhome.jsp" : "/errorhome.jsp";
            this.forwardRequest(request, response, errorPage);
        }
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        this.executeServlet(request, response);
    }

    public abstract void executeServlet(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public static String assertGetParam(HttpServletRequest request, String inParamName) throws IllegalArgumentException {
        String val = request.getParameter(inParamName);
        if (val == null) {
            throw new IllegalArgumentException("Required parameter \"" + inParamName + "\" missing.");
        }
        return val;
    }

    public static String assertGetParam(HttpMultipartRequestWrapper request, String inParamName) throws IllegalArgumentException {
        String val = request.getParameter(inParamName);
        if (val == null) {
            throw new IllegalArgumentException("Required parameter \"" + inParamName + "\" missing.");
        }
        return val;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        servletRequest.setCharacterEncoding(CHARACTER_ENCODING);
        super.service(servletRequest, servletResponse);
    }

    public static synchronized void setApplication(WebUIApplicationInterface inApplication) {
        mApplication = inApplication;
        mIsMonolithicApp = inApplication instanceof ServerWebUIApplication;
    }

    public static WebUIApplicationInterface getApplication() {
        return mApplication;
    }

    public static boolean isMonolithicApp() {
        return mIsMonolithicApp;
    }

    public static MessageResources getMessageResources(HttpServletRequest request) {
        return mMessages;
    }

    public void init() throws ServletException {
        super.init();
        mMessages = ApplicationResources.getMessageResources();
    }

    protected void forwardRequest(HttpServletRequest request, HttpServletResponse response, String jspPath) {
        try {
            this.getServletContext().getRequestDispatcher(jspPath).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException servletException) {
            servletException.printStackTrace();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    protected boolean isPopup(HttpServletRequest request) {
        return false;
    }

    public String ACExToString(AccessControlException e) {
        Permission p = e.getPermission();
        if (p == null || !(p instanceof ROXPermission)) {
            return e.getMessage();
        }
        return ((ROXPermission)((Object)p)).getMessage().toString();
    }

    static {
        mIsMonolithicApp = false;
    }
}

