/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.MultiObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanOrder;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.UserFolderPermissions;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.folders.FoldersListBean;
import com.raplix.util.regex.GlobPattern;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;

public class PlansListBean
extends ServletListBean {
    private static final String MSG_LABEL_UNIVERSALSET = "label.universalhostset";
    private static final ExecutionPlanOrder DEFAULT_SORT_ORDER = ExecutionPlanOrder.BY_ACTIVE_DESC;
    private final NotificationRPCInterface mNotificationMgr;
    private String[] mParentFolderNames = new String[0];
    private String[] mPlanNames = new String[0];
    private String[] mPlanDescriptions = new String[0];
    private String[] mPlanVersions = new String[0];
    private String[] mPlanIDs = new String[0];
    private boolean[] mPlanIsRunnings = new boolean[0];
    private boolean[] mIsHidden = new boolean[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String mMode = "";
    private String mFindParentName = "";
    private String mFindVersionNumber = "";
    private boolean mPermWriteOnFolder = false;
    private boolean mAutoRunOnFolder = false;
    private boolean mCheckInCurrentOnFolder = false;
    private String mExecuteHostSetsOnFolder = "";
    private String mDeleteHistoryHostSetsOnFolder = "";
    private String[] mPathFolderNames = new String[0];
    private String[] mPathFolderIDs = new String[0];
    private boolean mWriteOnPlugin = true;
    private boolean mWriteOnFolder = true;

    public PlansListBean(NotificationRPCInterface notificationMgr) {
        this.mNotificationMgr = notificationMgr;
    }

    public String[] getParentFolderNames() {
        return this.mParentFolderNames;
    }

    public String[] getPlanNames() {
        return this.mPlanNames;
    }

    public String[] getPlanVersions() {
        return this.mPlanVersions;
    }

    public String[] getPlanDescriptions() {
        return this.mPlanDescriptions;
    }

    public String[] getPlanIDs() {
        return this.mPlanIDs;
    }

    public boolean[] getPlanIsRunnings() {
        return this.mPlanIsRunnings;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public String getMode() {
        return this.mMode;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public String getFindParentName() {
        return this.mFindParentName;
    }

    public String getFindVersionNumber() {
        return this.mFindVersionNumber;
    }

    public void setFindParentName(String name) {
        this.mFindParentName = name;
    }

    public void setFindVersionNumber(String findVersionNumber) {
        this.mFindVersionNumber = findVersionNumber;
    }

    public boolean getUserHasWriteOnFolder() {
        return this.mPermWriteOnFolder;
    }

    public boolean getAutoRunOnFolder() {
        return this.mAutoRunOnFolder;
    }

    public boolean getCheckInCurrentOnFolder() {
        return this.mCheckInCurrentOnFolder;
    }

    public String getExecuteHostSetsOnFolder() {
        return this.mExecuteHostSetsOnFolder;
    }

    public String getDeleteHistoryHostSetsOnFolder() {
        return this.mDeleteHistoryHostSetsOnFolder;
    }

    public String[] getPathFolderNames() {
        return this.mPathFolderNames;
    }

    public String[] getPathFolderIDs() {
        return this.mPathFolderIDs;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getWriteOnFolder() {
        return this.mWriteOnFolder;
    }

    public void generateList() throws RaplixException {
        MultiExecutionPlanQuery query = MultiExecutionPlanQuery.all();
        query.setCategoryFilter(this.getCategoryFilter());
        this.prepQuery(query, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(query.selectSummaryView());
        this.generatePermissions();
        this.loadBreadCrumbArrays();
    }

    private void generateOutputArrays(SummaryExecutionPlan[] plans) throws RaplixException {
        int i;
        int numPlans = plans.length;
        this.mParentFolderNames = new String[numPlans];
        this.mPlanNames = new String[numPlans];
        this.mPlanDescriptions = new String[numPlans];
        this.mPlanVersions = new String[numPlans];
        this.mPlanIDs = new String[numPlans];
        this.mIsHidden = new boolean[numPlans];
        for (int i2 = 0; i2 < numPlans; ++i2) {
            this.mPlanIDs[i2] = plans[i2].getObjectID().toString();
            this.mParentFolderNames[i2] = FoldersListBean.generateFlatViewPath(plans[i2].getPath().getByIDQuery().selectSummaryView().getFullPathString(), this.getFilePathFilter());
            this.mPlanNames[i2] = plans[i2].getName();
            this.mPlanVersions[i2] = plans[i2].getVersionNumber().getAsString();
            this.mPlanDescriptions[i2] = plans[i2].getDescription();
            this.mIsHidden[i2] = plans[i2].getVisibility().equals(Visibility.HIDDEN);
        }
        Vector runningPlans = this.mNotificationMgr.queryRunningPlans(Integer.MAX_VALUE);
        HashSet<String> hRunningPlans = new HashSet<String>();
        for (i = 0; i < runningPlans.size(); ++i) {
            RunningPlanBean rpb = (RunningPlanBean)runningPlans.get(i);
            hRunningPlans.add(rpb.getExecutionPlanID().toString());
        }
        this.mPlanIsRunnings = new boolean[numPlans];
        for (i = 0; i < numPlans; ++i) {
            this.mPlanIsRunnings[i] = hRunningPlans.contains(this.mPlanIDs[i]);
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mPlanIDs);
        FolderID folderID = new FolderID(this.getFilePathFilter());
        this.mWriteOnFolder = PermissionChecker.hasWriteOnFolder(folderID);
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(folderID.getByIDQuery().selectSummaryView());
    }

    private void generatePermissions() throws RaplixException {
        HostSetIDSet hostsetIDs;
        FolderID id = new FolderID(this.getFilePathFilter());
        UserFolderPermissions ufp = id.getUserPermissions();
        this.mPermWriteOnFolder = ufp.isWrite();
        this.mAutoRunOnFolder = ufp.isAutorun();
        this.mCheckInCurrentOnFolder = ufp.isCheckin();
        if (ufp.isExecuteAllHosts()) {
            this.mExecuteHostSetsOnFolder = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        } else {
            hostsetIDs = ufp.getExecuteHostSets();
            this.mExecuteHostSetsOnFolder = Util.hostSets2String(hostsetIDs);
        }
        if (ufp.isDeleteHistoryAllHosts()) {
            this.mDeleteHistoryHostSetsOnFolder = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        } else {
            hostsetIDs = ufp.getDeleteHistoryHostSets();
            this.mDeleteHistoryHostSetsOnFolder = Util.hostSets2String(hostsetIDs);
        }
    }

    private void loadBreadCrumbArrays() throws RaplixException {
        FolderID folderID = new FolderID(this.getFilePathFilter());
        this.mPathFolderNames = ChangePathBean.getFolderPathNames(folderID);
        this.mPathFolderIDs = ChangePathBean.getFolderPathIDs(folderID);
    }

    public void updateCategories(String[] ids, String[] catIDs, boolean replaceExisting, boolean allVersions) throws RaplixException {
        int numPlans = ids.length;
        ExecutionPlanID[] planIDs = new ExecutionPlanID[numPlans];
        for (int i = 0; i < numPlans; ++i) {
            planIDs[i] = new ExecutionPlanID(ids[i]);
        }
        int numCatIDS = catIDs.length;
        CategoryID[] categoryIDs = new CategoryID[numCatIDS];
        for (int i = 0; i < numCatIDS; ++i) {
            categoryIDs[i] = new CategoryID(catIDs[i]);
        }
        CategoryIDSet catIDSet = new CategoryIDSet(Arrays.asList(categoryIDs));
        CategoryUpdateContext ctx = new CategoryUpdateContext(catIDSet);
        ctx.setReplaceExisting(replaceExisting);
        ctx.setAllVersions(allVersions);
        ExecutionPlanIDSet idSet = new ExecutionPlanIDSet(Arrays.asList(planIDs));
        idSet.getByIDsQuery().updateCategories(ctx);
    }

    public void move(String[] ids, String movePath) throws RaplixException {
        ExecutionPlanID[] planIDs = new ExecutionPlanID[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            planIDs[i] = new ExecutionPlanID(ids[i]);
        }
        ExecutionPlanIDSet idSet = new ExecutionPlanIDSet(Arrays.asList(planIDs));
        idSet.getByIDsQuery().move(new FolderID(movePath));
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(ExecutionPlanOrder.FACTORY, sortName);
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    public boolean getCanBeHidden() {
        return true;
    }

    protected void loadAdditionalFindFilters(MultiObjectQuery query) throws RaplixException {
        MultiExecutionPlanQuery mpq = (MultiExecutionPlanQuery)query;
        if (!this.mFindParentName.equals("")) {
            FullPathFilter pathFilter = mpq.getFullPathFilter();
            if (pathFilter == null) {
                pathFilter = new FullPathFilter();
            }
            pathFilter.setPathFilter(GlobPattern.create("*" + this.mFindParentName + "*"));
            mpq.setFullPathFilter(pathFilter);
        }
        if (!this.mFindVersionNumber.equals("")) {
            VersionRange range = ServletListBean.constructVersionRangeForFilter(this.mFindVersionNumber);
            mpq.setVersionFilter(range);
        }
    }

    protected void loadAdditionalFilters(MultiObjectQuery query) throws RaplixException {
        MultiExecutionPlanQuery mpq = (MultiExecutionPlanQuery)query;
        FolderID folderID = new FolderID(this.getFilePathFilter());
        boolean isRecursive = this.getFlatView();
        FullPathFilter pathFilter = mpq.getFullPathFilter();
        if (pathFilter == null) {
            pathFilter = new FullPathFilter();
        }
        pathFilter.setSearchRoot(folderID);
        pathFilter.setRecursiveMode(isRecursive);
        mpq.setFullPathFilter(pathFilter);
    }
}

