/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.executor.HostsUnpreparedException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.HttpMultipartRequestWrapper;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.PlanVersionHistoryBean;
import com.raplix.rolloutexpress.ui.web.PlansBean;
import com.raplix.rolloutexpress.ui.web.PlansErrorConstants;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionException;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.IOException;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletRequest;

public class PlansHandleAction
extends UIActionServlet
implements ActionModeConstants,
PlansErrorConstants {
    public void doUIAction(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        HttpMultipartRequestWrapper wrapper = null;
        try {
            wrapper = HttpMultipartRequestWrapper.wrapRequest(inRequest);
        }
        catch (Exception e) {
            throw new RaplixException(e);
        }
        String mode = wrapper.assertGetParameter("mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through PlansHandleAction: " + mode, this);
        }
        if (mode.equals("details")) {
            this.handleDetails(inRequest, servletInfo);
        } else if (mode.equals("rundetails")) {
            this.handleRunDetails(inRequest, servletInfo);
        } else if (mode.equals("rundetailsgen")) {
            this.handleRunDetailsGen(inRequest, servletInfo);
        } else if (mode.equals("versionhistory")) {
            this.handleVersionHistory(inRequest, servletInfo);
        } else if (mode.equals("updatevisibility")) {
            this.handleUpdateVisibility(wrapper, servletInfo);
        } else if (mode.equals("updatevisibilityofall")) {
            this.handleUpdateVisibilityAll(inRequest, servletInfo);
        } else if (mode.equals("applycategories")) {
            this.handleApplyCategories(inRequest, servletInfo);
        } else if (mode.equals("updatecategories")) {
            this.handleUpdateCategories(inRequest, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(inRequest, servletInfo);
        } else if (mode.equals("startpfonly")) {
            this.handleStartPreflight(inRequest, servletInfo);
        } else if (mode.equals("startpfrun")) {
            this.handleStartRun(inRequest, servletInfo);
        } else if (mode.equals("runhistory")) {
            this.handleRunHistory(inRequest, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(inRequest, servletInfo);
        } else if (mode.equals("generate")) {
            this.handleGenerate(inRequest, servletInfo);
        } else if (mode.equals("create")) {
            this.handleCreate(wrapper, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(wrapper, servletInfo);
        } else if (mode.equals("checkin")) {
            this.handleCheckin(wrapper, servletInfo);
        } else if (mode.equals("checkinas")) {
            this.handleCheckinAs(wrapper, servletInfo);
        } else if (mode.equals("movecheckin")) {
            this.handleMoveCheckin(wrapper, servletInfo);
        } else if (mode.equals("checkincancel")) {
            this.handleCheckinCancel(wrapper, servletInfo);
        } else if (mode.equals("checkinconfirmed")) {
            this.handleCheckinConfirmed(wrapper, servletInfo);
        } else if (mode.equals("replace")) {
            this.handleReplace(wrapper, servletInfo);
        } else if (mode.equals("rename")) {
            this.handleRename(inRequest, servletInfo);
        } else if (mode.equals("move")) {
            this.handleMove(inRequest, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to PlansHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest inRequest) {
        HttpMultipartRequestWrapper wrapper = null;
        try {
            wrapper = HttpMultipartRequestWrapper.wrapRequest(inRequest);
        }
        catch (IOException e) {
            throw new IllegalStateException("got IOException and can't throw it.");
        }
        String mode = wrapper.assertGetParameter("mode");
        PlanInterface planInterface = PlansHandleAction.getApplication().getPlanInterface();
        SessionManager sessionManager = PlansHandleAction.getApplication().getUserSessionManager();
        NotificationRPCInterface notificationMgr = PlansHandleAction.getApplication().getNotificationInterface();
        UserManager userDBInf = PlansHandleAction.getApplication().getUserManager();
        PlansBean bean = null;
        if (mode.equals("details") || mode.equals("rundetails") || mode.equals("rundetailsgen") || mode.equals("versionhistory") || mode.equals("updatevisibilityofall") || mode.equals("runhistory") || mode.equals("generate") || mode.equals("create") || mode.equals("rename") || mode.equals("move")) {
            bean = new PlansBean(planInterface, sessionManager, notificationMgr, userDBInf);
        } else {
            String id = wrapper.getParameter("id");
            bean = (PlansBean)wrapper.getSession().getAttribute(id);
            if (bean == null) {
                throw new IllegalArgumentException("Expected Bean not found.");
            }
        }
        return bean;
    }

    public String getDefaultPage() {
        return "/planDetails.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        HttpMultipartRequestWrapper wrapper = null;
        try {
            wrapper = HttpMultipartRequestWrapper.wrapRequest(request);
        }
        catch (IOException e) {
            throw new IllegalStateException("got IOException and can't throw it");
        }
        String mode = wrapper.assertGetParameter("mode");
        if (mode.equals("details")) {
            return "error.plans.details";
        }
        if (mode.equals("rundetails")) {
            return "error.plans.details";
        }
        if (mode.equals("rundetailsgen")) {
            return "error.plans.details";
        }
        if (mode.equals("versionhistory")) {
            return "error.plans.versionhistory";
        }
        if (mode.equals("updatevisibility")) {
            return "error.plans.visibility";
        }
        if (mode.equals("updatevisibilityofall")) {
            return "error.plans.visibility";
        }
        if (mode.equals("applycategories")) {
            return "error.plans.categories";
        }
        if (mode.equals("updatecategories")) {
            return "error.plans.categories";
        }
        if (mode.equals("refresh")) {
            return "error.plans.details";
        }
        if (mode.equals("startpfonly")) {
            return "error.plans.preflight";
        }
        if (mode.equals("startpfrun")) {
            return "error.plans.run";
        }
        if (mode.equals("runhistory")) {
            return "error.planrunhistory.list";
        }
        if (mode.equals("cancel")) {
            return "error.plans.loading";
        }
        if (mode.equals("generate")) {
            return "error.plans.auth.create";
        }
        if (mode.equals("create")) {
            return "error.plans.auth.create";
        }
        if (mode.equals("edit")) {
            return "error.plans.auth.edit";
        }
        if (mode.equals("replace")) {
            return "error.plans.auth.replace";
        }
        if (mode.equals("checkin")) {
            return "error.plans.auth.checkin";
        }
        if (mode.equals("checkinas")) {
            return "error.plans.auth.checkin";
        }
        if (mode.equals("movecheckin")) {
            return "error.plans.auth.move.checkin";
        }
        if (mode.equals("checkincancel")) {
            return "error.plans.auth.checkin";
        }
        if (mode.equals("checkinconfirmed")) {
            return "error.plans.auth.checkinconfirmed";
        }
        if (mode.equals("rename")) {
            return "error.plans.rename.major";
        }
        if (mode.equals("move")) {
            return "error.plans.move.major";
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to PlansHandleAction.");
    }

    private void handleDetails(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        String id = PlansHandleAction.assertGetParam(inRequest, "id");
        PlansBean bean = (PlansBean)servletInfo.getBean();
        bean.loadPlanDefinitionByID(id);
        this.updateFilePath(inRequest, servletInfo);
        servletInfo.setDestPage("/planDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleRunDetails(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        String id = PlansHandleAction.assertGetParam(inRequest, "id");
        PlansBean bean = (PlansBean)servletInfo.getBean();
        bean.loadPlanDefaults();
        bean.loadPlanDefinitionByID(id);
        bean.loadHostInformation();
        bean.loadSingleHostSelectorPlan();
        bean.loadPlanPromptInfo();
        servletInfo.setDestPage("/planRunDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleRunDetailsGen(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String componentID = PlansHandleAction.assertGetParam(inRequest, "componentID");
        String procedureType = PlansHandleAction.assertGetParam(inRequest, "procedureType");
        String procedureName = PlansHandleAction.assertGetParam(inRequest, "procedureName");
        String hostNames = inRequest.getParameter("hostNames");
        String paths = inRequest.getParameter("installPaths");
        String componentName = inRequest.getParameter("componentName");
        String componentVersion = inRequest.getParameter("componentVersion");
        bean.setComponentName(componentName);
        bean.setComponentVersion(componentVersion);
        bean.directAction(componentID, procedureType, procedureName, paths);
        bean.loadPlanDefaults();
        bean.loadPlanDefinitionByID(bean.getID());
        bean.loadHostInformation();
        bean.loadSingleHostSelectorPlan();
        bean.loadPlanPromptInfo();
        if (procedureType.equals(NamedBlockType.UNINSTALL.toString()) || procedureType.equals(NamedBlockType.CONTROL.toString())) {
            bean.setHostNames(StringUtil.split(hostNames, ",", ""));
            bean.setInstallPaths(StringUtil.split(paths, ",", ""));
            bean.setTargetsLocked(true);
        }
        bean.setVersionsLocked(true);
        servletInfo.setDestPage("/planRunDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleVersionHistory(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String id = PlansHandleAction.assertGetParam(request, "id");
        String sortName = request.getParameter("sortName");
        bean.loadPlanDefinitionByID(id);
        bean.loadPlanVersionHistory(sortName);
        servletInfo.setDestPage("/planVersionHistory.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleUpdateVisibility(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String updateID = request.getParameter("updateID");
        if (updateID == null) {
            updateID = PlansHandleAction.assertGetParam(request, "id");
        }
        String isHidden = PlansHandleAction.assertGetParam(request, "isHidden");
        String destination = PlansHandleAction.assertGetParam(request, "destination");
        boolean isHiddenVal = isHidden.equals("true");
        try {
            bean.updateVisibility(updateID, isHiddenVal);
        }
        catch (AccessControlException ex) {
            servletInfo.getErrors().setMajorErrorKey("error.plans.visibility");
            servletInfo.getErrors().addMinorError(this.ACExToString(ex));
        }
        if (destination.equals("/planVersionHistory.jsp")) {
            bean.loadPlanVersionHistory();
        } else {
            String definition = request.getParameter("definition");
            if (definition != null) {
                bean.setDefinition(definition);
            }
        }
        servletInfo.setDestPage(destination);
        servletInfo.setShouldRedirect(false);
    }

    private void handleUpdateVisibilityAll(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String id = PlansHandleAction.assertGetParam(request, "id");
        String isHidden = PlansHandleAction.assertGetParam(request, "isHidden");
        boolean isHiddenVal = isHidden.equals("true");
        bean.loadPlanDefinitionByID(id);
        bean.loadPlanVersionHistory();
        PlanVersionHistoryBean versionBean = bean.getPlanVersionHistoryBean();
        try {
            versionBean.updateVisibilityAll(id, isHiddenVal);
            if (bean.getID().equals(id)) {
                bean.setIsHidden(isHiddenVal);
            }
        }
        catch (AccessControlException ex) {
            servletInfo.getErrors().setMajorErrorKey("error.plans.visibility");
            servletInfo.getErrors().addMinorError(this.ACExToString(ex));
        }
        servletInfo.setDestPage("/planVersionHistory.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleApplyCategories(HttpServletRequest request, ServletInfo servletInfo) {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String planID = PlansHandleAction.assertGetParam(request, "id");
        String redirectURI = PlansHandleAction.assertGetParam(request, "redirecturi");
        String[] categoryIDs = new String[]{};
        CategoryIDSet idSet = bean.getCategoryIDSet();
        if (idSet != null) {
            CategoryID[] catIDs = idSet.toIDArray();
            int numCatIDs = catIDs.length;
            categoryIDs = new String[numCatIDs];
            for (int i = 0; i < numCatIDs; ++i) {
                categoryIDs[i] = catIDs[i].toString();
            }
        }
        MultiCheckbox sharedCategoryMC = new MultiCheckbox("", categoryIDs);
        sharedCategoryMC.setSelectedAll();
        String sharedCategoryMCID = sharedCategoryMC.getID();
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(sharedCategoryMCID, sharedCategoryMC);
        String destPage = "/CategoriesPicker?mode=list&redirecturi=" + Util.encodeURL(redirectURI) + "&" + "categoryItemID" + "=" + planID + "&" + "categoryID" + "=" + sharedCategoryMCID;
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(false);
    }

    public void handleUpdateCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String planID = PlansHandleAction.assertGetParam(request, "id");
        String categoryMCID = PlansHandleAction.assertGetParam(request, "categoryID");
        String selected = PlansHandleAction.assertGetParam(request, "selected");
        boolean replaceExisting = "true".equals(PlansHandleAction.assertGetParam(request, "replaceExisting"));
        boolean allVersions = request.getParameter("allVersions") != null;
        MultiCheckbox categoryMC = (MultiCheckbox)request.getSession().getAttribute(categoryMCID);
        categoryMC.setSelected(selected);
        String[] categoryIDs = categoryMC.getSelected();
        bean.updateCategories(planID, categoryIDs, replaceExisting, allVersions);
        String destPage = "/PlanDetails?mode=details&id=" + planID;
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(true);
    }

    private void handleRefresh(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        bean.refreshVarSettingChoices();
        this.loadUserParameters(inRequest, bean);
        bean.loadPlanPromptInfo();
        servletInfo.setDestPage("/planRunDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleStartPreflight(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        this.handleStartPreflightOrRun(inRequest, servletInfo, true);
    }

    private void handleStartRun(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        this.handleStartPreflightOrRun(inRequest, servletInfo, false);
    }

    private void handleStartPreflightOrRun(HttpServletRequest inRequest, ServletInfo servletInfo, boolean isPreflight) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        this.loadUserParameters(inRequest, bean);
        try {
            bean.loadFinalHostIDs();
            bean.executePlan(isPreflight);
        }
        catch (UIActionException ex) {
            this.handleExceptionInRun(inRequest, servletInfo, ex);
            return;
        }
        catch (RaplixException ex) {
            this.handleExceptionInRun(inRequest, servletInfo, ex);
            return;
        }
        String forwardURL = Util.preflightLiveURI(bean.getTaskID().toString());
        servletInfo.setDestPage(forwardURL);
        servletInfo.setShouldRedirect(true);
    }

    private void handleRunHistory(HttpServletRequest inRequest, ServletInfo servletInfo) {
        String id = PlansHandleAction.assertGetParam(inRequest, "id");
        String forwardURL = "/PlanRunHistory?id=" + id;
        servletInfo.setDestPage(forwardURL);
        servletInfo.setShouldRedirect(true);
    }

    private void handleCancel(HttpServletRequest inRequest, ServletInfo servletInfo) {
        String forwardURL = "/Plans";
        servletInfo.setDestPage(forwardURL);
        servletInfo.setShouldRedirect(true);
    }

    private void handleGenerate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        request.getSession().setAttribute(bean.getID(), (Object)bean);
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String folderID = spb.trackString(Preference.FILE_PATH, request);
        String componentID = PlansHandleAction.assertGetParam(request, "componentID");
        String procedureTypes = PlansHandleAction.assertGetParam(request, "procedureTypes");
        String procedureNames = PlansHandleAction.assertGetParam(request, "procedureNames");
        String[] procedureTypesArray = StringUtil.split(procedureTypes, ",", "");
        String[] procedureNamesArray = StringUtil.split(procedureNames, ",", "");
        bean.setName("");
        bean.setFolderID(folderID);
        bean.generatePlan(componentID, procedureTypesArray, procedureNamesArray);
        bean.setIsNew(true);
        servletInfo.setDestPage("/planEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCreate(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        request.getSession().setAttribute(bean.getID(), (Object)bean);
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String folderID = spb.trackString(Preference.FILE_PATH, request.getRequest());
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        bean.setName(name);
        bean.setDescription(description);
        bean.setFolderID(folderID);
        bean.generateBlankDefinition();
        bean.setIsNew(true);
        servletInfo.setDestPage("/planEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleReplace(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        String name = request.getParameter("name");
        String xml = null;
        try {
            xml = request.getParameter("uploadxml");
        }
        catch (OutOfMemoryError er) {
            servletInfo.getErrors().setMajorErrorKey("error.plans.auth.replace");
            servletInfo.getErrors().addMinorErrorKey("error.plans.auth.filetoobig");
            servletInfo.setDestPage("/planEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        PlansBean bean = (PlansBean)servletInfo.getBean();
        if (name != null) {
            bean.setName(name);
        }
        if (xml == null || xml.equals("")) {
            servletInfo.getErrors().setMajorErrorKey("error.plans.auth.replace");
            servletInfo.getErrors().addMinorErrorKey("error.plans.auth.xmlnotfound");
        } else if (xml.equals("error.HttpMultipartRequestWrapper.UnsupportedEncoding.major")) {
            servletInfo.getErrors().setMajorErrorKey("error.HttpMultipartRequestWrapper.UnsupportedEncoding.major");
            servletInfo.getErrors().addMinorErrorKey("error.HttpMultipartRequestWrapper.UnsupportedEncoding.minor", request.getCharacterEncoding());
        } else {
            bean.setDefinition(xml);
        }
        servletInfo.setDestPage("/planEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        String id = request.assertGetParameter("id");
        PlansBean bean = (PlansBean)servletInfo.getBean();
        bean.loadPlanDefinitionByID(id);
        bean.setIsNew(false);
        servletInfo.setDestPage("/planEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckin(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        String definition = request.assertGetParameter("definition");
        String name = request.getParameter("name");
        PlansBean bean = (PlansBean)servletInfo.getBean();
        bean.setName(name);
        bean.setDefinition(definition);
        bean.setMode("checkin");
        String xmlName = null;
        try {
            xmlName = bean.verifyPlanDefinition();
        }
        catch (Exception e) {
            servletInfo.getErrors().setMajorErrorKey("error.planauth.invalidplan");
            servletInfo.getErrors().addMinorError(e.toString());
            servletInfo.setDestPage("/planEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        if (xmlName != null && !bean.getName().equals(xmlName)) {
            servletInfo.getErrors().setMajorErrorKey("error.planauth.namediffer");
        }
        servletInfo.setDestPage("/planCheckin.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckinAs(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        String definition = request.assertGetParameter("definition");
        String name = request.getParameter("name");
        PlansBean bean = (PlansBean)servletInfo.getBean();
        bean.setName(name);
        bean.setDefinition(definition);
        bean.setMode("checkinas");
        String xmlName = null;
        try {
            xmlName = bean.verifyPlanDefinition();
        }
        catch (Exception e) {
            servletInfo.getErrors().setMajorErrorKey("error.planauth.invalidplan");
            servletInfo.getErrors().addMinorError(e.toString());
            servletInfo.setDestPage("/planEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        if (xmlName != null && !bean.getName().equals(xmlName)) {
            servletInfo.getErrors().setMajorErrorKey("error.planauth.namediffer");
        }
        bean.checkpointState();
        servletInfo.setDestPage("/planCheckin.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleMoveCheckin(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String name = PlansHandleAction.assertGetParam(request, "name");
        String folderID = PlansHandleAction.assertGetParam(request, "planPath");
        bean.setName(name);
        bean.setFolderID(folderID);
        FolderID id = new FolderID(folderID);
        bean.setWriteOnPlugin(PermissionChecker.hasWriteOnPlugin(id.getByIDQuery().selectSummaryView()));
        bean.setWriteOnFolder(PermissionChecker.hasWriteOnFolder(id));
        servletInfo.setDestPage("/planCheckin.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckinConfirmed(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String folderID = request.getParameter("planPath");
        String majorVersion = request.getParameter("isMajorVersion");
        String isHidingPrevious = request.getParameter("isHidingPrevious");
        if (name != null) {
            bean.setName(name);
        }
        if (folderID != null) {
            bean.setFolderID(folderID);
        }
        bean.setIsMajorVersion("true".equals(majorVersion));
        bean.setIsHidingPrevious(isHidingPrevious != null);
        try {
            bean.checkinPlan();
        }
        catch (PersistenceManagerException e) {
            this.handleExceptionInCheckin(servletInfo, e);
            return;
        }
        catch (AccessControlException e) {
            this.handleExceptionInCheckin(servletInfo, e);
            return;
        }
        this.updateFilePath(request.getRequest(), servletInfo);
        String url = UriUtil.planDetailsURI(bean.getID());
        servletInfo.setDestPage(url);
        servletInfo.setShouldRedirect(true);
    }

    private void handleCheckinCancel(HttpMultipartRequestWrapper request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        if (bean.getMode().equals("checkinas")) {
            bean.rollbackState();
        }
        servletInfo.setDestPage("/planEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void loadUserParameters(HttpServletRequest request, PlansBean bean) {
        String nativeUnits;
        String hostsRunningLimit;
        String componentVersion;
        int expectedLength = bean.getPlanNames().length;
        String[] hostCheckedArray = new String[expectedLength];
        String[] hostSetCheckedArray = new String[expectedLength];
        String[] hostNames = new String[expectedLength];
        String[] installPaths = new String[expectedLength];
        String[] hostSetIDs = new String[expectedLength];
        for (int i = 0; i < expectedLength; ++i) {
            hostCheckedArray[i] = request.getParameter("hostChecked" + i) == null ? "false" : "true";
            hostSetCheckedArray[i] = request.getParameter("hostSetChecked" + i) == null ? "false" : "true";
            hostNames[i] = request.getParameter("hostNames" + i);
            installPaths[i] = request.getParameter("installPaths" + i);
            if (installPaths[i] == null) {
                installPaths[i] = "";
            }
            hostSetIDs[i] = request.getParameter("hostSetIDs" + i);
        }
        String componentName = request.getParameter("componentName");
        if (componentName != null) {
            bean.setComponentName(componentName);
        }
        if ((componentVersion = request.getParameter("componentVersion")) != null) {
            bean.setComponentVersion(componentVersion);
        }
        bean.setTargetsLocked(request.getParameter("targetsLocked") != null);
        bean.setVersionsLocked(request.getParameter("versionsLocked") != null);
        bean.setUsingSameTargets(request.getParameter("usingSameTargets") != null);
        bean.setPreparePopupNeeded(false);
        bean.setHostChecked(hostCheckedArray);
        bean.setHostSetChecked(hostSetCheckedArray);
        bean.setHostNames(hostNames);
        bean.setHostSetIDs(hostSetIDs);
        this.loadPromptValues(request, bean);
        if (request.getParameter("performDetailedPreflight") != null) {
            bean.setPerformDetailedPreflight(true);
        }
        if ((hostsRunningLimit = request.getParameter("hostsRunningLimit")) != null && !hostsRunningLimit.trim().equals("")) {
            bean.setHostsRunningLimit(hostsRunningLimit);
        }
        if ((nativeUnits = request.getParameter("nativeLimitUnits")) == null) {
            Logger.debug("Didn't get a value for native units.", this);
            nativeUnits = "hours";
        }
        bean.setNativeLimitUnits(nativeUnits);
        String nativeValue = request.getParameter("nativeLimitValue");
        if (nativeValue == null || nativeValue.trim().equals("")) {
            nativeValue = "0";
        }
        bean.setNativeLimitValue(nativeValue);
        String overallUnits = request.getParameter("overallLimitUnits");
        if (overallUnits == null) {
            Logger.debug("Didn't get a value for native units.", this);
            overallUnits = "hours";
        }
        bean.setOverallLimitUnits(overallUnits);
        String overallValue = request.getParameter("overallLimitValue");
        if (overallValue == null || overallValue.trim().equals("")) {
            overallValue = "0";
        }
        bean.setOverallLimitValue(overallValue);
        this.loadComponentChoices(request, bean);
    }

    private void loadPromptValues(HttpServletRequest request, PlansBean bean) {
        int numPrompts = bean.getPromptMessages().length;
        String[] promptValues = new String[numPrompts];
        for (int i = 0; i < numPrompts; ++i) {
            if (bean.getPromptModes()[i].equals("checkbox")) {
                if (request.getParameter("promptValues" + i) != null) {
                    promptValues[i] = "true";
                    continue;
                }
                promptValues[i] = "false";
                continue;
            }
            promptValues[i] = PlansHandleAction.assertGetParam(request, "promptValues" + i);
        }
        bean.setPromptValues(promptValues);
    }

    private void loadComponentChoices(HttpServletRequest request, PlansBean bean) {
        String[][] componentChoices = null;
        String[][] varSettingChoices = null;
        int numPlans = bean.getPlanNames().length;
        componentChoices = new String[numPlans][];
        varSettingChoices = new String[numPlans][];
        for (int i = 0; i < numPlans; ++i) {
            int numComponents = bean.getComponentNames(i).length;
            componentChoices[i] = new String[numComponents];
            varSettingChoices[i] = new String[numComponents];
            for (int j = 0; j < numComponents; ++j) {
                componentChoices[i][j] = PlansHandleAction.assertGetParam(request, "componentIDs" + i + "_" + j);
                varSettingChoices[i][j] = PlansHandleAction.assertGetParam(request, "varSettingsIDs" + i + "_" + j);
            }
        }
        bean.setComponentChoices(componentChoices);
        bean.setVarSettingChoices(varSettingChoices);
    }

    private void handleExceptionInRun(HttpServletRequest request, ServletInfo servletInfo, Exception ex) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        bean.loadPlanPromptInfo();
        if (ex instanceof HostsUnpreparedException) {
            HostIDSet his = ((HostsUnpreparedException)ex).getUnpreppedHostSet();
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put("session.hostidset", his);
            bean.setPreparePopupNeeded(true);
        }
        servletInfo.getErrors().setMajorErrorKey("error.plans.run");
        servletInfo.getErrors().addMinorError(ex.getMessage());
        servletInfo.setDestPage("/planRunDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleExceptionInCheckin(ServletInfo servletInfo, Exception ex) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        servletInfo.setDestPage("/planCheckin.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.getErrors().setMajorErrorKey("error.plans.auth.checkinconfirmed");
        if (!(ex instanceof AccessControlException)) {
            servletInfo.getErrors().addMinorError(ex.getMessage());
        } else {
            servletInfo.getErrors().addMinorError(this.ACExToString((AccessControlException)ex));
        }
        if (bean.getIsNew() || bean.getMode().equals("checkinas")) {
            bean.recyclePlanObject();
        }
    }

    private void handleRename(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String id = PlansHandleAction.assertGetParam(request, "id");
        String newName = PlansHandleAction.assertGetParam(request, "newName");
        bean.loadPlanDefinitionByID(id);
        try {
            bean.renamePlan(newName);
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey("error.plans.rename.major");
            servletInfo.getErrors().addMinorError(re.getMessage());
            servletInfo.setDestPage("/planDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        bean.loadPlanDefinitionByID(id);
        servletInfo.setDestPage("/planDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleMove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlansBean bean = (PlansBean)servletInfo.getBean();
        String id = PlansHandleAction.assertGetParam(request, "id");
        String newPathID = PlansHandleAction.assertGetParam(request, "movePath");
        bean.loadPlanDefinitionByID(id);
        try {
            bean.movePlan(newPathID);
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey("error.plans.move.major");
            servletInfo.getErrors().addMinorError(re.getMessage());
            servletInfo.setDestPage("/planDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        bean.loadPlanDefinitionByID(id);
        this.updateFilePath(request, servletInfo);
        servletInfo.setDestPage("/planDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void updateFilePath(HttpServletRequest request, ServletInfo servletInfo) {
        PlansBean pb = (PlansBean)servletInfo.getBean();
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String filePath = ChangePathBean.verifyFolderID(pb.getFolderID());
        spb.setString(Preference.FILE_PATH, filePath);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("updateFilePath: path is now " + filePath, this);
        }
    }
}

