/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.executor.TaskDescriptor;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.componentdb.VariableSettingsSelector;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.plandb.DisplayMode;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import com.raplix.rolloutexpress.systemmodel.plandb.SingleExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.PlanVersionHistoryBean;
import com.raplix.rolloutexpress.ui.web.PlansErrorConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UIActionException;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlansBean
extends ServletBean
implements PlansErrorConstants {
    private final PlanInterface mPlanInterface;
    private final SessionManager mSessionManager;
    private final NotificationRPCInterface mNotificationMgr;
    private final UserManager mUserDBInterface;
    private PlanVersionHistoryBean mVersionBean = null;
    private String mName = "";
    private String mFullName = "";
    private String mFolderID = "";
    private String mFolderPath = "";
    private String mDescription = "";
    private String mVersion = "";
    private boolean mIsHidden = false;
    private String mCheckedInDate = "";
    private String mCheckedInUserName = "";
    private String mPlanID = "";
    private String mCatNamesString = "";
    private CategoryIDSet mCategoryIDSet = null;
    private String mPluginName = null;
    private String mPluginID = null;
    private boolean mWriteOnPlugin = true;
    private boolean mExecuteOnFolder = true;
    private boolean mWriteOnFolder = true;
    private boolean mWriteOnAnyFolder = true;
    private String mDefinition = "";
    private boolean mIsNew = false;
    private boolean mIsMajorVersion = false;
    private boolean mIsHidingPrevious = true;
    private String mNextMinorVersion = "";
    private String mNextMajorVersion = "";
    private String mLatestVersion = "";
    private String mMode = "";
    private String mPreviousName = "";
    private String mPreviousVersion = "";
    private ExecutionPlanID mPreviousID = null;
    private boolean mPreparePopupNeeded = false;
    private boolean mUsingSameTargets = true;
    private boolean mIsSimplePlan = true;
    private String[] mPlanNames = new String[0];
    private String[] mLimitHostSetIDs = new String[0];
    private String[] mHostSetIDs = new String[0];
    private String[] mHostChecked = new String[0];
    private String[] mHostSetChecked = new String[0];
    private String[] mHostNames = new String[0];
    private String[] mInstallPaths = new String[0];
    private boolean mTargetsLocked = false;
    private boolean mVersionsLocked = false;
    private String[] mPromptMessages = new String[0];
    private String[] mPromptValues = new String[0];
    private String[] mPromptModes = new String[0];
    private boolean mPerformDetailedPreflight;
    private String mHostsRunningLimit;
    private String mOverallLimitUnits = "minutes";
    private String mNativeLimitUnits = "minutes";
    private String[] mAllHostSetNames = new String[0];
    private String[] mAllHostSetIDs = new String[0];
    private String mOverallLimitValue = "30";
    private String mNativeLimitValue = "30";
    private String[] mTimeUnits = new String[]{"hours", "minutes"};
    private String[] mTimeLabels = new String[]{"hours", "minutes"};
    private String mComponentName = "";
    private String mComponentVersion = "";
    private HostID[][] mFinalHostIDs = null;
    private TaskID mTaskID = null;
    private TaskDescriptor mTaskDescriptor = null;
    private SubplanPrompt[] mPrompts = null;
    private ExecutionPlan mExecutionPlan = null;
    private ExecutionPlan mOldExecutionPlan = null;

    public PlansBean(PlanInterface planInterface, SessionManager sessionManager, NotificationRPCInterface notificationMgr, UserManager userMgr) {
        this.mPlanInterface = planInterface;
        this.mSessionManager = sessionManager;
        this.mNotificationMgr = notificationMgr;
        this.mUserDBInterface = userMgr;
    }

    public String getID() {
        if (this.getPlanID() != null && !this.getPlanID().equals("")) {
            return this.getPlanID();
        }
        return super.getID();
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        return this.mFullName;
    }

    public String getFolderID() {
        return this.mFolderID;
    }

    public String getFolderPath() {
        return this.mFolderPath;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public boolean getIsHidden() {
        return this.mIsHidden;
    }

    public String getCheckedInDate() {
        return this.mCheckedInDate;
    }

    public String getCheckedInUserName() {
        return this.mCheckedInUserName;
    }

    public String getPlanID() {
        return this.mPlanID;
    }

    public String getCatNamesString() {
        return this.mCatNamesString;
    }

    public String getDefinition() {
        return this.mDefinition;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public boolean getIsMajorVersion() {
        return this.mIsMajorVersion;
    }

    public boolean getIsHidingPrevious() {
        return this.mIsHidingPrevious;
    }

    public String getNextMinorVersion() {
        return this.mNextMinorVersion;
    }

    public String getNextMajorVersion() {
        return this.mNextMajorVersion;
    }

    public String getMode() {
        return this.mMode;
    }

    public String getPreviousName() {
        return this.mPreviousName;
    }

    public String getPreviousVersion() {
        return this.mPreviousVersion;
    }

    public boolean getPreparePopupNeeded() {
        return this.mPreparePopupNeeded;
    }

    public boolean getUsingSameTargets() {
        return this.mUsingSameTargets;
    }

    public boolean isSimplePlan() {
        return this.mIsSimplePlan;
    }

    public boolean isCompositePlan() {
        return !this.isSimplePlan();
    }

    public String[] getPlanNames() {
        return this.mPlanNames;
    }

    public String[] getLimitHostSetIDs() {
        return this.mLimitHostSetIDs;
    }

    public String[] getHostSetIDs() {
        return this.mHostSetIDs;
    }

    public String[] getHostChecked() {
        return this.mHostChecked;
    }

    public String[] getHostSetChecked() {
        return this.mHostSetChecked;
    }

    public String[] getHostNames() {
        return this.mHostNames;
    }

    public String[] getInstallPaths() {
        return this.mInstallPaths;
    }

    public boolean getTargetsLocked() {
        return this.mTargetsLocked;
    }

    public boolean getVersionsLocked() {
        return this.mVersionsLocked;
    }

    public String[] getPromptMessages() {
        return this.mPromptMessages;
    }

    public String[] getPromptValues() {
        return this.mPromptValues;
    }

    public String[] getPromptModes() {
        return this.mPromptModes;
    }

    public boolean getPerformDetailedPreflight() {
        return this.mPerformDetailedPreflight;
    }

    public String getHostsRunningLimit() {
        return this.mHostsRunningLimit;
    }

    public String getOverallLimitUnits() {
        return this.mOverallLimitUnits;
    }

    public String getNativeLimitUnits() {
        return this.mNativeLimitUnits;
    }

    public String getOverallLimitValue() {
        return this.mOverallLimitValue;
    }

    public String getNativeLimitValue() {
        return this.mNativeLimitValue;
    }

    public String[] getTimeUnits() {
        return this.mTimeUnits;
    }

    public String[] getTimeLabels() {
        return this.mTimeLabels;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentVersion() {
        return this.mComponentVersion;
    }

    public String[] getAllHostSetNames() {
        return this.mAllHostSetNames;
    }

    public String[] getAllHostSetIDs() {
        return this.mAllHostSetIDs;
    }

    public HostID[] getHostIDObjectArray(int planNum) {
        return this.mFinalHostIDs[planNum];
    }

    public TaskID getTaskID() {
        return this.mTaskID;
    }

    public CategoryIDSet getCategoryIDSet() {
        return this.mCategoryIDSet;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getExecuteOnFolder() {
        return this.mExecuteOnFolder;
    }

    public boolean getWriteOnFolder() {
        return this.mWriteOnFolder;
    }

    public boolean getWriteOnAnyFolder() {
        return this.mWriteOnAnyFolder;
    }

    public PlanVersionHistoryBean getPlanVersionHistoryBean() {
        return this.mVersionBean;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setIsHidden(boolean val) {
        this.mIsHidden = val;
    }

    public void setWriteOnPlugin(boolean writeOnPlugin) {
        this.mWriteOnPlugin = writeOnPlugin;
    }

    public void setWriteOnFolder(boolean writeOnFolder) {
        this.mWriteOnFolder = writeOnFolder;
    }

    public void setDefinition(String definition) {
        this.mDefinition = definition;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setIsMajorVersion(boolean imv) {
        this.mIsMajorVersion = imv;
    }

    public void setIsHidingPrevious(boolean ihp) {
        this.mIsHidingPrevious = ihp;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setPreparePopupNeeded(boolean inValue) {
        this.mPreparePopupNeeded = inValue;
    }

    public void setUsingSameTargets(boolean inValue) {
        this.mUsingSameTargets = inValue;
    }

    public void setPlanNames(String[] inValue) {
        this.mPlanNames = inValue;
    }

    public void setHostSetIDs(String[] inValue) {
        this.mHostSetIDs = inValue;
    }

    public void setHostChecked(String[] inValue) {
        this.mHostChecked = inValue;
    }

    public void setHostSetChecked(String[] inValue) {
        this.mHostSetChecked = inValue;
    }

    public void setHostNames(String[] inValue) {
        this.mHostNames = inValue;
    }

    public void setInstallPaths(String[] inValue) {
        this.mInstallPaths = inValue;
    }

    public void setTargetsLocked(boolean inValue) {
        this.mTargetsLocked = inValue;
    }

    public void setVersionsLocked(boolean inValue) {
        this.mVersionsLocked = inValue;
    }

    public void setPromptValues(String[] inValue) {
        this.mPromptValues = inValue;
    }

    public void setPerformDetailedPreflight(boolean inValue) {
        this.mPerformDetailedPreflight = inValue;
    }

    public void setHostsRunningLimit(String inValue) {
        this.mHostsRunningLimit = inValue;
    }

    public void setOverallLimitUnits(String inValue) {
        this.mOverallLimitUnits = inValue;
    }

    public void setNativeLimitUnits(String inValue) {
        this.mNativeLimitUnits = inValue;
    }

    public void setOverallLimitValue(String inValue) {
        this.mOverallLimitValue = inValue;
    }

    public void setNativeLimitValue(String inValue) {
        this.mNativeLimitValue = inValue;
    }

    public void setComponentName(String inValue) {
        this.mComponentName = inValue;
    }

    public void setComponentVersion(String inValue) {
        this.mComponentVersion = inValue;
    }

    public void setFolderID(String folderID) throws RaplixException {
        this.mFolderID = folderID;
        this.mFolderPath = ChangePathBean.folderIDtoFilePath(this.mFolderID);
    }

    public String[] getComponentNames(int index) {
        String[] names = new String[this.mPrompts[index].getNumComponentSelectors()];
        for (int i = 0; i < this.mPrompts[index].getNumComponentSelectors(); ++i) {
            ComponentSelector compSelector = this.mPrompts[index].getComponentSelector(i);
            names[i] = compSelector.getComponentRef().getComponentFullName();
        }
        return names;
    }

    public boolean[] getDefaultIsLatest(int index) {
        boolean[] latest = new boolean[this.mPrompts[index].getNumComponentSelectors()];
        for (int i = 0; i < this.mPrompts[index].getNumComponentSelectors(); ++i) {
            ComponentSelector compSelector = this.mPrompts[index].getComponentSelector(i);
            latest[i] = compSelector.getIndexOfDefault() == compSelector.getIndexOfLatest();
        }
        return latest;
    }

    public String[] getSelectedComponentIDs(int index) {
        String[] selectedIDs = new String[this.mPrompts[index].getNumComponentSelectors()];
        for (int i = 0; i < this.mPrompts[index].getNumComponentSelectors(); ++i) {
            ComponentSelector compSelector = this.mPrompts[index].getComponentSelector(i);
            selectedIDs[i] = compSelector.getIndexOfCurrent() == -1 ? "" : compSelector.getAll()[compSelector.getIndexOfCurrent()].getComponent().getID().toString();
        }
        return selectedIDs;
    }

    public String[] getComponentLabels(int planIndex, int componentIndex) {
        ComponentSelector compSelector = this.mPrompts[planIndex].getComponentSelector(componentIndex);
        VariableSettingsSelector[] allChoices = compSelector.getAll();
        String[] labels = new String[allChoices.length];
        for (int i = 0; i < allChoices.length; ++i) {
            String label = allChoices[i].getComponent().getLabel();
            String buildNum = allChoices[i].getComponent().getVersionNumber().getAsString();
            labels[i] = buildNum + " (" + label + ")";
            if (i != compSelector.getIndexOfRecommended()) continue;
            int n = i;
            labels[n] = labels[n] + " &laquo;&raquo;";
        }
        if (allChoices.length == 0) {
            labels = new String[]{ApplicationResources.getMessage("error.plans.noComponent")};
        }
        return labels;
    }

    public String[] getSelectedComponentLabels(int index) {
        String[] selectedLabels = new String[this.mPrompts[index].getNumComponentSelectors()];
        for (int i = 0; i < this.mPrompts[index].getNumComponentSelectors(); ++i) {
            ComponentSelector compSelector = this.mPrompts[index].getComponentSelector(i);
            selectedLabels[i] = compSelector.getIndexOfCurrent() == -1 ? "" : compSelector.getAll()[compSelector.getIndexOfCurrent()].getComponent().getVersionNumber().getAsString();
        }
        return selectedLabels;
    }

    public String[] getComponentIDs(int planIndex, int componentIndex) {
        ComponentSelector compSelector = this.mPrompts[planIndex].getComponentSelector(componentIndex);
        VariableSettingsSelector[] allChoices = compSelector.getAll();
        String[] ids = new String[allChoices.length];
        for (int i = 0; i < allChoices.length; ++i) {
            ids[i] = allChoices[i].getComponent().getID().toString();
        }
        if (allChoices.length == 0) {
            ids = new String[]{""};
        }
        return ids;
    }

    public String[] getVarSettingLabels(int planIndex, int componentIndex, int buildIndex) {
        ComponentSelector compSelector = this.mPrompts[planIndex].getComponentSelector(componentIndex);
        if (compSelector.getAll().length == 0) {
            return new String[]{""};
        }
        VariableSettingsSelector settingSelector = compSelector.getAll()[buildIndex];
        ComponentVariableSettings[] allChoices = settingSelector.getAll();
        String[] labels = new String[allChoices.length + 1];
        labels[0] = "default";
        for (int i = 0; i < allChoices.length; ++i) {
            labels[i + 1] = allChoices[i].getName();
        }
        return labels;
    }

    public String[] getVarSettingIDs(int planIndex, int componentIndex, int buildIndex) {
        ComponentSelector compSelector = this.mPrompts[planIndex].getComponentSelector(componentIndex);
        if (compSelector.getAll().length == 0) {
            return new String[]{""};
        }
        VariableSettingsSelector settingSelector = compSelector.getAll()[buildIndex];
        ComponentVariableSettings[] allChoices = settingSelector.getAll();
        String[] ids = new String[allChoices.length + 1];
        ids[0] = "";
        for (int i = 0; i < allChoices.length; ++i) {
            ids[i + 1] = allChoices[i].getID().toString();
        }
        return ids;
    }

    public String[] getSelectedVarSettingIDs(int index) {
        String[] selectedIDs = new String[this.mPrompts[index].getNumComponentSelectors()];
        for (int i = 0; i < this.mPrompts[index].getNumComponentSelectors(); ++i) {
            VariableSettingsSelector varSelector;
            ComponentSelector compSelector = this.mPrompts[index].getComponentSelector(i);
            selectedIDs[i] = compSelector.getAll().length == 0 ? "" : ((varSelector = compSelector.getAll()[compSelector.getIndexOfCurrent()]).getCurrent() == null ? "" : varSelector.getCurrent().getID().toString());
        }
        return selectedIDs;
    }

    public void generateBlankDefinition() throws RaplixException {
        this.mExecutionPlan = new ExecutionPlan();
        this.mExecutionPlan.setName(this.mName);
        this.mExecutionPlan.setDescription(this.mDescription);
        this.mExecutionPlan.setPath(new FolderID(this.mFolderID));
        this.mDefinition = this.mExecutionPlan.writeToXML();
    }

    public void loadPlanDefinitionByID(String id) throws RaplixException {
        this.mExecutionPlan = new ExecutionPlanID(id).getByIDQuery().select();
        this.generatePlanDetailOutputs();
    }

    public void loadPlanVersionHistory() throws RaplixException {
        this.loadPlanVersionHistory(null);
    }

    public void loadPlanVersionHistory(String sortName) throws RaplixException {
        this.mVersionBean = new PlanVersionHistoryBean(this.mUserDBInterface);
        this.mVersionBean.setSortName(sortName);
        this.mVersionBean.loadPlanVersionHistory(this.mExecutionPlan.getID());
    }

    private void generatePlanDetailOutputs() throws RaplixException {
        this.mPlanID = this.mExecutionPlan.getID().toString();
        this.mName = this.mExecutionPlan.getName();
        this.mFullName = this.mExecutionPlan.getFullName();
        this.mFolderID = this.mExecutionPlan.getPath().toString();
        this.mFolderPath = Util.fullNameToPath(this.mFullName);
        this.mDescription = this.mExecutionPlan.getDescription();
        this.mVersion = this.mExecutionPlan.getVersionNumber().getAsString();
        this.mIsSimplePlan = this.mExecutionPlan.isSimplePlan();
        this.mDefinition = this.mExecutionPlan.writeToXML();
        this.mCheckedInDate = Util.formatDate(this.mExecutionPlan.getTimeStamp());
        this.mCheckedInUserName = this.mUserDBInterface.getUser(this.mExecutionPlan.getUserID()).getUsername();
        this.mIsHidden = this.mExecutionPlan.getVisibility().equals(Visibility.HIDDEN);
        this.mCategoryIDSet = this.mExecutionPlan.getCategories();
        this.mCatNamesString = CategoriesBean.getCategoryNamesString(this.mCategoryIDSet);
        PluginID pluginID = this.mExecutionPlan.getPluginID();
        if (pluginID != null) {
            this.mPluginID = pluginID.toString();
            this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
        }
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(this.mExecutionPlan);
        this.mExecuteOnFolder = PermissionChecker.hasExecuteOnFolder(this.mExecutionPlan.getPath());
        FolderID targetFolder = this.mExecutionPlan.getPath();
        if (this.mExecutionPlan.isAutogenPlan()) {
            this.mWriteOnPlugin = true;
            this.mTaskDescriptor = this.mPlanInterface.generateTaskDescriptorForPlan(new ExecutionPlanID(this.mPlanID));
            SubplanPrompt[] prompts = this.mTaskDescriptor.getSubplanPrompts();
            if (prompts != null && prompts.length > 0 && prompts[0].getNumComponentSelectors() > 0) {
                ComponentSelector compSelector = prompts[0].getComponentSelector(0);
                ComponentRef compRef = compSelector.getComponentRef();
                targetFolder = compRef.getPath();
            }
        }
        this.mWriteOnFolder = PermissionChecker.hasWriteOnFolder(targetFolder);
        this.mWriteOnAnyFolder = PermissionChecker.hasWriteOnAnyFolder();
    }

    public void renamePlan(String newName) throws RaplixException {
        ExecutionPlanID planID = new ExecutionPlanID(this.mPlanID);
        planID.move(newName, null);
    }

    public void movePlan(String newPathID) throws RaplixException {
        ExecutionPlanID planID = new ExecutionPlanID(this.mPlanID);
        planID.move(null, new FolderID(newPathID));
    }

    public void updateVisibility(String id, boolean isHiddenVal) throws RaplixException {
        Visibility hidden = isHiddenVal ? Visibility.HIDDEN : Visibility.VISIBLE;
        new ExecutionPlanID(id).updateVisibility(hidden);
        if (this.mPlanID != null && this.mPlanID.equals(id)) {
            this.mIsHidden = isHiddenVal;
        }
    }

    public void updateCategories(String id, String[] catIDs, boolean replaceExisting, boolean allVersions) throws RaplixException {
        int numCatIDs = catIDs.length;
        CategoryID[] categoryIDs = new CategoryID[numCatIDs];
        for (int i = 0; i < numCatIDs; ++i) {
            categoryIDs[i] = new CategoryID(catIDs[i]);
        }
        CategoryIDSet catIDSet = new CategoryIDSet(Arrays.asList(categoryIDs));
        CategoryUpdateContext ctx = new CategoryUpdateContext(catIDSet);
        ctx.setReplaceExisting(replaceExisting);
        ctx.setAllVersions(allVersions);
        ExecutionPlanID planID = new ExecutionPlanID(id);
        planID.updateCategories(ctx);
        this.mCategoryIDSet = catIDSet;
    }

    public String verifyPlanDefinition() throws Exception {
        ExecutionPlan latestPlan;
        ExecutionPlan plan = new ExecutionPlan();
        plan.readFromXML(this.mDefinition);
        String name = plan.getName();
        this.mDescription = plan.getDescription();
        try {
            latestPlan = SingleExecutionPlanQuery.byName(new FolderID(this.mFolderID), this.mName, null).select();
            this.mLatestVersion = latestPlan.getVersionNumber().getAsString();
        }
        catch (NoResultsFoundException nsoEx) {
            latestPlan = this.mExecutionPlan;
            this.mLatestVersion = null;
        }
        this.mNextMinorVersion = latestPlan.getVersionNumber().nextMinorVersionNumber().getAsString();
        this.mNextMajorVersion = latestPlan.getVersionNumber().nextMajorVersionNumber().getAsString();
        this.mIsMajorVersion = false;
        this.mIsHidingPrevious = true;
        if (this.mIsNew) {
            this.mPreviousName = "";
            this.mPreviousVersion = "";
            this.mPreviousID = null;
        } else {
            this.mPreviousName = this.mExecutionPlan.getFullName();
            this.mPreviousVersion = this.mExecutionPlan.getVersionNumber().getAsString();
            this.mPreviousID = this.mExecutionPlan.getID();
        }
        return name;
    }

    public void checkinPlan() throws RaplixException {
        if (this.mMode.equals("checkinas")) {
            this.mExecutionPlan = new ExecutionPlan();
            this.mLatestVersion = null;
        }
        if (this.mIsNew) {
            this.mLatestVersion = null;
        }
        this.mExecutionPlan.readFromXML(this.mDefinition);
        this.mExecutionPlan.setName(this.mName);
        this.mExecutionPlan.setPath(new FolderID(this.mFolderID));
        this.mExecutionPlan.setVisibility(this.mIsHidden ? Visibility.HIDDEN : Visibility.VISIBLE);
        VersionNumber version = null;
        if (this.mLatestVersion != null) {
            version = new VersionNumber(this.mLatestVersion);
        }
        VersionedSaveContext ctx = new VersionedSaveContext();
        ctx.setLatestVersion(version);
        ctx.setSaveAsNewMajor(this.mIsMajorVersion);
        if (this.mIsHidingPrevious) {
            ctx.setHideObjectID(this.mPreviousID);
        }
        this.mExecutionPlan.save(ctx);
        this.mPlanID = this.mExecutionPlan.getID().toString();
    }

    public void recyclePlanObject() {
        ExecutionPlan newone;
        this.mExecutionPlan = newone = this.mExecutionPlan.getDataClone();
    }

    public void checkpointState() {
        this.mOldExecutionPlan = this.mExecutionPlan;
    }

    public void rollbackState() throws RaplixException {
        this.mExecutionPlan = this.mOldExecutionPlan;
        this.generatePlanDetailOutputs();
        this.mOldExecutionPlan = null;
    }

    public void loadPlanDefaults() {
        try {
            this.mPerformDetailedPreflight = this.mPlanInterface.getDefaultDetailedPreflight();
        }
        catch (RPCException e) {
            this.mPerformDetailedPreflight = false;
        }
        try {
            this.mHostsRunningLimit = Integer.toString(this.mPlanInterface.getConfigDefaultPlanThrottle());
        }
        catch (RaplixException e) {
            this.mHostsRunningLimit = "10";
        }
    }

    public void loadHostInformation() throws RaplixException {
        HostSetsListBean hslb = new HostSetsListBean();
        hslb.loadAllSupportedHostSets();
        this.mAllHostSetIDs = hslb.getIDs();
        this.mAllHostSetNames = hslb.getNames();
    }

    public void loadSingleHostSelectorPlan() throws RaplixException {
        this.mTaskDescriptor = this.mPlanInterface.generateTaskDescriptorForPlan(new ExecutionPlanID(this.mPlanID));
        this.mPrompts = this.mTaskDescriptor.getSubplanPrompts();
        int numPlans = this.mPrompts.length;
        this.mPlanNames = new String[numPlans];
        this.mHostChecked = new String[numPlans];
        this.mHostSetChecked = new String[numPlans];
        this.mHostNames = new String[numPlans];
        this.mHostSetIDs = new String[numPlans];
        this.mLimitHostSetIDs = new String[numPlans];
        this.mUsingSameTargets = true;
        this.mOverallLimitValue = new Integer(this.mTaskDescriptor.getPlanTimeoutSecs() / 60).toString();
        this.mNativeLimitValue = new Integer(this.mTaskDescriptor.getNativeCallTimeoutSecs() / 60).toString();
        this.mFinalHostIDs = new HostID[numPlans][];
        for (int p = 0; p < numPlans; ++p) {
            SubplanPrompt spp = this.mPrompts[p];
            this.mPlanNames[p] = spp.getSubplanName();
            this.mHostChecked[p] = "false";
            this.mHostNames[p] = "";
            this.mHostSetChecked[p] = "false";
            this.mHostSetIDs[p] = "";
            this.mLimitHostSetIDs[p] = "";
            if (spp.getLimitToHostSet() == null) continue;
            try {
                this.mLimitHostSetIDs[p] = HostSetsBean.getSummaryHostSetByName(spp.getLimitToHostSet()).getID().toString();
                this.mHostSetIDs[p] = this.mLimitHostSetIDs[p];
                continue;
            }
            catch (RaplixException e) {
                this.mLimitHostSetIDs[p] = "";
            }
        }
    }

    public void loadPlanPromptInfo() throws RaplixException {
        int numPrompts = this.mTaskDescriptor.getPlanParameters().getVarNames().length;
        this.mPromptMessages = new String[numPrompts];
        this.mPromptValues = new String[numPrompts];
        this.mPromptModes = new String[numPrompts];
        for (int i = 0; i < numPrompts; ++i) {
            String varName = this.mTaskDescriptor.getPlanParameters().getVarNames()[i];
            PromptParam prompt = this.mTaskDescriptor.getPlanParameters().getParam(varName);
            this.mPromptMessages[i] = prompt.getResolvedPrompt();
            this.mPromptValues[i] = prompt.getDefaultValue() == null ? "" : prompt.getDefaultValue();
            DisplayMode dm = prompt.getDisplayMode();
            if (dm.equals(DisplayMode.PASSWORD)) {
                this.mPromptModes[i] = "password";
                continue;
            }
            if (dm.equals(DisplayMode.CLEAR)) {
                this.mPromptModes[i] = "cleartext";
                continue;
            }
            this.mPromptModes[i] = "checkbox";
            this.mPromptValues[i] = this.mPromptValues[i].equalsIgnoreCase("true") ? "true" : "false";
        }
    }

    public void loadFinalHostIDs() throws RaplixException {
        int numPlans = this.mFinalHostIDs.length;
        if (this.mUsingSameTargets) {
            HostID[] sameTargets = this.loadFinalHostIDsForSubplan(numPlans - 1);
            for (int p = 0; p < numPlans; ++p) {
                this.mFinalHostIDs[p] = sameTargets;
            }
        } else {
            for (int p = 0; p < numPlans; ++p) {
                this.mFinalHostIDs[p] = this.loadFinalHostIDsForSubplan(p);
            }
        }
    }

    private HostID[] loadFinalHostIDsForSubplan(int p) throws RaplixException {
        Vector hostIDs = new Vector();
        String[] hostChecked = this.getHostChecked();
        String[] hostSetChecked = this.getHostSetChecked();
        String[] hostNames = this.getHostNames();
        String[] hostSetIDs = this.getHostSetIDs();
        this.addHostsToList(hostChecked[p], hostNames[p], hostIDs);
        this.addHostSetToList(hostSetChecked[p], hostSetIDs[p], hostIDs);
        if (hostIDs.size() == 0) {
            throw new UIActionException("error.plans.missinghosts");
        }
        return hostIDs.toArray(new HostID[0]);
    }

    public void addHostsToList(String hostChecked, String hostNames, Vector hostIDs) throws RaplixException {
        if (hostNames == null || hostChecked == null || !hostChecked.equals("true")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(hostNames, ", ");
        while (st.hasMoreTokens()) {
            String singleHostName = st.nextToken();
            SummaryHost singleHostObj = HostsBean.getSummaryHostByName(singleHostName);
            if (singleHostObj == null || hostIDs.contains(singleHostObj.getID())) continue;
            hostIDs.add(singleHostObj.getID());
        }
    }

    public void addHostSetToList(String hostSetChecked, String hostSetID, Vector hostIDs) throws RaplixException {
        try {
            this.addHostSetsToList(hostSetChecked, hostSetID, hostIDs);
        }
        catch (RaplixException ex) {
            throw new RaplixException("error.plans.invalidHostSet", (Throwable)ex);
        }
    }

    public void addHostSearchToList(String hostSetChecked, String hostSetID, Vector hostIDs) throws RaplixException {
        try {
            this.addHostSetsToList(hostSetChecked, hostSetID, hostIDs);
        }
        catch (RaplixException ex) {
            throw new RaplixException("error.plans.invalidHostSearch", (Throwable)ex);
        }
    }

    public void addHostSetsToList(String hostSetChecked, String hostSetID, Vector hostIDs) throws RaplixException {
        if (hostSetChecked == null || !hostSetChecked.equals("true") || hostSetID == null) {
            return;
        }
        HostSetID hsID = new HostSetID(hostSetID);
        HostSet hostSet = hsID.getByIDQuery().select();
        SummaryHost[] hosts = hostSet.getAllHostsQuery().selectSummaryView();
        for (int i = 0; i < hosts.length; ++i) {
            if (hostIDs.contains(hosts[i].getID())) continue;
            hostIDs.add(hosts[i].getID());
        }
    }

    public void executePlan(boolean isPreflightOnly) throws RaplixException {
        RunLevel runLevel = RunLevel.PREFLIGHT;
        int hostsRunningLimit = this.mPlanInterface.getConfigDefaultPlanThrottle();
        int nativeTimeout = 0;
        int overallTimeout = 0;
        if (!isPreflightOnly) {
            runLevel = RunLevel.ACTUAL;
        }
        boolean detailedPreflight = this.getPerformDetailedPreflight();
        try {
            hostsRunningLimit = Integer.parseInt(this.getHostsRunningLimit());
            String nativeLimits = this.getNativeLimitValue();
            String nativeUnits = this.getNativeLimitUnits();
            nativeTimeout = nativeUnits != null && nativeUnits.equals("hours") ? Integer.parseInt(nativeLimits) * 60 * 60 : Integer.parseInt(nativeLimits) * 60;
            String overallLimits = this.getOverallLimitValue();
            String overallUnits = this.getOverallLimitUnits();
            overallTimeout = overallUnits != null && overallUnits.equals("hours") ? Integer.parseInt(overallLimits) * 60 * 60 : Integer.parseInt(overallLimits) * 60;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Successfully parsed limits.  They are: " + hostsRunningLimit + "/" + nativeTimeout + "/" + overallTimeout, this);
            }
        }
        catch (NumberFormatException nfe) {
            throw new UIActionException("error.plans.parselimits", new Object[]{nfe.getMessage()});
        }
        VariableSettingsHolder holder = new VariableSettingsHolder();
        int numPrompts = this.mTaskDescriptor.getPlanParameters().getVarNames().length;
        for (int i = 0; i < numPrompts; ++i) {
            String varName = this.mTaskDescriptor.getPlanParameters().getVarNames()[i];
            holder.setVarValue(varName, this.mPromptValues[i]);
        }
        UserID me = this.mSessionManager.getCurrentUserID();
        ExecutionPlanID planID = new ExecutionPlanID(this.getPlanID());
        int numPlans = this.mPrompts.length;
        for (int p = 0; p < numPlans; ++p) {
            this.mPrompts[p].setInitialTargets(this.getHostIDObjectArray(p));
        }
        this.mTaskDescriptor.setRunLevel(runLevel);
        this.mTaskDescriptor.setRoxUser(me);
        this.mTaskDescriptor.setDetailedPreflight(detailedPreflight);
        this.mTaskDescriptor.setPlanThrottle(hostsRunningLimit);
        this.mTaskDescriptor.setPlanTimeoutSecs(overallTimeout);
        this.mTaskDescriptor.setNativeCallTimeoutSecs(nativeTimeout);
        this.mTaskDescriptor.setPlanParameterValues(holder);
        this.mTaskID = this.mPlanInterface.runPlan(this.mTaskDescriptor);
        this.mPromptValues = new String[0];
    }

    public void setComponentChoices(String[][] choices) {
        int numPlans = this.mPrompts.length;
        for (int i = 0; i < numPlans; ++i) {
            int numComponents = this.mPrompts[i].getNumComponentSelectors();
            for (int j = 0; j < numComponents; ++j) {
                int newIndex = this.getIndexFromComponentID(choices[i][j], this.mPrompts[i].getComponentSelector(j));
                if (newIndex == -1) {
                    newIndex = this.mPrompts[i].getComponentSelector(j).getIndexOfDefault();
                }
                if (newIndex == -1) continue;
                this.mPrompts[i].getComponentSelector(j).setIndexOfCurrent(newIndex);
            }
        }
    }

    public void setVarSettingChoices(String[][] choices) {
        int numPlans = this.mPrompts.length;
        for (int i = 0; i < numPlans; ++i) {
            int numComponents = this.mPrompts[i].getNumComponentSelectors();
            for (int j = 0; j < numComponents; ++j) {
                VariableSettingsSelector varSelector = this.mPrompts[i].getComponentSelector(j).getCurrent();
                if (varSelector == null) continue;
                int newIndex = this.getIndexFromVarSettingID(choices[i][j], varSelector);
                if (newIndex == -1) {
                    newIndex = -1;
                }
                varSelector.setIndexOfCurrent(newIndex);
            }
        }
    }

    public void refreshVarSettingChoices() throws RaplixException {
        this.mPlanInterface.refreshTaskDescriptor(this.mTaskDescriptor);
        this.mPrompts = this.mTaskDescriptor.getSubplanPrompts();
    }

    private int getIndexFromComponentID(String id, ComponentSelector compSelector) {
        VariableSettingsSelector[] allChoices = compSelector.getAll();
        for (int i = 0; i < allChoices.length; ++i) {
            if (!allChoices[i].getComponent().getID().toString().equals(id)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexFromVarSettingID(String id, VariableSettingsSelector varSelector) {
        ComponentVariableSettings[] allChoices = varSelector.getAll();
        for (int i = 0; i < allChoices.length; ++i) {
            if (!allChoices[i].getID().toString().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public void directAction(String inComponentID, String procedureType, String procedureName, String paths) throws RaplixException {
        ComponentID componentID = new ComponentID(inComponentID);
        ExecutionPlanID planID = null;
        if (procedureType.equals(NamedBlockType.INSTALL.toString())) {
            planID = this.mPlanInterface.installComponent(componentID, procedureName);
        } else if (procedureType.equals(NamedBlockType.UNINSTALL.toString())) {
            String[] targets = StringUtil.split(paths, ",", "");
            planID = this.mPlanInterface.uninstallComponent(componentID, procedureName, targets);
        } else if (procedureType.equals(NamedBlockType.CONTROL.toString())) {
            String[] targets = StringUtil.split(paths, ",", "");
            planID = this.mPlanInterface.callComponent(componentID, procedureName, targets);
        } else {
            throw new IllegalArgumentException("Unknown procedure type (" + procedureType + ")");
        }
        this.mPlanID = planID.toString();
    }

    public void generatePlan(String inComponentID, String[] procedureTypes, String[] procedureNames) throws RaplixException {
        this.mExecutionPlan = new ExecutionPlan();
        this.mExecutionPlan.setName(this.mName);
        this.mExecutionPlan.setPath(new FolderID(this.mFolderID));
        NamedBlockType[] typesArray = new NamedBlockType[procedureTypes.length];
        for (int i = 0; i < procedureTypes.length; ++i) {
            typesArray[i] = procedureTypes[i].equals(NamedBlockType.INSTALL.toString()) ? NamedBlockType.INSTALL : (procedureTypes[i].equals(NamedBlockType.UNINSTALL.toString()) ? NamedBlockType.UNINSTALL : NamedBlockType.CONTROL);
        }
        this.mDefinition = this.mPlanInterface.generatePlanText(new ComponentID(inComponentID), procedureNames, typesArray);
    }
}

