/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PlansErrorConstants;
import com.raplix.rolloutexpress.ui.web.PlansListBean;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class PlansAction
extends UIActionListServlet
implements PlansErrorConstants,
ActionModeConstants {
    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through PlansAction: " + mode, this);
        }
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        if (mode.equals("list")) {
            this.handleList(request, servletInfo);
        } else if (mode.equals("applycategories")) {
            this.handleApplyCategories(request, servletInfo);
        } else if (mode.equals("updatecategories")) {
            this.handleUpdateCategories(request, servletInfo);
        } else if (mode.equals("errors")) {
            this.handleCategoriesErrors(request, servletInfo);
        } else if (mode.equals("deleteerrors")) {
            this.handleDeleteErrors(request, servletInfo);
        } else if (mode.equals("moveErrors")) {
            this.handleMoveErrors(request, servletInfo);
        } else if (mode.equals("move")) {
            this.handleMove(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Invalid Mode: " + mode);
        }
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String minorErrorKey;
        PlansListBean plb = (PlansListBean)servletInfo.getBean();
        String majorErrorKey = request.getParameter("majorErrorKey");
        if (majorErrorKey != null) {
            servletInfo.getErrors().setMajorErrorKey(majorErrorKey);
        }
        if ((minorErrorKey = request.getParameter("minorErrorKey")) != null) {
            servletInfo.getErrors().addMinorErrorKey(minorErrorKey);
        }
        plb.loadCategoryFilters();
        this.loadListParameters(request, plb);
        plb.generateList();
        MultiCheckbox mc = plb.getMultiCheckbox();
        if (mc != null) {
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(mc.getID(), mc);
        }
        servletInfo.setDestPage("/plans.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public void handleApplyCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String planMCID = PlansAction.assertGetParam(request, "multiLocation");
        String selected = PlansAction.assertGetParam(request, "selected");
        String redirectURI = PlansAction.assertGetParam(request, "redirecturi");
        MultiCheckbox planMC = (MultiCheckbox)request.getSession().getAttribute(planMCID);
        planMC.setSelected(selected);
        String[] planIDs = planMC.getSelected();
        Vector<ExecutionPlanID> planList = new Vector<ExecutionPlanID>();
        for (int i = 0; i < planIDs.length; ++i) {
            planList.addElement(new ExecutionPlanID(planIDs[i]));
        }
        ExecutionPlanIDSet idSet = new ExecutionPlanIDSet(planList);
        CategoryID[] catIDs = idSet.getByIDsQuery().selectSharedCategories().toIDArray();
        int numCatIDs = catIDs.length;
        String[] categoryIDs = new String[numCatIDs];
        for (int i = 0; i < numCatIDs; ++i) {
            categoryIDs[i] = catIDs[i].toString();
        }
        MultiCheckbox sharedCategoryMC = new MultiCheckbox("", categoryIDs);
        sharedCategoryMC.setSelectedAll();
        String sharedCategoryMCID = sharedCategoryMC.getID();
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(sharedCategoryMCID, sharedCategoryMC);
        String destPage = "/CategoriesPicker?mode=list&redirecturi=" + Util.encodeURL(redirectURI) + "&" + "categoryItemID" + "=" + planMCID + "&" + "categoryID" + "=" + sharedCategoryMCID;
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(false);
    }

    public void handleUpdateCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlansListBean plb = (PlansListBean)servletInfo.getBean();
        String planMCID = PlansAction.assertGetParam(request, "categoryItemID");
        String categoryMCID = PlansAction.assertGetParam(request, "categoryID");
        String selected = PlansAction.assertGetParam(request, "selected");
        boolean replaceExisting = "true".equals(PlansAction.assertGetParam(request, "replaceExisting"));
        boolean allVersions = request.getParameter("allVersions") != null;
        MultiCheckbox planMC = (MultiCheckbox)request.getSession().getAttribute(planMCID);
        String[] planIDs = planMC.getSelected();
        MultiCheckbox categoryMC = (MultiCheckbox)request.getSession().getAttribute(categoryMCID);
        categoryMC.setSelected(selected);
        String[] categoryIDs = categoryMC.getSelected();
        try {
            plb.updateCategories(planIDs, categoryIDs, replaceExisting, allVersions);
        }
        catch (PersistenceManagerException pme) {
            servletInfo.getErrors().setMajorErrorKey("error.plans.categories");
            servletInfo.getErrors().addMinorError(pme.getMessage());
        }
        this.handleList(request, servletInfo);
    }

    public void handleCategoriesErrors(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey("error.plans.categories");
        servletInfo.getErrors().addMinorErrorKey("error.plans.noselection");
        this.handleList(request, servletInfo);
    }

    private void handleDeleteErrors(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey("error.plans.delete.major");
        servletInfo.getErrors().addMinorErrorKey("error.plans.noselection");
        this.handleList(request, servletInfo);
    }

    private void handleMoveErrors(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey("error.plans.move.major");
        servletInfo.getErrors().addMinorErrorKey("error.plans.noselection");
        this.handleList(request, servletInfo);
    }

    private void handleMove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlansListBean bean = (PlansListBean)servletInfo.getBean();
        String movePath = PlansAction.assertGetParam(request, "movePath");
        MultiCheckbox in = new MultiCheckbox("bulk", request);
        String[] ids = in.getSelected();
        if (ids.length == 0) {
            this.handleMoveErrors(request, servletInfo);
            return;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Calling move on " + Util.commaSeparated(ids) + " to " + movePath, this);
        }
        try {
            bean.move(ids, movePath);
        }
        catch (PersistenceManagerException pme) {
            servletInfo.getErrors().setMajorErrorKey("error.plans.move.major");
            servletInfo.getErrors().addMinorError(pme.getMessage());
        }
        this.handleList(request, servletInfo);
    }

    public ServletBean createBean(HttpServletRequest request) {
        NotificationRPCInterface notificationMgr = PlansAction.getApplication().getNotificationInterface();
        return new PlansListBean(notificationMgr);
    }

    public String getDefaultPage() {
        return "/plans.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = PlansAction.assertGetParam(inRequest, "mode");
        if (mode.equals("list")) {
            return "error.plans.loading";
        }
        if (mode.equals("applycategories")) {
            return "error.plans.categories";
        }
        if (mode.equals("updatecategories")) {
            return "error.plans.categories";
        }
        if (mode.equals("errors")) {
            return "error.plans.categories";
        }
        if (mode.equals("deleteerrors")) {
            return "error.plans.delete.major";
        }
        if (mode.equals("moveErrors")) {
            return "error.plans.move.major";
        }
        if (mode.equals("move")) {
            return "error.plans.move.major";
        }
        throw new IllegalArgumentException("Invalid Mode: " + mode);
    }

    protected void setAdditionalFindFilters(HttpServletRequest request, ServletListBean bean) {
        String findParentName = request.getParameter("parentName");
        String findVersion = request.getParameter("versionNumber");
        PlansListBean pb = (PlansListBean)bean;
        if (findParentName != null) {
            pb.setFindParentName(findParentName);
        }
        if (findVersion != null) {
            pb.setFindVersionNumber(findVersion);
        }
    }

    protected void setAdditionalFilters(HttpServletRequest request, ServletListBean bean) {
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        boolean flatView = spb.trackBoolean(Preference.FLAT_VIEW, request);
        String filePathFilter = spb.trackString(Preference.FILE_PATH, request);
        filePathFilter = ChangePathBean.verifyFolderID(filePathFilter);
        spb.setString(Preference.FILE_PATH, filePathFilter);
        bean.setFilePathFilter(filePathFilter);
        bean.setFlatView(flatView);
    }
}

