/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.NoSuchOrderException;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanOrder;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.Util;

public class PlanVersionHistoryBean {
    private String[] mPlanIDs = new String[0];
    private String[] mCheckInTimes = new String[0];
    private String[] mCheckInUsers = new String[0];
    private String[] mVersions = new String[0];
    private boolean[] mIsHidden = new boolean[0];
    private String mSortName = "";
    private UserManager mUserDB;
    private static ExecutionPlanOrder DEFAULT_SORT_ORDER = ExecutionPlanOrder.BY_VERSION_DESC;

    public PlanVersionHistoryBean(UserManager userDBInterface) {
        this.mUserDB = userDBInterface;
    }

    public String[] getPlanIDs() {
        return this.mPlanIDs;
    }

    public String[] getCheckInTimes() {
        return this.mCheckInTimes;
    }

    public String[] getCheckInUsers() {
        return this.mCheckInUsers;
    }

    public String[] getVersions() {
        return this.mVersions;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public String getSortName() {
        return this.mSortName;
    }

    public void setSortName(String sortName) {
        this.mSortName = sortName;
    }

    public void loadPlanVersionHistory(ExecutionPlanID planID) throws RaplixException {
        ObjectOrder order;
        try {
            order = ExecutionPlanOrder.FACTORY.getObjectOrder(this.mSortName);
        }
        catch (NoSuchOrderException nsoe) {
            order = DEFAULT_SORT_ORDER;
            this.mSortName = DEFAULT_SORT_ORDER.getName();
        }
        catch (NullPointerException e) {
            order = DEFAULT_SORT_ORDER;
            this.mSortName = DEFAULT_SORT_ORDER.getName();
        }
        MultiExecutionPlanQuery query = planID.getAllVersionsQuery();
        query.setObjectOrder(order);
        SummaryExecutionPlan[] plans = query.selectSummaryView();
        int len = plans.length;
        this.mPlanIDs = new String[len];
        this.mCheckInTimes = new String[len];
        this.mCheckInUsers = new String[len];
        this.mVersions = new String[len];
        this.mIsHidden = new boolean[len];
        for (int i = 0; i < len; ++i) {
            this.mPlanIDs[i] = plans[i].getID().toString();
            this.mCheckInTimes[i] = Util.formatDate(plans[i].getTimeStamp());
            this.mCheckInUsers[i] = this.mUserDB.getUser(plans[i].getUserID()).getUsername();
            this.mVersions[i] = plans[i].getVersionNumber().getAsString();
            this.mIsHidden[i] = plans[i].getVisibility().equals(Visibility.HIDDEN);
        }
    }

    public void updateVisibilityAll(String id, boolean isHiddenVal) throws RaplixException {
        Visibility hidden = isHiddenVal ? Visibility.HIDDEN : Visibility.VISIBLE;
        ExecutionPlanID planID = new ExecutionPlanID(id);
        planID.getAllVersionsQuery().updateVisibility(hidden);
        this.loadPlanVersionHistory(planID);
    }
}

