/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.MultiStepStatusQuery;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.TaskInfoBean;
import com.raplix.rolloutexpress.ui.web.UIActionException;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.logger.Logger;

public class PlanRunResultsBean
extends TaskInfoBean {
    private String mMessage = "";
    private String mPercentageComplete = "0";
    private String mFilterHostName = "";
    private String mIsFiltered = "false";
    private String mPhase = "";
    private String[] mStepTypes = new String[0];
    private String[] mStepDescriptions = new String[0];
    private String[] mStepHosts = new String[0];
    private String[] mStepStarts = new String[0];
    private String[] mStepCompletes = new String[0];
    private String[] mStepFails = new String[0];
    private String[] mStepStatuses = new String[0];
    private int[] mStepIndents = new int[0];
    private String[] mStepIDs = new String[0];
    private int mDoneStepHosts = 0;
    private int mTotalStepHosts = 0;

    public PlanRunResultsBean(PlanInterface planInterface, UserManager userMgr) {
        super(planInterface, userMgr);
    }

    public String getMessage() {
        return this.mMessage;
    }

    public String getPercentageComplete() {
        return this.mPercentageComplete;
    }

    public String getFilterHostName() {
        return this.mFilterHostName;
    }

    public String getIsFiltered() {
        return this.mIsFiltered;
    }

    public String getPhase() {
        return this.mPhase;
    }

    public String[] getStepTypes() {
        return this.mStepTypes;
    }

    public String[] getStepDescriptions() {
        return this.mStepDescriptions;
    }

    public String[] getStepHosts() {
        return this.mStepHosts;
    }

    public String[] getStepStarts() {
        return this.mStepStarts;
    }

    public String[] getStepCompletes() {
        return this.mStepCompletes;
    }

    public String[] getStepFails() {
        return this.mStepFails;
    }

    public String[] getStepStatuses() {
        return this.mStepStatuses;
    }

    public int[] getStepIndents() {
        return this.mStepIndents;
    }

    public String[] getStepIDs() {
        return this.mStepIDs;
    }

    public void setIsFilteredAndFilterHostName(String filterHostName) {
        if (filterHostName != null) {
            this.mIsFiltered = "true";
            this.mFilterHostName = filterHostName;
        } else {
            this.mIsFiltered = "false";
            this.mFilterHostName = "";
        }
    }

    public void loadAllRunResults(String taskID, String phase, ServletErrors errors) throws RaplixException {
        RunLevel runLevel;
        this.loadTaskInfo(taskID, errors, phase);
        this.mPhase = phase;
        StepStatusBean[] theSteps = null;
        boolean isDeployment = this.mPhase.equals("runlive") || this.mPhase.equals("runresults");
        RunLevel runLevel2 = runLevel = isDeployment ? RunLevel.ACTUAL : RunLevel.PREFLIGHT;
        if (this.mIsFiltered.equals("true")) {
            try {
                HostID host = HostsBean.getSummaryHostByName(this.mFilterHostName).getID();
                theSteps = MultiStepStatusQuery.topLevelSteps(new TaskID(this.mTaskID), host, runLevel).select();
            }
            catch (UIActionException uiae) {
                errors.addMinorError(uiae.getMessage());
            }
        }
        if (theSteps == null) {
            theSteps = MultiStepStatusQuery.topLevelSteps(new TaskID(this.mTaskID), runLevel).select();
        }
        this.loadStepList(theSteps);
        this.mPercentageComplete = "0";
        if (this.mIsHistory) {
            this.mPercentageComplete = "100";
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("task is history, 100% complete", this);
            }
        } else if ((this.mPhase.equals("preflightlive") || this.mPhase.equals("preflightresults")) && this.mIsPreflightComplete) {
            this.mPercentageComplete = "100";
        } else if (isDeployment) {
            if (this.mTotalStepHosts < 1) {
                this.mTotalStepHosts = 1;
            }
            double pct = (double)this.mDoneStepHosts * 100.0 / (double)this.mTotalStepHosts;
            this.mPercentageComplete = "" + (int)pct / 5 * 5;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("computed progress: " + this.mPercentageComplete, this);
            }
        }
    }

    private void loadStepList(StepStatusBean[] theSteps) throws RaplixException {
        int totalSteps = theSteps.length;
        for (int i = 0; i < theSteps.length; ++i) {
            StepInfo stepInfo = theSteps[i].getStepInfo();
            if (stepInfo.getDescription() != null) continue;
            totalSteps = i;
            break;
        }
        this.mStepTypes = new String[totalSteps];
        this.mStepDescriptions = new String[totalSteps];
        this.mStepHosts = new String[totalSteps];
        this.mStepStarts = new String[totalSteps];
        this.mStepCompletes = new String[totalSteps];
        this.mStepFails = new String[totalSteps];
        this.mStepStatuses = new String[totalSteps];
        this.mStepIndents = new int[totalSteps];
        this.mStepIDs = new String[totalSteps];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < totalSteps; ++i) {
            StepInfo stepInfo = theSteps[i].getStepInfo();
            this.mStepHosts[i] = "" + stepInfo.getTargetCount();
            this.mStepTypes[i] = ExecStep.getStepTypeStringRepresentation(stepInfo.getStepType());
            this.mStepDescriptions[i] = stepInfo.getDescription();
            this.mStepIDs[i] = "" + stepInfo.getStepMap();
            this.mStepStarts[i] = this.emptyOrValue(stepInfo.getHostsStarted());
            this.mStepCompletes[i] = this.emptyOrValue(stepInfo.getHostsCompleted());
            this.mStepFails[i] = this.emptyOrValue(stepInfo.getHostsFailed());
            this.mStepStatuses[i] = Util.getLabelForStepStatus(stepInfo.getStepStatus());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug(stepInfo.getStepStatus().toString(), this);
            }
            this.mStepIndents[i] = stepInfo.getNestingLevel();
            this.mTotalStepHosts += stepInfo.getTargetCount();
            this.mDoneStepHosts += stepInfo.getHostsCompleted() + stepInfo.getHostsFailed();
        }
        int firstMessage = totalSteps - 10;
        if (firstMessage < 0) {
            firstMessage = 0;
        }
        for (int i = firstMessage; i < totalSteps; ++i) {
            if (this.mStepDescriptions[i] == null) continue;
            sb.append(Util.escapeJavascript(this.mStepDescriptions[i]) + "\\n");
        }
        this.mMessage = sb.toString();
    }

    private String emptyOrValue(int i) {
        if (i == 0) {
            return "";
        }
        return "" + i;
    }

    public void stopExecution(String taskID) throws RaplixException {
        this.mPlanInterface.requestHalt(new TaskID(taskID));
    }
}

