/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.PlanRunResultsBean;
import com.raplix.rolloutexpress.ui.web.PlansErrorConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionException;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class PlanRunResultsAction
extends UIActionServlet
implements ActionModeConstants,
PlansErrorConstants {
    private static final String PLANHISTORY_ERRORMSG_RESULTS = "error.planrunhistory.results";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "refresh";
        }
        Logger.debug("Coming through PlanRunResultsAction: " + mode, this);
        if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("render")) {
            this.handleRender(request, servletInfo);
        } else if (mode.equals("poll")) {
            this.handlePoll(request, servletInfo);
        } else if (mode.equals("stop")) {
            this.handleStop(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to PlanRunResultsAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        PlanInterface planInf = PlanRunResultsAction.getApplication().getPlanInterface();
        UserManager userMgr = PlanRunResultsAction.getApplication().getUserManager();
        return new PlanRunResultsBean(planInf, userMgr);
    }

    public String getDefaultPage() {
        return "/planRunHistoryResults.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = PlanRunResultsAction.assertGetParam(inRequest, "mode");
        if (mode.equals("render")) {
            return PLANHISTORY_ERRORMSG_RESULTS;
        }
        if (mode.equals("refresh")) {
            return PLANHISTORY_ERRORMSG_RESULTS;
        }
        if (mode.equals("poll")) {
            return PLANHISTORY_ERRORMSG_RESULTS;
        }
        if (mode.equals("stop")) {
            return "error.plans.abort";
        }
        throw new IllegalArgumentException("Unknown mode passed to PlanRunResultsAction.");
    }

    private void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) {
        PlanRunResultsBean bean = (PlanRunResultsBean)servletInfo.getBean();
        String taskID = PlanRunResultsAction.assertGetParam(request, "id");
        String phase = PlanRunResultsAction.assertGetParam(request, "phase");
        String isFiltered = request.getParameter("isFiltered");
        String filterHostName = isFiltered != null && isFiltered.equals("true") ? PlanRunResultsAction.assertGetParam(request, "filterHostName") : null;
        bean.setIsFilteredAndFilterHostName(filterHostName);
        bean.setTaskID(taskID);
        String cancelling = request.getParameter("cancelling");
        if (cancelling != null && cancelling.equals("true")) {
            bean.setCancelling(true);
        }
        if (phase.equals("preflightlive")) {
            servletInfo.setDestPage("/planPreflight.jsp");
        } else if (phase.equals("runlive")) {
            servletInfo.setDestPage("/planRun.jsp");
        } else {
            servletInfo.setDestPage("/planRunHistoryResults.jsp");
        }
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleRender(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.setSaveInSession(false);
        PlanRunResultsBean bean = (PlanRunResultsBean)servletInfo.getBean();
        String taskID = PlanRunResultsAction.assertGetParam(request, "id");
        String phase = PlanRunResultsAction.assertGetParam(request, "phase");
        String isFiltered = request.getParameter("isFiltered");
        String filterHostName = isFiltered != null && isFiltered.equals("true") ? PlanRunResultsAction.assertGetParam(request, "filterHostName") : null;
        bean.setIsFilteredAndFilterHostName(filterHostName);
        String cancelling = request.getParameter("cancelling");
        if (cancelling != null && cancelling.equals("true")) {
            bean.setCancelling(true);
        }
        bean.loadAllRunResults(taskID, phase, servletInfo.getErrors());
        if (phase.equals("preflightlive")) {
            servletInfo.setDestPage("/planPreflightTop.jsp");
        } else if (phase.equals("runlive")) {
            servletInfo.setDestPage("/planRunTop.jsp");
        } else {
            servletInfo.setDestPage("/planRunHistoryResults.jsp");
        }
        servletInfo.setShouldRedirect(false);
    }

    private void handlePoll(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.setSaveInSession(false);
        PlanRunResultsBean bean = (PlanRunResultsBean)servletInfo.getBean();
        String taskID = PlanRunResultsAction.assertGetParam(request, "id");
        String phase = PlanRunResultsAction.assertGetParam(request, "phase");
        String isFiltered = request.getParameter("isFiltered");
        String filterHostName = isFiltered != null && isFiltered.equals("true") ? PlanRunResultsAction.assertGetParam(request, "filterHostName") : null;
        bean.setIsFilteredAndFilterHostName(filterHostName);
        if (request.getParameter("firstTime") == null) {
            try {
                bean.loadAllRunResults(taskID, phase, servletInfo.getErrors());
            }
            catch (UIActionException uiae) {}
        } else {
            bean.setTaskID(taskID);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("First time is set, skipping processing", this);
            }
        }
        if (phase.equals("preflightlive")) {
            servletInfo.setDestPage("/planPreflightBottom.jsp");
        } else {
            servletInfo.setDestPage("/planRunBottom.jsp");
        }
        servletInfo.setShouldRedirect(false);
    }

    private void handleStop(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanRunResultsBean bean = (PlanRunResultsBean)servletInfo.getBean();
        String taskID = PlanRunResultsAction.assertGetParam(request, "id");
        bean.stopExecution(taskID);
        servletInfo.setDestPage("/PlanRunLink?mode=planprogressordetails&id=" + taskID + "&" + "cancelling" + "=" + "true");
        servletInfo.setShouldRedirect(true);
        servletInfo.setSaveInSession(false);
    }
}

