/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.MultiStepStatusQuery;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.TaskInfoBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.util.Vector;

public class PlanRunOneHostBean
extends TaskInfoBean {
    private static final String MSG_TASK_ERROR = "error.plans.errors_encountered";
    private String mTaskID = "";
    private String mStepID = "";
    private String mStepMapID = "";
    private String mStepType = "";
    private String mStepDescription = "";
    private String mLogicalHostName = "";
    private String mLogicalHostID = "";
    private String mPhysicalHostName = "";
    private String mPhase = "";
    private String[] mStepTypes = new String[0];
    private String[] mStepDescriptions = new String[0];
    private String[] mStepStartDates = new String[0];
    private String[] mStepCompleteDates = new String[0];
    private String[] mStepStatusMessages = new String[0];
    private String[] mStepStatuses = new String[0];
    private int[] mStepIndents = new int[0];
    private String[] mStepIDs = new String[0];
    private Vector mVStepTypes = null;
    private Vector mVStepDescriptions = null;
    private Vector mVStepStartDates = null;
    private Vector mVStepCompleteDates = null;
    private Vector mVStepStatusMessages = null;
    private Vector mVStepStatuses = null;
    private Vector mVStepIndents = null;
    private Vector mVStepIDs = null;
    private String mMode = "";
    private int mPercentageComplete = 0;

    public PlanRunOneHostBean(PlanInterface planInterface, UserManager userMgr) {
        super(planInterface, userMgr);
    }

    public String getID() {
        if (this.mTaskID.equals("")) {
            return super.getID();
        }
        return this.mTaskID;
    }

    public String getTaskID() {
        return this.mTaskID;
    }

    public String getStepID() {
        return this.mStepID;
    }

    public String getStepMapID() {
        return this.mStepMapID;
    }

    public String getStepType() {
        return this.mStepType;
    }

    public String getStepDescription() {
        return this.mStepDescription;
    }

    public String getLogicalHostName() {
        return this.mLogicalHostName;
    }

    public String getLogicalHostID() {
        return this.mLogicalHostID;
    }

    public String getPhysicalHostName() {
        return this.mPhysicalHostName;
    }

    public String getPhase() {
        return this.mPhase;
    }

    public String[] getStepTypes() {
        return this.mStepTypes;
    }

    public String[] getStepDescriptions() {
        return this.mStepDescriptions;
    }

    public String[] getStepStartDates() {
        return this.mStepStartDates;
    }

    public String[] getStepCompleteDates() {
        return this.mStepCompleteDates;
    }

    public String[] getStepStatusMessages() {
        return this.mStepStatusMessages;
    }

    public String[] getStepStatuses() {
        return this.mStepStatuses;
    }

    public int[] getStepIndents() {
        return this.mStepIndents;
    }

    public String[] getStepIDs() {
        return this.mStepIDs;
    }

    public String getMode() {
        return this.mMode;
    }

    public int getPercentageComplete() {
        return this.mPercentageComplete;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setStepID(String stepID) {
        this.mStepID = stepID;
    }

    public void setStepMapID(String stepMapID) {
        this.mStepMapID = stepMapID;
    }

    public void setPhase(String phase) {
        this.mPhase = phase;
    }

    public void fetchOutput(ServletInfo servletInfo) throws RaplixException {
        MultiStepStatusQuery mssq = MultiStepStatusQuery.allSteps(new StepID(this.mStepID));
        StepStatusBean[] ssb = mssq.select();
        StepInfo stepInfo = ssb[0].getStepInfo();
        this.mTaskID = stepInfo.getTaskID().toString();
        this.mStepType = ExecStep.getStepTypeStringRepresentation(stepInfo.getStepType());
        this.mStepDescription = stepInfo.getDescription();
        this.loadTaskInfo(this.mTaskID, servletInfo.getErrors(), this.mPhase);
        this.mPercentageComplete = this.mIsHistory ? 100 : 0;
        Target t = stepInfo.getTargetID().getByIDQuery().select();
        this.mLogicalHostName = t.getInitialHost().getName();
        this.mPhysicalHostName = t.getInitialHostID().equals(t.getPhysicalHostID()) ? "" : t.getPhysicalHost().getName();
        this.mVStepTypes = new Vector();
        this.mVStepDescriptions = new Vector();
        this.mVStepStartDates = new Vector();
        this.mVStepCompleteDates = new Vector();
        this.mVStepStatusMessages = new Vector();
        this.mVStepStatuses = new Vector();
        this.mVStepIndents = new Vector();
        this.mVStepIDs = new Vector();
        this.traverse(stepInfo.getChildSteps());
        this.mStepTypes = this.mVStepTypes.toArray(new String[0]);
        this.mStepDescriptions = this.mVStepDescriptions.toArray(new String[0]);
        this.mStepStartDates = this.mVStepStartDates.toArray(new String[0]);
        this.mStepCompleteDates = this.mVStepCompleteDates.toArray(new String[0]);
        this.mStepStatusMessages = this.mVStepStatusMessages.toArray(new String[0]);
        this.mStepStatuses = this.mVStepStatuses.toArray(new String[0]);
        Integer[] iArray = this.mVStepIndents.toArray(new Integer[0]);
        this.mStepIndents = new int[iArray.length];
        for (int i = 0; i < iArray.length; ++i) {
            this.mStepIndents[i] = iArray[i];
        }
        this.mStepIDs = this.mVStepIDs.toArray(new String[0]);
    }

    private void traverse(StepInfo[] stepInfos) throws RaplixException {
        for (int i = 0; i < stepInfos.length; ++i) {
            StepInfo stepInfo = stepInfos[i];
            if (stepInfo.getDescription() == null) continue;
            this.mVStepIDs.add(stepInfo.getStepID().toString());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("child " + i + " stepType = " + stepInfo.getStepType() + ", stepDescription = " + stepInfo.getDescription(), this);
            }
            this.mVStepTypes.add(ExecStep.getStepTypeStringRepresentation(stepInfo.getStepType()));
            this.mVStepDescriptions.add(stepInfo.getDescription());
            this.mVStepIndents.add(new Integer(stepInfo.getNestingLevel()));
            this.mVStepStartDates.add(Util.formatDate(stepInfo.getStartDate()));
            this.mVStepCompleteDates.add(Util.formatDate(stepInfo.getCompleteDate()));
            this.mVStepStatuses.add(Util.getLabelForStepStatus(stepInfo.getStepStatus()));
            this.mVStepStatusMessages.add(stepInfo.getExceptionDescription());
            if (stepInfo.getChildSteps() == null) continue;
            this.traverse(stepInfo.getChildSteps());
        }
    }
}

