/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.Util;

public class PlanRunNativeBean
extends ServletBean {
    private String mPlanName = "";
    private String mPlanVersion = "";
    private String mStepType = "";
    private String mStepDescription = "";
    private String mLogicalHostName = "";
    private String mPhysicalHostName = "";
    private String mStepStart = "";
    private String mStepComplete = "";
    private String mStepStatus = "";
    private String mMode = "";
    private String mTaskID = "";
    private String mStepID = "";
    private int mTruncation = 0;
    private String mOutput = "";
    private String mExitCode = "";
    private PlanInterface mPlanInterface = null;

    public PlanRunNativeBean(PlanInterface planInterface) {
        this.mPlanInterface = planInterface;
    }

    public String getID() {
        if (this.mStepID != null && !this.mStepID.equals("")) {
            return this.mStepID;
        }
        return super.getID();
    }

    public String getPlanName() {
        return this.mPlanName;
    }

    public String getPlanVersion() {
        return this.mPlanVersion;
    }

    public String getStepType() {
        return this.mStepType;
    }

    public String getStepDescription() {
        return this.mStepDescription;
    }

    public String getLogicalHostName() {
        return this.mLogicalHostName;
    }

    public String getPhysicalHostName() {
        return this.mPhysicalHostName;
    }

    public String getStepStart() {
        return this.mStepStart;
    }

    public String getStepComplete() {
        return this.mStepComplete;
    }

    public String getStepStatus() {
        return this.mStepStatus;
    }

    public String getMode() {
        return this.mMode;
    }

    public String getTaskID() {
        return this.mTaskID;
    }

    public String getStepID() {
        return this.mStepID;
    }

    public int getTruncation() {
        return this.mTruncation;
    }

    public String getOutput() {
        return this.mOutput;
    }

    public String getExitCode() {
        return this.mExitCode;
    }

    public PlanInterface getPlanInterface() {
        return this.mPlanInterface;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    void fetchOutput(String stepID) throws RaplixException {
        this.mStepID = stepID;
        StepStatusBean ssb = this.mPlanInterface.stepStatusQuery(new StepID(this.mStepID));
        StepInfo stepInfo = ssb.getStepInfo();
        this.mTaskID = stepInfo.getTaskID().toString();
        TaskInfo info = this.mPlanInterface.getTaskInfoForTaskID(new TaskID(this.mTaskID));
        ExecutionPlan plan = info.getCompiledPlan().getTopLevelPlan();
        this.mPlanName = plan.getFullName();
        this.mPlanVersion = plan.getVersionNumber().getAsString();
        this.mStepType = ExecStep.getStepTypeStringRepresentation(stepInfo.getStepType());
        this.mStepDescription = stepInfo.getDescription();
        this.mStepStart = Util.formatDate(stepInfo.getStartDate());
        this.mStepComplete = Util.formatDate(stepInfo.getCompleteDate());
        this.mStepStatus = Util.getLabelForStepStatus(stepInfo.getStepStatus());
        Target t = stepInfo.getTargetID().getByIDQuery().select();
        this.mLogicalHostName = t.getInitialHost().getName();
        this.mPhysicalHostName = t.getInitialHostID().equals(t.getPhysicalHostID()) ? "" : t.getPhysicalHost().getName();
        ExecNativeOutput eno = ssb.getExecNativeOutput();
        if (eno != null) {
            if (this.mMode.equals("stdout")) {
                this.mOutput = eno.getOutput();
                this.mTruncation = eno.getOutStartIdx() == 0L ? 0 : this.mOutput.length();
            } else {
                this.mOutput = eno.getError();
                this.mTruncation = eno.getErrorStartIdx() == 0L ? 0 : this.mOutput.length();
            }
            if (eno.getExitCode() != null) {
                this.mExitCode = eno.getExitCode();
            }
        } else {
            this.mOutput = stepInfo.getExceptionDescription() != null ? "No output: " + stepInfo.getExceptionDescription() : "No output.";
            this.mTruncation = 0;
            this.mExitCode = "";
        }
    }
}

