/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.MultiStepStatusQuery;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.TaskInfoBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;

public class PlanRunLogBean
extends TaskInfoBean {
    private String mMessage = "";
    private int mPercentageComplete = 0;
    private String mDisplayMode = "";
    private String[] mStepTypes = new String[0];
    private String[] mStepDescriptions = new String[0];
    private String[] mStepHostNames = new String[0];
    private String[] mStepHostIDs = new String[0];
    private String[] mStepStarts = new String[0];
    private String[] mStepCompletes = new String[0];
    private String[] mStepStatuses = new String[0];
    private String[] mStepStatusMessages = new String[0];
    private String[] mProcedureOutputs = new String[0];
    private boolean[] mStepHasDetails = new boolean[0];
    private String[] mStepIDs = new String[0];
    private boolean[] mStepIsPreflight = new boolean[0];
    private int mDoneStepHosts = 0;
    private int mTotalStepHosts = 0;
    private static final int TRUNCATION = 1000;

    public PlanRunLogBean(PlanInterface planInterface, UserManager userMgr) {
        super(planInterface, userMgr);
    }

    public String getMessage() {
        return this.mMessage;
    }

    public int getPercentageComplete() {
        return this.mPercentageComplete;
    }

    public String getDisplayMode() {
        return this.mDisplayMode;
    }

    public void setDisplayMode(String dmode) {
        this.mDisplayMode = dmode;
    }

    public String[] getStepTypes() {
        return this.mStepTypes;
    }

    public String[] getStepDescriptions() {
        return this.mStepDescriptions;
    }

    public String[] getStepLogicalHostsNamesString() {
        return this.mStepHostNames;
    }

    public String[] getStepLogicalHostIDs() {
        return this.mStepHostIDs;
    }

    public String[] getStepStarts() {
        return this.mStepStarts;
    }

    public String[] getStepCompletes() {
        return this.mStepCompletes;
    }

    public String[] getStepStatusMessageString() {
        return this.mStepStatusMessages;
    }

    public String[] getStepStatuses() {
        return this.mStepStatuses;
    }

    public String[] getProcedureOutputs() {
        return this.mProcedureOutputs;
    }

    public String[] getStepIDs() {
        return this.mStepIDs;
    }

    public boolean[] getStepIsPreflight() {
        return this.mStepIsPreflight;
    }

    public boolean[] getStepHasDetails() {
        return this.mStepHasDetails;
    }

    public void loadAllErrorLogs(String taskID, ServletErrors errors) throws RaplixException {
        this.loadTaskInfo(taskID, errors, "");
        errors = new ServletErrors();
        StepStatusBean[] theSteps = null;
        try {
            theSteps = MultiStepStatusQuery.failedStepsForTask(new TaskID(this.mTaskID)).select();
        }
        catch (Exception uiae) {
            errors.addMinorError(uiae.getMessage());
        }
        this.loadStepList(theSteps);
        this.mPercentageComplete = 0;
        if (this.mIsHistory) {
            this.mPercentageComplete = 100;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("task is history, 100% complete", this);
            }
        } else {
            if (this.mTotalStepHosts < 1) {
                this.mTotalStepHosts = 1;
            }
            double pct = (double)this.mDoneStepHosts * 100.0 / (double)this.mTotalStepHosts;
            this.mPercentageComplete = (int)pct / 5 * 5;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("computed progress: " + this.mPercentageComplete, this);
            }
        }
    }

    private void loadStepList(StepStatusBean[] theSteps) throws RaplixException {
        int totalSteps = theSteps.length;
        this.mStepTypes = new String[totalSteps];
        this.mStepDescriptions = new String[totalSteps];
        this.mStepHostNames = new String[totalSteps];
        this.mStepHostIDs = new String[totalSteps];
        this.mStepIDs = new String[totalSteps];
        this.mStepStarts = new String[totalSteps];
        this.mStepCompletes = new String[totalSteps];
        this.mStepStatusMessages = new String[totalSteps];
        this.mStepStatuses = new String[totalSteps];
        this.mStepHasDetails = new boolean[totalSteps];
        this.mStepIsPreflight = new boolean[totalSteps];
        this.mProcedureOutputs = new String[totalSteps];
        for (int i = 0; i < totalSteps; ++i) {
            StepInfo stepInfo = theSteps[i].getStepInfo();
            if (stepInfo == null) continue;
            this.mStepIDs[i] = stepInfo.getStepID().toString();
            this.mStepTypes[i] = ExecStep.getStepTypeStringRepresentation(stepInfo.getStepType());
            this.mStepDescriptions[i] = stepInfo.getDescription();
            this.mStepStatuses[i] = Util.getLabelForStepStatus(stepInfo.getStepStatus());
            this.mStepStatusMessages[i] = stepInfo.getExceptionDescription();
            Target t = stepInfo.getTargetID().getByIDQuery().select();
            this.mStepHostNames[i] = t.getInitialHostID().equals(t.getPhysicalHostID()) || stepInfo.getStepStatus().equals(StepStatus.PREFLIGHT_ERROR) || stepInfo.getStepStatus().equals(StepStatus.PRIOR_ERROR) ? t.getInitialHost().getName() : t.getInitialHost().getName() + "(" + t.getPhysicalHost().getName() + ")";
            this.mStepHostIDs[i] = t.getInitialHostID().toString();
            this.mStepTypes[i] = ExecStep.getStepTypeStringRepresentation(stepInfo.getStepType());
            this.mStepDescriptions[i] = stepInfo.getDescription();
            this.mStepStarts[i] = Util.formatDate(stepInfo.getStartDate());
            this.mStepCompletes[i] = Util.formatDate(stepInfo.getCompleteDate());
            this.mStepIsPreflight[i] = false;
            if (TaskExecutor.isPreflightRunLevel(stepInfo.getRunLevel())) {
                this.mStepIsPreflight[i] = true;
            }
            this.mStepHasDetails[i] = false;
            if ((this.mStepTypes[i].equals("execNative") || this.mStepTypes[i].equals("execJava")) && !this.mStepIsPreflight[i]) {
                this.mStepHasDetails[i] = true;
            }
            StepStatusBean ssb = this.mPlanInterface.stepStatusQuery(new StepID(this.mStepIDs[i]));
            ExecNativeOutput eno = ssb.getExecNativeOutput();
            String strOutput = null;
            if (eno != null) {
                strOutput = this.mDisplayMode.equals("stdout") ? eno.getOutput() : eno.getError();
                System.out.println(" stdout ++++ " + strOutput);
                if (strOutput == null) {
                    this.mProcedureOutputs[i] = "";
                    continue;
                }
                if (strOutput.length() < 1000) {
                    this.mProcedureOutputs[i] = strOutput;
                    continue;
                }
                this.mProcedureOutputs[i] = "... " + strOutput.substring(1000, strOutput.length());
                continue;
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("the exec Native output is null", this);
            }
            System.out.println("the exec Native output is null");
            this.mProcedureOutputs[i] = "";
        }
    }
}

