/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.PlanRunLogBean;
import com.raplix.rolloutexpress.ui.web.PlansErrorConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class PlanRunLogAction
extends UIActionServlet
implements ActionModeConstants,
PlansErrorConstants {
    private static final String PLANHISTORY_ERRORMSG_RESULTS = "error.planrunLog.results";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanRunLogBean prlb = (PlanRunLogBean)servletInfo.getBean();
        String displayMode = request.getParameter("displayMode");
        if (displayMode == null) {
            displayMode = "stderr";
        }
        prlb.setDisplayMode(displayMode);
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "refresh";
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through PlanRunLogAction: " + mode, this);
        }
        if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("render")) {
            this.handleRender(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to PlanRunLogAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        PlanInterface planInf = PlanRunLogAction.getApplication().getPlanInterface();
        UserManager userMgr = PlanRunLogAction.getApplication().getUserManager();
        return new PlanRunLogBean(planInf, userMgr);
    }

    public String getDefaultPage() {
        return "/planRunLog.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = PlanRunLogAction.assertGetParam(inRequest, "mode");
        if (mode.equals("render")) {
            return PLANHISTORY_ERRORMSG_RESULTS;
        }
        if (mode.equals("refresh")) {
            return PLANHISTORY_ERRORMSG_RESULTS;
        }
        throw new IllegalArgumentException("Unknown mode passed to PlanRunLogAction.");
    }

    private void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) {
        PlanRunLogBean bean = (PlanRunLogBean)servletInfo.getBean();
        String taskID = PlanRunLogAction.assertGetParam(request, "id");
        bean.setTaskID(taskID);
        String cancelling = request.getParameter("cancelling");
        if (cancelling != null && cancelling.equals("true")) {
            bean.setCancelling(true);
        }
        servletInfo.setDestPage("/planRunLog.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleRender(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.setSaveInSession(false);
        PlanRunLogBean bean = (PlanRunLogBean)servletInfo.getBean();
        String taskID = PlanRunLogAction.assertGetParam(request, "id");
        String cancelling = request.getParameter("cancelling");
        if (cancelling != null && cancelling.equals("true")) {
            bean.setCancelling(true);
        }
        bean.loadAllErrorLogs(taskID, servletInfo.getErrors());
        servletInfo.setDestPage("/planRunLog.jsp");
        servletInfo.setShouldRedirect(false);
    }
}

