/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.TaskStatusBean;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.PageConstants;
import com.raplix.rolloutexpress.ui.web.ParameterConstants;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.security.AccessControlException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PlanRunLink
extends LoggedOnServlet
implements ParameterConstants,
PageConstants,
ActionModeConstants {
    public static final String MSG_ERROR = "error.PlanRunLink";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block8: {
            try {
                String mode = PlanRunLink.assertGetParam(request, "mode");
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Coming through PlanRunLink: " + mode, this);
                }
                if (mode.equals("preflightliveorresults")) {
                    this.handlePreflightLiveOrResults(request, response);
                    break block8;
                }
                if (mode.equals("deploymentliveorresults")) {
                    this.handleDeploymentLiveOrResults(request, response);
                    break block8;
                }
                if (mode.equals("planprogressordetails")) {
                    this.handlePlanProgressOrDetails(request, response);
                    break block8;
                }
                if (mode.equals("preflightcomplete")) {
                    this.handlePreflightComplete(request, response);
                    break block8;
                }
                throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to PlanRunLink.");
            }
            catch (RaplixException re) {
                ServletErrors errors = new ServletErrors();
                errors.setMajorErrorKey(MSG_ERROR);
                errors.addMinorError(re.getMessage());
                request.setAttribute("error.location", (Object)errors);
                this.forwardRequest(request, response, "/errorhome.jsp");
            }
            catch (AccessControlException ace) {
                ServletErrors errors = new ServletErrors();
                errors.setMajorErrorKey(MSG_ERROR);
                errors.addMinorErrorKey(this.ACExToString(ace));
                request.setAttribute("error.location", (Object)errors);
                this.forwardRequest(request, response, "/errorhome.jsp");
            }
        }
    }

    private void handlePreflightLiveOrResults(HttpServletRequest request, HttpServletResponse response) throws RaplixException, IOException {
        String taskID = PlanRunLink.assertGetParam(request, "id");
        TaskStatusBean tsb = this.fetchTaskStatusBean(taskID);
        TaskStatus ts = tsb.getTaskStatus();
        String uri = "";
        uri = ts.equals(TaskStatus.NOT_STARTED) || ts.equals(TaskStatus.PREFLIGHT_RUNNING) ? Util.preflightLiveURI(taskID) : Util.preflightResultsURI(taskID);
        response.sendRedirect(uri);
    }

    private void handleDeploymentLiveOrResults(HttpServletRequest request, HttpServletResponse response) throws RaplixException, IOException {
        String taskID = PlanRunLink.assertGetParam(request, "id");
        TaskStatusBean tsb = this.fetchTaskStatusBean(taskID);
        TaskStatus ts = tsb.getTaskStatus();
        String uri = "";
        uri = ts.equals(TaskStatus.DEPLOYMENT_RUNNING) ? Util.runLiveURI(taskID) : Util.runResultsURI(taskID);
        response.sendRedirect(uri);
    }

    private void handlePlanProgressOrDetails(HttpServletRequest request, HttpServletResponse response) throws RaplixException, IOException {
        String taskID = PlanRunLink.assertGetParam(request, "id");
        String cancelling = request.getParameter("cancelling");
        String isFiltered = request.getParameter("isFiltered");
        String filterHostName = request.getParameter("filterHostName");
        TaskStatusBean tsb = this.fetchTaskStatusBean(taskID);
        TaskStatus ts = tsb.getTaskStatus();
        String uri = "";
        uri = ts.equals(TaskStatus.NOT_STARTED) || ts.equals(TaskStatus.PREFLIGHT_RUNNING) ? Util.preflightLiveURI(taskID) : (ts.equals(TaskStatus.DEPLOYMENT_RUNNING) ? Util.runLiveURI(taskID) : UriUtil.planRunHistoryDetailsURI(taskID));
        if (cancelling != null) {
            uri = uri + "&cancelling=" + cancelling;
        }
        if (isFiltered != null) {
            uri = uri + "&isFiltered=" + isFiltered;
        }
        if (filterHostName != null) {
            uri = uri + "&filterHostName=" + Util.encodeURL(filterHostName);
        }
        response.sendRedirect(uri);
    }

    private void handlePreflightComplete(HttpServletRequest request, HttpServletResponse response) throws RaplixException, IOException {
        String taskID = PlanRunLink.assertGetParam(request, "id");
        TaskStatusBean tsb = this.fetchTaskStatusBean(taskID);
        String uri = "";
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Preflight failed: " + tsb.getPreflightFailed() + ", preflight only: " + tsb.getPreflightOnly(), this);
        }
        uri = tsb.getPreflightFailed() || tsb.getPreflightOnly() ? Util.preflightResultsURI(taskID) : Util.runLiveURI(taskID);
        response.sendRedirect(uri);
    }

    private TaskStatusBean fetchTaskStatusBean(String taskID) throws RaplixException {
        PlanInterface planInterface = PlanRunLink.getApplication().getPlanInterface();
        return planInterface.taskStatusQuery(new TaskID(taskID));
    }
}

