/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXPreflightCompleteEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortRequestedEvent;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.ROXTaskFailedEvent;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskStatusBean;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.PlanInfoBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.data.TaskStatusInfo;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class PlanRunInfoBean
extends PlanInfoBean {
    private static final String MSG_RUNTYPE_ACTUAL = "planRunHistory.runType.plan";
    private static final String MSG_RUNTYPE_PREFLIGHT = "planRunHistory.runType.preflight";
    protected TaskInfo _taskInfo;
    protected final String _taskID;
    private String _runType;
    private boolean _isPreflightOnly;
    private String _runningUser;
    private String _status;
    private String _detailedStatus;
    private String _completion;
    private TaskStatusInfo _taskStatusInfo;
    private boolean _isDeploymentEnabled;
    private boolean _isDeleteHistoryEnabled = false;
    private static final TaskStatusInfoComparator _taskInfoComparator = new TaskStatusInfoComparator();

    public PlanRunInfoBean(String taskID, PlanInterface planInterface, UserManager userDBInterface) {
        super(planInterface, userDBInterface);
        this._taskID = taskID;
        this._taskStatusInfo = new TaskStatusInfo();
    }

    public String getTaskID() {
        return this._taskID;
    }

    public String getRunningUser() {
        return this._runningUser;
    }

    public String getRunType() {
        return this._runType;
    }

    public String getStatus() {
        return this._status;
    }

    public String getDetailedStatus() {
        return this._detailedStatus;
    }

    public String getCompletion() {
        return this._completion;
    }

    public boolean isPreflightOnly() {
        return this._isPreflightOnly;
    }

    public boolean getIsDeploymentEnabled() {
        return this._isDeploymentEnabled;
    }

    public TaskStatusInfo getTaskStatusInfo() {
        return this._taskStatusInfo;
    }

    public boolean isDeleteHistoryEnabled() {
        return this._isDeleteHistoryEnabled;
    }

    public void loadPlanExecutionInfo(SummaryExecutionPlan plan, TaskInfo taskInfo, ServletInfo servletInfo) throws RaplixException {
        super.loadPlan(plan);
        RunLevel runLevel = taskInfo.getRunLevel();
        boolean isPreflightOnly = TaskExecutor.isPreflightRunLevel(runLevel);
        this._runType = this.getRunType(isPreflightOnly);
        this._isPreflightOnly = isPreflightOnly;
        String userName = null;
        UserID taskUserID = taskInfo.getRoxUser();
        User taskUser = this.mUserDBInterface.getUser(taskUserID);
        userName = taskUser.getUsername();
        if (userName == null) {
            userName = "N/A";
        }
        this._runningUser = userName;
        this.determineTaskStatus();
        this._status = this._taskStatusInfo.getShortStatus();
        this._completion = this._taskStatusInfo.getCompletionString();
        this._taskInfo = taskInfo;
        FolderID folderID = plan.getPath();
        this._isDeleteHistoryEnabled = PermissionChecker.hasDeleteHistoryOnFolder(folderID);
    }

    public void loadTaskExecutionDetails(ServletInfo servletInfo) throws RaplixException {
        TaskID taskID = new TaskID(this._taskID);
        TaskInfo taskInfo = this.mPlanInterface.getTaskInfoForTaskID(taskID);
        ExecutionPlan plan = taskInfo.getCompiledPlan().getTopLevelPlan();
        this.loadPlanExecutionInfo(plan, taskInfo, servletInfo);
        this._taskStatusInfo.setRunningUser(this._runningUser);
        this._taskStatusInfo.setRunType(this._runType);
        this._detailedStatus = this._taskStatusInfo.getDetailedStatus(this._taskInfo);
        this._isDeploymentEnabled = this._taskStatusInfo.getIsDeploymentEnabled();
    }

    private void determineTaskStatus() throws RaplixException {
        TaskStatusBean tsb = this.mPlanInterface.taskStatusQuery(new TaskID(this._taskID));
        this._taskStatusInfo = new TaskStatusInfo(tsb);
    }

    public static boolean wasTaskCancelRequested(NotificationRPCInterface notMgr, TaskID taskID) throws RaplixException {
        boolean cancelRequested = false;
        ROXTaskAbortRequestedEvent abortRequestProto = new ROXTaskAbortRequestedEvent();
        abortRequestProto.setTaskID(taskID);
        Vector<ROXTaskAbortRequestedEvent> protos = new Vector<ROXTaskAbortRequestedEvent>();
        protos.add(abortRequestProto);
        try {
            Vector events = notMgr.query(protos);
            cancelRequested = events.size() > 0;
        }
        catch (EmptyQueryException e) {
            // empty catch block
        }
        return cancelRequested;
    }

    public static boolean isPreflightFailed(NotificationRPCInterface notMgr, TaskID taskID) throws RaplixException {
        boolean failed = false;
        ROXPreflightCompleteEvent pfCompletionEventProto = new ROXPreflightCompleteEvent();
        pfCompletionEventProto.setTaskID(taskID);
        pfCompletionEventProto.setSeverity(4);
        Vector<ROXPreflightCompleteEvent> protos = new Vector<ROXPreflightCompleteEvent>();
        protos.add(pfCompletionEventProto);
        try {
            Vector events = notMgr.query(protos);
            failed = events.size() > 0;
        }
        catch (EmptyQueryException e) {
            // empty catch block
        }
        return failed;
    }

    public static boolean isPreflightComplete(NotificationRPCInterface notMgr, TaskID taskID) throws RaplixException {
        Vector<ROXTaskEvent> protos = new Vector<ROXTaskEvent>();
        ROXPreflightCompleteEvent eventProto = new ROXPreflightCompleteEvent();
        eventProto.setTaskID(taskID);
        eventProto.setSeverity(2);
        protos.add(eventProto);
        eventProto = new ROXPreflightCompleteEvent();
        eventProto.setTaskID(taskID);
        eventProto.setSeverity(4);
        protos.add(eventProto);
        ROXTaskFailedEvent tfeProto = new ROXTaskFailedEvent();
        tfeProto.setTaskID(taskID);
        protos.add(tfeProto);
        try {
            boolean taskFailed = false;
            boolean preflightError = false;
            Vector events = notMgr.query(protos);
            Iterator i = events.iterator();
            while (i.hasNext()) {
                Object evObj = i.next();
                if (evObj instanceof ROXPreflightCompleteEvent) {
                    ROXPreflightCompleteEvent pfce = (ROXPreflightCompleteEvent)evObj;
                    if (pfce.getSeverity() == 4) {
                        preflightError = true;
                        continue;
                    }
                    return true;
                }
                if (!(evObj instanceof ROXTaskFailedEvent)) continue;
                taskFailed = true;
            }
            if (taskFailed && preflightError) {
                return true;
            }
        }
        catch (EmptyQueryException e) {
            // empty catch block
        }
        return false;
    }

    public String getRunType(boolean isPreflightOnly) {
        if (isPreflightOnly) {
            return ApplicationResources.getMessage(MSG_RUNTYPE_PREFLIGHT);
        }
        return ApplicationResources.getMessage(MSG_RUNTYPE_ACTUAL);
    }

    public static TaskStatusInfoComparator getComparator() {
        return _taskInfoComparator;
    }

    private static class TaskStatusInfoComparator
    implements Comparator {
        private TaskStatusInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            PlanRunInfoBean p1 = (PlanRunInfoBean)o1;
            PlanRunInfoBean p2 = (PlanRunInfoBean)o2;
            TaskStatusInfo t1 = p1.getTaskStatusInfo();
            TaskStatusInfo t2 = p2.getTaskStatusInfo();
            if (t1.isRunning() && !t2.isRunning()) {
                return -1;
            }
            if (t2.isRunning() && !t1.isRunning()) {
                return 1;
            }
            if (t1.isRunning() && t2.isRunning()) {
                if (t1.getStartDate() != null && t2.getStartDate() != null) {
                    if (t1.getStartDate().after(t2.getStartDate())) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            if (t1.getCompletionDate() != null && t2.getCompletionDate() != null) {
                if (t1.getCompletionDate().after(t2.getCompletionDate())) {
                    return -1;
                }
                return 1;
            }
            return -1;
        }
    }
}

