/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.query.MultiRunningPlanQuery;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class PlanRunHistoryNode
extends StandardObjectDeleteNode {
    private static final int DELETE_CONFIRM_COLSPAN = 3;
    private String mTaskID = "";
    private String mVersion = "";
    private String mCompletedTime = "";

    public PlanRunHistoryNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
        SummaryExecutionPlan plan = (SummaryExecutionPlan)this.getObject(candidate);
        this.mName = plan.getFullName();
        this.mVersion = plan.getVersionNumber().getAsString();
        TaskID taskID = (TaskID)candidate.getParent().getObjectID();
        RunningPlanBean[] runningPlans = MultiRunningPlanQuery.byTaskIDs(new TaskID[]{taskID}).select();
        RunningPlanBean planRun = runningPlans[0];
        this.mTaskID = taskID.toString();
        this.mCompletedTime = Util.formatDate(planRun.getCompleteDate());
        this.preRender();
    }

    public int getDeleteConfirmColspan() {
        return 3;
    }

    public String getDeleteContext() {
        return "planRunHistoryDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        TaskID taskID = (TaskID)candidate.getParent().getObjectID();
        RunningPlanBean[] runningPlans = MultiRunningPlanQuery.byTaskIDs(new TaskID[]{taskID}).select();
        RunningPlanBean planRun = runningPlans[0];
        return planRun.getExecutionPlan();
    }

    public void preRender() {
        int rowLevel = this.mIsUndeletable ? 2 : 0;
        String editURI = UriUtil.planRunHistoryDetailsURI(this.mTaskID);
        String nameLink = Util.standardLink(editURI, "Results of this plan or preflight", Util.preserveSpace(this.mName), "name=\"nameLink-" + this.mObjectID + "\"");
        String vhLink = Util.standardLink(editURI, "Results of this plan or preflight", this.mVersion);
        String timeLink = Util.standardLink(editURI, "Results of this plan or preflight", this.mCompletedTime);
        String cellStart = Util.standardCellStart(0, "nowrap", rowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(vhLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(timeLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

