/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.VariableSettingsManager;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.PlanRunHistoryDetailsBean;
import com.raplix.rolloutexpress.ui.web.PlansErrorConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class PlanRunHistoryHandleAction
extends UIActionServlet
implements ActionModeConstants,
PlansErrorConstants {
    protected static final String PLANHISTORY_ERRORMSG_DETAILS = "error.planrunhistory.details";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through PlanRunHistoryHandleAction, mode = " + mode, this);
        }
        if (mode == null) {
            mode = "details";
        }
        if (!mode.equals("details")) {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to PlanRunHistoryHandleAction.");
        }
        this.handleDetails(request, servletInfo);
    }

    private void handleDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanRunHistoryDetailsBean bean = (PlanRunHistoryDetailsBean)servletInfo.getBean();
        bean.loadTaskExecutionDetails(servletInfo);
        servletInfo.setDestPage("/planRunHistoryDetails.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public ServletBean createBean(HttpServletRequest request) {
        String id = PlanRunHistoryHandleAction.assertGetParam(request, "id");
        PlanInterface planInterface = PlanRunHistoryHandleAction.getApplication().getPlanInterface();
        UserManager userManager = PlanRunHistoryHandleAction.getApplication().getUserManager();
        VariableSettingsManager varSettingsMgr = PlanRunHistoryHandleAction.getApplication().getVariableSettingsManager();
        return new PlanRunHistoryDetailsBean(id, planInterface, userManager, varSettingsMgr);
    }

    public String getDefaultPage() {
        return "/planRunHistoryDetails.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = inRequest.getParameter("mode");
        if (mode.equals("details")) {
            return PLANHISTORY_ERRORMSG_DETAILS;
        }
        String errMsg = "Unknown mode (" + mode + ") passed to PlanRunHistoryHandleAction.";
        throw new IllegalArgumentException(errMsg);
    }
}

