/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.VariableSettingsManager;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.SubplanInfo;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.PlanRunInfoBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import org.apache.struts.util.MessageResources;

public class PlanRunHistoryDetailsBean
extends PlanRunInfoBean {
    private static String MSG_HOSTS_DELETED = "hosts.deletedHosts";
    protected String[] mPlanNames = new String[0];
    protected String[] mPlanHostNames = new String[0];
    protected boolean mPerformDetailedPreflight = false;
    protected String mHostsRunningLimit = "";
    protected String mPlanOverallLimitValue = "";
    protected String mPlanOverallLimitUnits = "";
    protected String mPlanNativeLimitValue = "";
    protected String mPlanNativeLimitUnits = "";
    protected boolean mIsSimplePlan = true;
    protected String[][] mComponentIDs = new String[0][0];
    protected String[][] mComponentNames = new String[0][0];
    protected String[][] mComponentLabels = new String[0][0];
    protected String[][] mVarSettingIDs = new String[0][0];
    protected String[][] mVarSettingNames = new String[0][0];
    protected VariableSettingsManager mVariableSettingsInterface;
    protected MessageResources mMessages = ApplicationResources.getMessageResources();

    public PlanRunHistoryDetailsBean(String taskID, PlanInterface planInterface, UserManager userDBInterface, VariableSettingsManager variableSettingsInterface) {
        super(taskID, planInterface, userDBInterface);
        this.mVariableSettingsInterface = variableSettingsInterface;
    }

    public String[] getPlanNames() {
        return this.mPlanNames;
    }

    public String[] getHostNames() {
        return this.mPlanHostNames;
    }

    public boolean getPerformDetailedPreflight() {
        return this.mPerformDetailedPreflight;
    }

    public String getHostsRunningLimit() {
        return this.mHostsRunningLimit;
    }

    public String getOverallLimitUnits() {
        return this.mPlanOverallLimitUnits;
    }

    public String getNativeLimitUnits() {
        return this.mPlanNativeLimitUnits;
    }

    public String getOverallLimitValue() {
        return this.mPlanOverallLimitValue;
    }

    public String getNativeLimitValue() {
        return this.mPlanNativeLimitValue;
    }

    public boolean isSimplePlan() {
        return this.mIsSimplePlan;
    }

    public String[] getComponentIDs(int index) {
        return this.mComponentIDs[index];
    }

    public String[] getComponentNames(int index) {
        return this.mComponentNames[index];
    }

    public String[] getComponentLabels(int index) {
        return this.mComponentLabels[index];
    }

    public String[] getVarSettingIDs(int index) {
        return this.mVarSettingIDs[index];
    }

    public String[] getVarSettingNames(int index) {
        return this.mVarSettingNames[index];
    }

    public void loadTaskExecutionDetails(ServletInfo servletInfo) throws RaplixException {
        super.loadTaskExecutionDetails(servletInfo);
        this.extractSubplanInfo();
        this.mPerformDetailedPreflight = this._taskInfo.getDetailedPreflight();
        this.mHostsRunningLimit = Integer.toString(this._taskInfo.getPlanThrottle());
        int planTimeout = this._taskInfo.getPlanTimeoutSecs();
        int planNativeTimeout = this._taskInfo.getNativeCallTimeoutSecs();
        int planTimeoutHours = planTimeout / 3600;
        int planTimeoutMinutes = planTimeout % 3600 / 60;
        int planNativeTimeoutHours = planNativeTimeout / 3600;
        int planNativeTimeoutMinutes = planNativeTimeout % 3600 / 60;
        String mins = (planTimeoutMinutes < 10 ? "0" : "") + planTimeoutMinutes;
        this.mPlanOverallLimitValue = planTimeoutHours + ":" + mins;
        this.mPlanOverallLimitUnits = "hours";
        mins = (planNativeTimeoutMinutes < 10 ? "0" : "") + planNativeTimeoutMinutes;
        this.mPlanNativeLimitValue = planNativeTimeoutHours + ":" + mins;
        this.mPlanNativeLimitUnits = "hours";
        this.mIsSimplePlan = this._taskInfo.getCompiledPlan().getTopLevelPlan().isSimplePlan();
    }

    protected void extractSubplanInfo() throws RaplixException {
        SubplanInfo[] infos = this._taskInfo.getSubplanInfos();
        int numTotalTasks = infos.length;
        this.mPlanNames = new String[numTotalTasks];
        this.mPlanHostNames = new String[numTotalTasks];
        for (int t = 0; t < numTotalTasks; ++t) {
            SubplanInfo spi = infos[t];
            this.mPlanNames[t] = spi.getSubplanName();
            StringBuffer sb = new StringBuffer();
            TargetIDSet idSet = spi.getTargetIDSet();
            int numHostsOriginal = idSet.size();
            Target[] planTargets = idSet.getByIDsQuery().select();
            int numHosts = planTargets.length;
            for (int h = 0; h < numHosts; ++h) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(planTargets[h].getInitialHost().getName());
            }
            if (numHostsOriginal > numHosts) {
                if (numHosts > 0) {
                    sb.append(", ");
                }
                sb.append(this.mMessages.getMessage(MSG_HOSTS_DELETED));
            }
            this.mPlanHostNames[t] = sb.toString();
        }
        this.mComponentIDs = new String[numTotalTasks][];
        this.mComponentNames = new String[numTotalTasks][];
        this.mComponentLabels = new String[numTotalTasks][];
        this.mVarSettingIDs = new String[numTotalTasks][];
        this.mVarSettingNames = new String[numTotalTasks][];
        for (int i = 0; i < numTotalTasks; ++i) {
            ComponentID[] compIDs = infos[i].getComponentIDs();
            GeneratedVariableSettingsID[] varSetIDs = infos[i].getGeneratedVariableSettingsIDs();
            int numComponents = compIDs.length;
            this.mComponentIDs[i] = new String[numComponents];
            this.mComponentNames[i] = new String[numComponents];
            this.mComponentLabels[i] = new String[numComponents];
            this.mVarSettingIDs[i] = new String[numComponents];
            this.mVarSettingNames[i] = new String[numComponents];
            for (int j = 0; j < numComponents; ++j) {
                Component comp = compIDs[j].getByIDQuery().select();
                this.mComponentIDs[i][j] = comp.getID().toString();
                this.mComponentNames[i][j] = comp.getFullName();
                this.mComponentLabels[i][j] = comp.getVersionNumber().getAsString() + " (" + comp.getLabel() + ")";
                if (varSetIDs[j] == null) {
                    this.mVarSettingIDs[i][j] = "";
                    this.mVarSettingNames[i][j] = "default";
                    continue;
                }
                GeneratedVariableSettings gvs = this.mVariableSettingsInterface.getVariableSettings(varSetIDs[j]);
                this.mVarSettingIDs[i][j] = gvs.getID().toString();
                this.mVarSettingNames[i][j] = gvs.getName();
            }
        }
    }
}

