/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PlanInfoBean;
import com.raplix.rolloutexpress.ui.web.PlanRunInfoBean;
import com.raplix.rolloutexpress.ui.web.PlansErrorConstants;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class PlanRunHistoryBean
extends PlanInfoBean
implements PlansErrorConstants {
    private String mPlanID = "";
    private String[] mPlanTaskIDs = new String[0];
    private String[] mPlanIDs = new String[0];
    private String[] mPlanRunsVersions = new String[0];
    private String[] mPlanRunsTypes = new String[0];
    private String[] mPlanRunsUsers = new String[0];
    private String[] mPlanRunsCompletedTimes = new String[0];
    private String[] mPlanRunsLastStatuses = new String[0];
    private boolean[] mPlanRunsIsLives = new boolean[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private RunningPlanBean[] mBeans = null;
    private final NotificationRPCInterface mEventDBInterface;

    public PlanRunHistoryBean(PlanInterface planInterface, UserManager userDBInterface, NotificationRPCInterface eventDBInterface) {
        super(planInterface, userDBInterface);
        this.mEventDBInterface = eventDBInterface;
    }

    public String[] getTaskIDs() {
        return this.mPlanTaskIDs;
    }

    public String[] getPlanIDs() {
        return this.mPlanIDs;
    }

    public String[] getVersions() {
        return this.mPlanRunsVersions;
    }

    public String[] getCompletedTimes() {
        return this.mPlanRunsCompletedTimes;
    }

    public String[] getStatuses() {
        return this.mPlanRunsLastStatuses;
    }

    public String[] getRunTypes() {
        return this.mPlanRunsTypes;
    }

    public String[] getRunUsers() {
        return this.mPlanRunsUsers;
    }

    public boolean[] getIsLives() {
        return this.mPlanRunsIsLives;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public void loadPlanExecutionHistory(String planID) throws RaplixException {
        this.mPlanID = planID;
        this.loadPlanByID(this.mPlanID);
        Vector theRunningPlanBeans = this.mEventDBInterface.queryRunningOrCompletedPlans(this.mPlanName, Integer.MAX_VALUE);
        this.mBeans = theRunningPlanBeans.toArray(new RunningPlanBean[0]);
    }

    public void loadGeneratedHistory(String inComponentID, String procedureName, String procedureType) throws RaplixException {
        ComponentID componentID = new ComponentID(inComponentID);
        NamedBlockType type = procedureType.equals(NamedBlockType.INSTALL.toString()) ? NamedBlockType.INSTALL : (procedureType.equals(NamedBlockType.UNINSTALL.toString()) ? NamedBlockType.UNINSTALL : NamedBlockType.CONTROL);
        Vector v = this.mPlanInterface.queryAutoComponentPlansAllVersions(componentID, procedureName, type);
        this.mBeans = v.toArray(new RunningPlanBean[0]);
    }

    public void determinePlanID() throws RaplixException {
        if (this.mBeans.length > 0) {
            this.loadPlanByID(this.mPlanIDs[0]);
        }
    }

    public void processBeans(ServletInfo servletInfo) throws RaplixException {
        Vector<PlanRunInfoBean> vPlanRunInfos = new Vector<PlanRunInfoBean>();
        for (int p = 0; p < this.mBeans.length; ++p) {
            RunningPlanBean currPlanBean = this.mBeans[p];
            PlanRunInfoBean planRunInfo = new PlanRunInfoBean(currPlanBean.getTaskID().toString(), this.mPlanInterface, this.mUserDBInterface);
            planRunInfo.loadPlanExecutionInfo(currPlanBean.getExecutionPlan(), currPlanBean.getTaskInfo(), servletInfo);
            if (!planRunInfo.getTaskStatusInfo().isStarted()) continue;
            vPlanRunInfos.add(planRunInfo);
        }
        this.createSortedStringArrays(vPlanRunInfos);
    }

    private void createSortedStringArrays(Vector vPlanRunInfos) {
        int numPlanRuns = vPlanRunInfos.size();
        if (numPlanRuns == 0) {
            return;
        }
        TreeSet treeSet = new TreeSet(PlanRunInfoBean.getComparator());
        for (int p = 0; p < numPlanRuns; ++p) {
            treeSet.add(vPlanRunInfos.get(p));
        }
        this.mPlanRunsVersions = new String[numPlanRuns];
        this.mPlanTaskIDs = new String[numPlanRuns];
        this.mPlanIDs = new String[numPlanRuns];
        this.mPlanRunsTypes = new String[numPlanRuns];
        this.mPlanRunsUsers = new String[numPlanRuns];
        this.mPlanRunsCompletedTimes = new String[numPlanRuns];
        this.mPlanRunsIsLives = new boolean[numPlanRuns];
        this.mPlanRunsLastStatuses = new String[numPlanRuns];
        int i = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            PlanRunInfoBean planRunInfo = (PlanRunInfoBean)iterator.next();
            this.mPlanTaskIDs[i] = planRunInfo.getTaskID();
            this.mPlanIDs[i] = planRunInfo.getPlanID();
            this.mPlanRunsVersions[i] = planRunInfo.getVersion();
            this.mPlanRunsTypes[i] = planRunInfo.getRunType();
            this.mPlanRunsUsers[i] = planRunInfo.getRunningUser();
            this.mPlanRunsIsLives[i] = planRunInfo.getTaskStatusInfo().isRunning();
            this.mPlanRunsCompletedTimes[i] = planRunInfo.getCompletion();
            this.mPlanRunsLastStatuses[i] = planRunInfo.getStatus();
            ++i;
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mPlanTaskIDs);
    }
}

