/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.PlanRunHistoryBean;
import com.raplix.rolloutexpress.ui.web.PlansErrorConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class PlanRunHistoryAction
extends UIActionServlet
implements ActionModeConstants,
PlansErrorConstants {
    private static final String PLANHISTORY_ERRORMSG_LIST = "error.planrunhistory.list";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "runhistory";
        }
        Logger.debug("Coming through PlanRunHistoryAction: " + mode, this);
        if (mode.equals("runhistory")) {
            this.handleRunHistory(request, servletInfo);
        } else if (mode.equals("generatedrunhistory")) {
            this.handleGeneratedRunHistory(request, servletInfo);
        } else if (mode.equals("deletenotconfirmed")) {
            this.handleDeleteNotConfirmed(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to PlanRunHistoryAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        PlanInterface planInterface = PlanRunHistoryAction.getApplication().getPlanInterface();
        UserManager userManager = PlanRunHistoryAction.getApplication().getUserManager();
        NotificationRPCInterface notMgr = PlanRunHistoryAction.getApplication().getNotificationInterface();
        PlanRunHistoryBean bean = new PlanRunHistoryBean(planInterface, userManager, notMgr);
        return bean;
    }

    public String getDefaultPage() {
        return "/planRunHistory.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        return PLANHISTORY_ERRORMSG_LIST;
    }

    private void handleRunHistory(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanRunHistoryBean prhb = (PlanRunHistoryBean)servletInfo.getBean();
        String id = PlanRunHistoryAction.assertGetParam(request, "id");
        prhb.loadPlanExecutionHistory(id);
        prhb.processBeans(servletInfo);
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleGeneratedRunHistory(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanRunHistoryBean prhb = (PlanRunHistoryBean)servletInfo.getBean();
        String componentID = PlanRunHistoryAction.assertGetParam(request, "componentID");
        String procedureName = PlanRunHistoryAction.assertGetParam(request, "procedureName");
        String procedureType = PlanRunHistoryAction.assertGetParam(request, "procedureType");
        prhb.loadGeneratedHistory(componentID, procedureName, procedureType);
        prhb.processBeans(servletInfo);
        prhb.determinePlanID();
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleDeleteNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey("error.planrunhistory.delete.major");
        servletInfo.getErrors().addMinorErrorKey("error.planrunhistory.noselection");
        this.handleRunHistory(request, servletInfo);
    }
}

