/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.PlanRunDirectBean;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class PlanRunDirectHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR = "error.plans.direct";
    public static final String MSG_ERROR_NONE_INSTALLED = "error.plans.direct.noneinstalled";
    public static final String MSG_ERROR_NONE_SELECTED = "error.plans.direct.noneselected";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "list";
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through PlanRunDirectHandleAction: " + mode, this);
        }
        if (mode.equals("list")) {
            this.handleList(request, servletInfo);
        } else if (mode.equals("noneselected")) {
            this.handleNoneSelected(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to HostsHandleAction.");
        }
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanRunDirectBean prdb = (PlanRunDirectBean)servletInfo.getBean();
        String componentID = PlanRunDirectHandleAction.assertGetParam(request, "componentID");
        String procedureType = PlanRunDirectHandleAction.assertGetParam(request, "procedureType");
        String procedureName = PlanRunDirectHandleAction.assertGetParam(request, "procedureName");
        prdb.fetchOutput(componentID, procedureType, procedureName);
        if (prdb.getAllHostPaths().length == 0) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NONE_INSTALLED);
        }
        servletInfo.setDestPage("/planRunDirect.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleNoneSelected(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanRunDirectBean prdb = (PlanRunDirectBean)servletInfo.getBean();
        String componentID = PlanRunDirectHandleAction.assertGetParam(request, "componentID");
        String procedureType = PlanRunDirectHandleAction.assertGetParam(request, "procedureType");
        String procedureName = PlanRunDirectHandleAction.assertGetParam(request, "procedureName");
        prdb.fetchOutput(componentID, procedureType, procedureName);
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR);
        servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NONE_SELECTED);
        servletInfo.setDestPage("/planRunDirect.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public ServletBean createBean(HttpServletRequest request) {
        PlanRunDirectBean prdb = new PlanRunDirectBean();
        return prdb;
    }

    public String getDefaultPage() {
        return "/planRunDirect.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        return MSG_ERROR;
    }
}

