/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.util.string.StringUtil;

public class PlanRunDirectBean
extends ServletBean {
    private String mProcedureType = "";
    private String mProcedureName = "";
    private String mComponentID = "";
    private String mComponentName = "";
    private String mComponentVersion = "";
    private String[] mHostNames = new String[0];
    private String[] mPaths = new String[0];
    private String[] mAllHostPaths = new String[0];
    private String[] mSelectedHostPaths = new String[0];

    public String getProcedureType() {
        return this.mProcedureType;
    }

    public String getProcedureName() {
        return this.mProcedureName;
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentVersion() {
        return this.mComponentVersion;
    }

    public String[] getHostNames() {
        return this.mHostNames;
    }

    public String[] getPaths() {
        return this.mPaths;
    }

    public String[] getAllHostPaths() {
        return this.mAllHostPaths;
    }

    public String[] getSelectedHostPaths() {
        return this.mSelectedHostPaths;
    }

    public void setComponentID(String componentID, String procedureType, String procedureName) {
        this.mComponentID = componentID;
        this.mProcedureType = procedureType;
        this.mProcedureName = procedureName;
    }

    public void fetchOutput(String componentID, String procedureType, String procedureName) throws RaplixException {
        this.mComponentID = componentID;
        this.mProcedureType = procedureType;
        this.mProcedureName = procedureName;
        Component component = new ComponentID(this.mComponentID).getByIDQuery().select();
        this.mComponentName = component.getFullName();
        this.mComponentVersion = component.getVersionNumber().getAsString();
        MultiInstalledComponentQuery installedComponentsQuery = MultiInstalledComponentQuery.byTopLevelComp(component.getID());
        InstalledComponentBean[] installedComponents = installedComponentsQuery.select();
        int installedComponentsSize = installedComponents.length;
        this.mHostNames = new String[installedComponentsSize];
        this.mPaths = new String[installedComponentsSize];
        this.mAllHostPaths = new String[installedComponentsSize];
        this.mSelectedHostPaths = new String[0];
        for (int i = 0; i < installedComponentsSize; ++i) {
            InstalledComponentBean icb = installedComponents[i];
            Target target = icb.getTarget();
            this.mHostNames[i] = target != null ? target.getCurrentHost().getName() : "";
            this.mPaths[i] = StringUtil.normalizeEmpty(icb.getComponentInstallPath());
            this.mAllHostPaths[i] = this.mHostNames[i] + " (" + this.mPaths[i] + ")";
        }
    }
}

