/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.query.MultiRunningPlanQuery;
import com.raplix.rolloutexpress.executor.query.RunningPlanQueryOrder;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.Util;

public class PlanRunAllPlansBean
extends ServletListBean {
    private static final String MSG_COMPLETION_STATUS_RUNNING = "homePage.taskCompletion.running";
    private String[] mNames = new String[0];
    private String[] mPlanIDs = new String[0];
    private String[] mTaskIDs = new String[0];
    private String[] mVersions = new String[0];
    private String[] mCompletedTimes = new String[0];
    private boolean[] mIsRunning = new boolean[0];
    private boolean[] mIsHidden = new boolean[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String mMode = "";

    public String[] getNames() {
        return this.mNames;
    }

    public String[] getPlanIDs() {
        return this.mPlanIDs;
    }

    public String[] getTaskIDs() {
        return this.mTaskIDs;
    }

    public String[] getVersions() {
        return this.mVersions;
    }

    public String[] getCompletedTimes() {
        return this.mCompletedTimes;
    }

    public boolean[] getIsRunning() {
        return this.mIsRunning;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public String getMode() {
        return this.mMode;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void generateList() throws RaplixException {
        MultiRunningPlanQuery query = MultiRunningPlanQuery.allPlans();
        if (this.getShowHidden()) {
            query.setVisibilityFilter(null);
        } else {
            query.setVisibilityFilter(Visibility.VISIBLE);
        }
        query.setCategoryFilter(this.getCategoryFilter());
        this.prepQuery(query, RunningPlanQueryOrder.BY_DATE_DSC);
        this.generateOutputArrays(query.select());
    }

    private void generateOutputArrays(RunningPlanBean[] beans) {
        int numPlans = beans.length;
        this.mNames = new String[numPlans];
        this.mPlanIDs = new String[numPlans];
        this.mTaskIDs = new String[numPlans];
        this.mVersions = new String[numPlans];
        this.mCompletedTimes = new String[numPlans];
        this.mIsRunning = new boolean[numPlans];
        this.mIsHidden = new boolean[numPlans];
        for (int i = 0; i < numPlans; ++i) {
            this.mNames[i] = beans[i].getExecutionPlan().getFullName();
            this.mPlanIDs[i] = beans[i].getExecutionPlanID().toString();
            this.mTaskIDs[i] = beans[i].getTaskID().toString();
            this.mVersions[i] = beans[i].getExecutionPlan().getVersionNumber().getAsString();
            this.mIsHidden[i] = beans[i].getExecutionPlan().getVisibility().equals(Visibility.HIDDEN);
            this.mIsRunning[i] = this.mapTaskStatusToRunning(beans[i].getTaskStatus());
            this.mCompletedTimes[i] = this.mIsRunning[i] ? ApplicationResources.getMessage(MSG_COMPLETION_STATUS_RUNNING, beans[i].getStartDate()) : Util.formatDate(beans[i].getCompleteDate());
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mTaskIDs);
    }

    boolean mapTaskStatusToRunning(TaskStatus ts) {
        return ts.equals(TaskStatus.PREFLIGHT_RUNNING) || ts.equals(TaskStatus.DEPLOYMENT_RUNNING) || ts.equals(TaskStatus.NOT_STARTED);
    }

    public boolean getCanBeHidden() {
        return true;
    }
}

