/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.MultiStepStatusQuery;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.StepStatusQueryOrder;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.TaskInfoBean;
import com.raplix.rolloutexpress.ui.web.UIActionException;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.logger.Logger;

public class PlanRunAllHostsBean
extends TaskInfoBean {
    private String mFilterHostName = "";
    private String mIsFiltered = "false";
    private String mPhase = "";
    private String mStepMapID = "";
    private String mStepType = "";
    private String mStepDescription = "";
    private String[] mStepLogicalHostNames = new String[0];
    private String[] mStepPhysicalHostNames = new String[0];
    private String[] mStepIDs = new String[0];
    private String[] mStepStartDates = new String[0];
    private String[] mStepCompleteDates = new String[0];
    private String[] mStepStatusMessages = new String[0];
    private String[] mStepStatuses = new String[0];
    private int mPercentageComplete = 0;
    private boolean mFootnoteEnabled = false;
    private boolean[] mHasDetails = new boolean[0];

    public PlanRunAllHostsBean(PlanInterface planInterface, UserManager userMgr) {
        super(planInterface, userMgr);
    }

    public String getFilterHostName() {
        return this.mFilterHostName;
    }

    public String getIsFiltered() {
        return this.mIsFiltered;
    }

    public String getPhase() {
        return this.mPhase;
    }

    public int getPercentageComplete() {
        return this.mPercentageComplete;
    }

    public String getStepMapID() {
        return this.mStepMapID;
    }

    public String getStepType() {
        return this.mStepType;
    }

    public String getStepDescription() {
        return this.mStepDescription;
    }

    public String[] getStepLogicalHostNames() {
        return this.mStepLogicalHostNames;
    }

    public String[] getStepPhysicalHostNames() {
        return this.mStepPhysicalHostNames;
    }

    public String[] getStepIDs() {
        return this.mStepIDs;
    }

    public String[] getStepStartDates() {
        return this.mStepStartDates;
    }

    public String[] getStepCompleteDates() {
        return this.mStepCompleteDates;
    }

    public String[] getStepStatusMessages() {
        return this.mStepStatusMessages;
    }

    public String[] getStepStatuses() {
        return this.mStepStatuses;
    }

    public boolean getFootnoteEnabled() {
        return this.mFootnoteEnabled;
    }

    public boolean[] getHasDetails() {
        return this.mHasDetails;
    }

    public void loadAllHostsResults(String taskID, String filterHostName, String phase, ServletErrors errors, String stepMapIDStr) throws RaplixException {
        this.loadTaskInfo(taskID, errors, phase);
        this.mPercentageComplete = this.mIsHistory ? 100 : 0;
        this.mStepMapID = stepMapIDStr;
        this.mPhase = phase;
        if (filterHostName != null) {
            this.mIsFiltered = "true";
            this.mFilterHostName = filterHostName;
        } else {
            this.mIsFiltered = "false";
            this.mFilterHostName = "";
        }
        int stepMapID = new Double(this.mStepMapID).intValue();
        MultiStepStatusQuery mssq = null;
        if (this.mIsFiltered.equals("true")) {
            try {
                HostID host = HostsBean.getSummaryHostByName(this.mFilterHostName).getID();
                mssq = this.mPhase.equals("runlive") || this.mPhase.equals("runresults") ? MultiStepStatusQuery.stepOnAllHosts(new TaskID(this.mTaskID), host, stepMapID, RunLevel.ACTUAL) : MultiStepStatusQuery.stepOnAllHosts(new TaskID(this.mTaskID), host, stepMapID, RunLevel.PREFLIGHT);
            }
            catch (UIActionException uiae) {
                errors.addMinorError(uiae.getMessage());
            }
        }
        if (mssq == null) {
            mssq = this.mPhase.equals("runlive") || this.mPhase.equals("runresults") ? MultiStepStatusQuery.stepOnAllHosts(new TaskID(this.mTaskID), stepMapID, RunLevel.ACTUAL) : MultiStepStatusQuery.stepOnAllHosts(new TaskID(this.mTaskID), stepMapID, RunLevel.PREFLIGHT);
        }
        this.prepQuery(mssq, StepStatusQueryOrder.BY_STEPMAP_ASC);
        StepStatusBean[] steps = mssq.select();
        int numSteps = steps.length;
        if (numSteps == 0) {
            return;
        }
        this.mStepType = ExecStep.getStepTypeStringRepresentation(steps[0].getStepInfo().getStepType());
        this.mStepDescription = steps[0].getStepInfo().getDescription();
        this.mStepLogicalHostNames = new String[numSteps];
        this.mStepPhysicalHostNames = new String[numSteps];
        this.mStepIDs = new String[numSteps];
        this.mStepStartDates = new String[numSteps];
        this.mStepCompleteDates = new String[numSteps];
        this.mStepStatusMessages = new String[numSteps];
        this.mStepStatuses = new String[numSteps];
        this.mFootnoteEnabled = false;
        this.mHasDetails = new boolean[numSteps];
        for (int i = 0; i < numSteps; ++i) {
            StepInfo stepInfo = steps[i].getStepInfo();
            Target t = stepInfo.getTargetID().getByIDQuery().select();
            this.mStepIDs[i] = stepInfo.getStepID().toString();
            this.mStepStatuses[i] = Util.getLabelForStepStatus(stepInfo.getStepStatus());
            this.mStepStatusMessages[i] = stepInfo.getExceptionDescription();
            this.mStepLogicalHostNames[i] = t.getInitialHost().getName();
            if (t.getInitialHostID().equals(t.getPhysicalHostID()) || stepInfo.getStepStatus().equals(StepStatus.PREFLIGHT_ERROR) || stepInfo.getStepStatus().equals(StepStatus.PRIOR_ERROR)) {
                this.mStepPhysicalHostNames[i] = "";
            } else {
                this.mStepPhysicalHostNames[i] = t.getPhysicalHost().getName();
                this.mFootnoteEnabled = true;
            }
            this.mStepStartDates[i] = Util.formatDate(stepInfo.getStartDate());
            this.mStepCompleteDates[i] = Util.formatDate(stepInfo.getCompleteDate());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("status is: [" + stepInfo.getStepStatus().toString() + "]", this);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("step " + i + " has children: " + steps[i].getStepInfo().getChildren().size(), this);
            }
            if (steps[i].getStepInfo().getChildren().size() <= 0) continue;
            this.mHasDetails[i] = true;
        }
    }
}

