/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PlanPrepareBean;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import javax.servlet.http.HttpServletRequest;

public class PlanPrepareHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_PROMPT = "error.planrunprepare.prompt";
    public static final String MSG_ERROR_PREPARE = "error.planrunprepare.prompt";
    public static final String MSG_ERROR_REFRESH = "error.planrunprepare.prompt";
    public static final String MSG_ERROR_CANCEL = "error.planrunprepare.cancel";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "prompt";
        }
        if (mode.equals("prompt")) {
            this.handlePrompt(request, servletInfo);
        } else if (mode.equals("prepare")) {
            this.handlePrepare(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to PlanPrepareHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        PlanInterface planInterface = PlanPrepareHandleAction.getApplication().getPlanInterface();
        SessionManager sessionManager = PlanPrepareHandleAction.getApplication().getUserSessionManager();
        PlanPrepareBean ppb = new PlanPrepareBean(planInterface, sessionManager);
        return ppb;
    }

    public String getDefaultPage() {
        return "/planPrepareProgress.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = inRequest.getParameter("mode");
        if (mode == null) {
            mode = "prompt";
        }
        if (mode.equals("prompt")) {
            return "error.planrunprepare.prompt";
        }
        if (mode.equals("prepare")) {
            return "error.planrunprepare.prompt";
        }
        if (mode.equals("refresh")) {
            return "error.planrunprepare.prompt";
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to PlanPrepareHandleAction.");
    }

    private void handlePrompt(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanPrepareBean ppb = (PlanPrepareBean)servletInfo.getBean();
        ppb.setMode("prompt");
        this.readFromRequest(request, ppb);
        servletInfo.setDestPage("/planPreparePrompt.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handlePrepare(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanPrepareBean ppb = (PlanPrepareBean)servletInfo.getBean();
        this.readFromRequest(request, ppb);
        ppb.kickOffPrepare();
        ppb.fetchOutput();
        servletInfo.setDestPage("/planPrepareProgress.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanPrepareBean ppb = (PlanPrepareBean)servletInfo.getBean();
        String taskID = PlanPrepareHandleAction.assertGetParam(request, "id");
        ppb.setTaskID(taskID);
        if (request.getParameter("cancelling") != null) {
            ppb.setCancelling(true);
        }
        if (request.getParameter("previousRunning") != null) {
            ppb.setPreviousRunning(true);
        }
        ppb.fetchOutput();
        servletInfo.setDestPage("/planPrepareProgress.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PlanPrepareBean ppb = (PlanPrepareBean)servletInfo.getBean();
        String taskID = PlanPrepareHandleAction.assertGetParam(request, "id");
        ppb.setTaskID(taskID);
        ppb.cancelPrepare();
        ppb.setPreviousRunning(false);
        ppb.fetchOutput();
        servletInfo.setDestPage("/planPrepareProgress.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void readFromRequest(HttpServletRequest request, PlanPrepareBean ppb) throws RaplixException {
        String hostID = request.getParameter("hostID");
        String multiLocation = request.getParameter("multiLocation");
        String selected = request.getParameter("selected");
        HostIDSet hostIDSet = null;
        if (hostID == null) {
            hostID = "";
        }
        if (selected == null) {
            selected = "";
        }
        if (multiLocation == null) {
            multiLocation = "";
        }
        if (!multiLocation.equals("")) {
            MultiCheckbox mc = (MultiCheckbox)request.getSession().getAttribute(multiLocation);
            ppb.setMultiCheckbox(mc);
        }
        if (hostID.equals("") && multiLocation.equals("")) {
            hostIDSet = (HostIDSet)request.getSession().getAttribute("session.hostidset");
        }
        ppb.setHostID(hostID);
        ppb.setMultiLocation(multiLocation);
        ppb.setSelected(selected);
        ppb.setHostIDSet(hostIDSet);
        ppb.resolveHostIDs();
    }
}

