/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.TaskHostStatusBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.TaskStatusByHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.logger.Logger;
import java.util.Iterator;

public class PlanPrepareBean
extends ServletBean {
    private String mHostID = "";
    private String mMultiLocation = "";
    private String mSelected = "";
    private String mTaskID = "";
    private boolean mRunning = false;
    private boolean mPreviousRunning = false;
    private String[] mHostIDs = new String[0];
    private String[] mHostNames = new String[0];
    private String[] mHostTypes = new String[0];
    private String[] mHostDates = new String[0];
    private String[] mHostStatuses = new String[0];
    private boolean[] mHostRunnings = new boolean[0];
    private boolean mCancelling = false;
    private String mMode = "";
    private MultiCheckbox mMultiCheckbox = null;
    private HostIDSet mHostIDSet = null;
    private final PlanInterface mPlanInterface;
    private SessionManager mSessionManager = null;

    public PlanPrepareBean(PlanInterface planInterface, SessionManager sessionManager) {
        this.mPlanInterface = planInterface;
        this.mSessionManager = sessionManager;
    }

    public String getID() {
        if (this.mTaskID.equals("")) {
            return super.getID();
        }
        return this.mTaskID;
    }

    public String getHostID() {
        return this.mHostID;
    }

    public String getMultiLocation() {
        return this.mMultiLocation;
    }

    public String getSelected() {
        return this.mSelected;
    }

    public String getTaskID() {
        return this.mTaskID;
    }

    public boolean getRunning() {
        return this.mRunning;
    }

    public String[] getHostIDs() {
        return this.mHostIDs;
    }

    public String[] getHostNames() {
        return this.mHostNames;
    }

    public String[] getHostTypes() {
        return this.mHostTypes;
    }

    public String[] getHostDates() {
        return this.mHostDates;
    }

    public String[] getHostStatuses() {
        return this.mHostStatuses;
    }

    public boolean[] getHostRunnings() {
        return this.mHostRunnings;
    }

    public boolean getCancelling() {
        return this.mCancelling;
    }

    public boolean getPreviousRunning() {
        return this.mPreviousRunning;
    }

    public void setTaskID(String taskID) {
        this.mTaskID = taskID;
    }

    public void setHostID(String hostID) {
        this.mHostID = hostID;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setSelected(String selected) {
        this.mSelected = selected;
    }

    public void setMultiLocation(String ml) {
        this.mMultiLocation = ml;
    }

    public void setMultiCheckbox(MultiCheckbox mc) {
        this.mMultiCheckbox = mc;
    }

    public void setHostIDSet(HostIDSet his) {
        this.mHostIDSet = his;
    }

    public void setCancelling(boolean cancelling) {
        this.mCancelling = cancelling;
    }

    public void setPreviousRunning(boolean previous) {
        this.mPreviousRunning = previous;
    }

    public void fetchOutput() throws RaplixException {
        TaskHostStatusBean[] thsb = this.mPlanInterface.taskStatusByHostQuery(new TaskID(this.mTaskID));
        if (thsb.length == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No beans received for task " + this.mTaskID, this);
            }
            this.mRunning = true;
            return;
        }
        TaskStatus ts = thsb[0].getTaskInfo().getTaskStatus();
        if (ts.equals(TaskStatus.PREFLIGHT_RUNNING) || ts.equals(TaskStatus.DEPLOYMENT_RUNNING) || ts.equals(TaskStatus.NOT_STARTED)) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Task status is " + ts.toString(), this);
            }
            this.mRunning = true;
        } else {
            this.mRunning = false;
        }
        this.mHostIDs = new String[thsb.length];
        this.mHostNames = new String[thsb.length];
        this.mHostTypes = new String[thsb.length];
        this.mHostDates = new String[thsb.length];
        this.mHostStatuses = new String[thsb.length];
        this.mHostRunnings = new boolean[thsb.length];
        for (int i = 0; i < thsb.length; ++i) {
            this.mHostIDs[i] = thsb[i].getSummaryHost().getID().toString();
            this.mHostNames[i] = thsb[i].getSummaryHost().getName();
            this.mHostTypes[i] = thsb[i].getSummaryHostType().getName();
            this.mHostDates[i] = thsb[i].getPreparedDate() == null ? "" : Util.formatDate(thsb[i].getPreparedDate());
            this.mHostStatuses[i] = this.hostStatusToString(thsb[i].getTaskStatusByHost());
            this.mHostRunnings[i] = this.hostStatusToRunning(thsb[i].getTaskStatusByHost());
        }
    }

    private String hostStatusToString(TaskStatusByHost s) {
        if (s.equals(TaskStatusByHost.INCOMPLETE_ABORT)) {
            return ApplicationResources.getMessage("planRunPrepare.cancelled");
        }
        if (s.equals(TaskStatusByHost.INCOMPLETE_ERROR)) {
            return ApplicationResources.getMessage("planRunPrepare.incomplete");
        }
        if (s.equals(TaskStatusByHost.INCOMPLETE_TIMEOUT)) {
            return ApplicationResources.getMessage("planRunPrepare.incomplete");
        }
        if (s.equals(TaskStatusByHost.COMPLETE)) {
            return ApplicationResources.getMessage("planRunPrepare.completed");
        }
        if (s.equals(TaskStatusByHost.IN_PROGRESS)) {
            return ApplicationResources.getMessage("planRunPrepare.inprogress");
        }
        if (s.equals(TaskStatusByHost.NOT_STARTED)) {
            return ApplicationResources.getMessage("planRunPrepare.notstarted");
        }
        return "[unknown]";
    }

    private boolean hostStatusToRunning(TaskStatusByHost s) {
        return s.equals(TaskStatusByHost.IN_PROGRESS) || s.equals(TaskStatusByHost.NOT_STARTED);
    }

    public void resolveHostIDs() throws RaplixException {
        block4: {
            block5: {
                block3: {
                    if (this.mHostID.equals("")) break block3;
                    this.mHostNames = new String[1];
                    this.mHostNames[0] = HostsBean.getSummaryHostByID(new HostID(this.mHostID)).getName();
                    break block4;
                }
                if (this.mMultiCheckbox == null) break block5;
                this.mMultiCheckbox.setSelected(this.mSelected);
                String[] selected = this.mMultiCheckbox.getSelected();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("MC exists.  selected count is " + selected.length, this);
                }
                this.mHostNames = new String[selected.length];
                for (int i = 0; i < selected.length; ++i) {
                    this.mHostNames[i] = HostsBean.getSummaryHostByID(selected[i]).getName();
                }
                break block4;
            }
            if (this.mHostIDSet == null) break block4;
            this.mHostNames = new String[this.mHostIDSet.size()];
            int i = 0;
            Iterator iter = this.mHostIDSet.iterator();
            while (iter.hasNext()) {
                HostID h = (HostID)iter.next();
                this.mHostNames[i] = HostsBean.getSummaryHostByID(h).getName();
                ++i;
            }
        }
    }

    public void kickOffPrepare() throws RaplixException {
        HostIDSet his = new HostIDSet();
        if (!this.mHostID.equals("")) {
            his.add(new HostID(this.mHostID));
        } else if (this.mMultiCheckbox != null) {
            this.mMultiCheckbox.setSelected(this.mSelected);
            String[] selected = this.mMultiCheckbox.getSelected();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("MC exists.  selected count is " + selected.length, this);
            }
            for (int i = 0; i < selected.length; ++i) {
                his.add(new HostID(selected[i]));
            }
        } else if (this.mHostIDSet != null) {
            his = this.mHostIDSet;
        }
        UserID userID = this.mSessionManager.getCurrentUserID();
        this.mTaskID = this.mPlanInterface.prepHosts(his, userID).toString();
    }

    public void cancelPrepare() throws RaplixException {
        this.mPlanInterface.requestHalt(new TaskID(this.mTaskID));
        this.mCancelling = true;
    }
}

