/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.Util;

public class PlanInfoBean
extends ServletBean {
    protected final PlanInterface mPlanInterface;
    protected final UserManager mUserDBInterface;
    protected String mPlanID = "";
    protected String mPlanName = "";
    protected String mPlanVersion = "";
    protected String mPlanDescription = "";
    protected String mCheckedInDate = "";
    protected String mCheckedInUserName = "";

    public PlanInfoBean(PlanInterface planInterface, UserManager userDBInterface) {
        this.mPlanInterface = planInterface;
        this.mUserDBInterface = userDBInterface;
    }

    public String getPlanID() {
        return this.mPlanID;
    }

    public String getName() {
        return this.mPlanName;
    }

    public String getVersion() {
        return this.mPlanVersion;
    }

    public String getDescription() {
        return this.mPlanDescription;
    }

    public String getCheckedInDate() {
        return this.mCheckedInDate;
    }

    public String getCheckedInUserName() {
        return this.mCheckedInUserName;
    }

    protected ExecutionPlan loadPlanByID(String inID) throws RaplixException {
        ExecutionPlan plan = new ExecutionPlanID(inID).getByIDQuery().select();
        this.loadPlan(plan);
        return plan;
    }

    protected void loadPlan(SummaryExecutionPlan plan) throws RaplixException {
        this.mPlanID = plan.getID().toString();
        this.mPlanName = plan.getFullName();
        this.mPlanVersion = plan.getVersionNumber().getAsString();
        this.mPlanDescription = plan.getDescription();
        this.mCheckedInDate = Util.formatDate(plan.getTimeStamp());
        this.mCheckedInUserName = this.mUserDBInterface.getUser(plan.getUserID()).getUsername();
    }
}

