/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PlanDownloadAction
extends LoggedOnServlet {
    private static final String PARAM_MODE_FILENAME_ADDED_DOWNLOAD = "filenameaddeddownload";
    public static final String MSG_ERROR_MAJOR = "error.plans.download";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String mode = request.getParameter("mode");
        String id = PlanDownloadAction.assertGetParam(request, "id");
        try {
            ExecutionPlan thePlan = new ExecutionPlanID(id).getByIDQuery().select();
            if (mode == null || !mode.equals(PARAM_MODE_FILENAME_ADDED_DOWNLOAD)) {
                String planName = thePlan.getName();
                String planVersion = thePlan.getVersionNumber().getAsString();
                String redirectAddress = "/PlanDownload/" + Util.encodeURL(planName) + "-" + planVersion + ".xml?id=" + id + "&mode=" + PARAM_MODE_FILENAME_ADDED_DOWNLOAD;
                response.sendRedirect(redirectAddress);
                return;
            }
            response.setContentType("application/octet-stream; charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print(thePlan.writeToXML());
        }
        catch (RaplixException e) {
            ServletErrors errors = new ServletErrors();
            Logger.debug("Exception caught in PlanDownload: " + e.getMessage(), e, this);
            errors.setMajorErrorKey(MSG_ERROR_MAJOR);
            errors.addMinorError(e.getMessage());
            request.setAttribute("error.location", (Object)errors);
            this.forwardRequest(request, response, "/errorhome.jsp");
        }
    }
}

