/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class PlanDeleteNode
extends StandardObjectDeleteNode {
    private static final int DELETE_CONFIRM_COLSPAN = 3;
    private String mVersion = "";

    public PlanDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
        SummaryExecutionPlan plan = (SummaryExecutionPlan)this.getObject(candidate);
        this.mName = plan.getFullName();
        this.mVersion = plan.getVersionNumber().getAsString();
        this.preRender();
    }

    public int getDeleteConfirmColspan() {
        return 3;
    }

    public String getDeleteContext() {
        return "planDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        ExecutionPlanID planID = (ExecutionPlanID)candidate.getParent().getObjectID();
        return planID.getByIDQuery().selectSummaryView();
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String viewURI = UriUtil.planDetailsURI(this.mObjectID.toString());
        String toolTip = "Show plan details";
        String nameLink = Util.standardLink(viewURI, toolTip, Util.preserveSpace(this.mName), "name=\"nameLink-" + this.mObjectID + "\"");
        String verLink = Util.standardLink(viewURI, toolTip, this.mVersion);
        String descLink = Util.standardLink(viewURI, toolTip, this.mDescription);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(verLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

