/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.difference.DifferencePermission;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistPermission;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.JobInfo;
import com.raplix.rolloutexpress.systemmodel.userdb.TaskPermission;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;

public class PermissionChecker {
    public static boolean hasPermission(Permission perm) {
        try {
            AccessController.checkPermission(perm);
        }
        catch (AccessControlException ace) {
            return false;
        }
        return true;
    }

    public static boolean hasWriteOnFolder(FolderID folderID) {
        FolderPermission writeOnFolder = new FolderPermission(folderID, "write");
        return PermissionChecker.hasPermission(writeOnFolder);
    }

    public static boolean hasWriteOnAnyFolder() {
        FolderPermission writeOnAnyFolder = FolderPermission.createTestAnyFolder("write");
        return PermissionChecker.hasPermission(writeOnAnyFolder);
    }

    public static boolean hasExecuteOnFolder(FolderID folderID) {
        FolderPermission executeOnFolder = FolderPermission.createTestExecuteAnywhere(folderID);
        return PermissionChecker.hasPermission(executeOnFolder);
    }

    public static boolean hasDeleteHistoryOnFolder(FolderID folderID) {
        FolderPermission deleteHistoryOnFolder = FolderPermission.createTestDeleteHistoryAnywhere(folderID);
        return PermissionChecker.hasPermission(deleteHistoryOnFolder);
    }

    public static boolean hasExecuteOnSystemFolder() {
        try {
            FolderID systemFolderID = PermissionChecker.getSystemFolderID();
            return PermissionChecker.hasExecuteOnFolder(systemFolderID);
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(PermissionChecker.class)) {
                Logger.debug("Unexpected exception", e, PermissionChecker.class);
            }
            return false;
        }
    }

    public static boolean hasExecuteOnSystemFolderForHost(HostID hostID) {
        try {
            FolderID systemFolderID = PermissionChecker.getSystemFolderID();
            FolderPermission executeOnFolderHostDuo = FolderPermission.createExecutePermission(systemFolderID, hostID);
            return PermissionChecker.hasPermission(executeOnFolderHostDuo);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasCheckinCurrentOnFolder(FolderID folderID) {
        FolderPermission checkinCurrentOnFolder = new FolderPermission(folderID, "checkin");
        return PermissionChecker.hasPermission(checkinCurrentOnFolder);
    }

    public static boolean hasAutoRunOnFolder(FolderID folderID) {
        FolderPermission autoRunOnFolder = new FolderPermission(folderID, "autorun");
        return PermissionChecker.hasPermission(autoRunOnFolder);
    }

    public static boolean hasWriteOnSystemService() {
        PersistPermission writeOnSystemService = new PersistPermission("SystemServiceRef", "write");
        return PermissionChecker.hasPermission(writeOnSystemService);
    }

    public static boolean hasWriteOnComponentType() {
        PersistPermission writeOnComponentType = new PersistPermission("ComponentTypeRef", "write");
        return PermissionChecker.hasPermission(writeOnComponentType);
    }

    public static boolean hasWriteOnPlugin() {
        PersistPermission writeOnPlugin = new PersistPermission("plugindb.Plugin", "write");
        return PermissionChecker.hasPermission(writeOnPlugin);
    }

    public static boolean hasWriteOnHosts() {
        PersistPermission writeOnHosts = new PersistPermission("hostdb.host.*", "write");
        return PermissionChecker.hasPermission(writeOnHosts);
    }

    public static boolean hasWriteOnHostTypes() {
        return PermissionChecker.hasWriteOnHosts();
    }

    public static boolean hasWriteOnHostSets() {
        return PermissionChecker.hasWriteOnHosts();
    }

    public static boolean hasWriteOnHostSearches() {
        return PermissionChecker.hasWriteOnHosts();
    }

    public static boolean hasWriteOnRules() {
        PersistPermission writeOnRules = new PersistPermission("rule.Rule", "write");
        return PermissionChecker.hasPermission(writeOnRules);
    }

    public static boolean hasWriteOnDiffs() {
        PersistPermission writeOnDiffs = new PersistPermission("differencedb.DifferenceSettings", "write");
        return PermissionChecker.hasPermission(writeOnDiffs);
    }

    public static boolean hasDiffRun() {
        DifferencePermission diffRun = new DifferencePermission("anyhost", null);
        return PermissionChecker.hasPermission(diffRun);
    }

    public static boolean hasWriteOnUsers() {
        PersistPermission writeOnUsers = new PersistPermission("userdb.*", "write");
        return PermissionChecker.hasPermission(writeOnUsers);
    }

    public static boolean hasWriteOnGroups() {
        return PermissionChecker.hasWriteOnUsers();
    }

    public static boolean hasTaskOwnerPermission(JobInfo ji) {
        TaskPermission perm = new TaskPermission(ji.getTaskOwner());
        return PermissionChecker.hasPermission(perm);
    }

    public static boolean hasWriteOnPlugin(PluginMember pm) {
        return pm.getPluginID() == null;
    }

    private static FolderID getSystemFolderID() throws RPCException, PersistenceManagerException {
        return SystemPluginConstants.getInstance().SYSTEM_FOLDER_ID;
    }
}

