/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.rule.RuleException;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataManager;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.NotRulesBean;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletRequest;

public class NotRulesHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String PARAM_DESC = "description";
    public static final String PARAM_EVENTTYPE = "eventType";
    public static final String PARAM_EVENTPATTERN = "eventPattern";
    public static final String PARAM_HOSTNAMES = "hostNames";
    public static final String PARAM_HOSTSETID = "hostSetID";
    public static final String PARAM_SEVERITY = "severity";
    public static final String PARAM_SEVERITYCOMPARISON = "severityComparison";
    public static final String PARAM_EMAILADDRESS = "emailAddress";
    public static final String PARAM_TYPE_OR_SEVERITY = "typeOrSeverity";
    public static final String MSG_ERROR_CREATE = "error.noteRules.create";
    public static final String MSG_ERROR_EDIT = "error.noteRules.edit";
    public static final String MSG_ERROR_CANCEL = "error.noteRules.cancel";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.noteRules.save.major";
    public static final String MSG_ERROR_SAVE_INVALID_HOST = "error.noteRules.save.invalidHost";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = NotRulesHandleAction.assertGetParam(request, "mode");
        Logger.debug("Coming through NotRulesHandleAction: " + mode, this);
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("saveas")) {
            this.handleSaveAs(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("notconfirmed")) {
            this.handleNotConfirmed(request, servletInfo);
        } else if (mode.equals("saveconfirmed")) {
            this.handleSaveAsConfirmed(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to NotRulesHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        NotRulesBean nrb;
        String mode = NotRulesHandleAction.assertGetParam(request, "mode");
        if (mode.equals("add") || mode.equals("edit")) {
            RuleMetaDataManager ruleMetaDataMgr = NotRulesHandleAction.getApplication().getRuleMetaDataManager();
            nrb = new NotRulesBean(ruleMetaDataMgr);
        } else {
            String id = request.getParameter("id");
            nrb = (NotRulesBean)request.getSession().getAttribute(id);
            if (nrb == null) {
                throw new IllegalArgumentException("Required bean not found in session for NotRulesHandleAction.");
            }
        }
        return nrb;
    }

    public String getDefaultPage() {
        return "/notRules.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = NotRulesHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveas")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("notconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("saveconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        throw new IllegalArgumentException("Unknown mode passed to NotRulesHandleAction.");
    }

    protected void handleSaveAsConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        NotRulesBean nrb = (NotRulesBean)servletInfo.getBean();
        String name = request.getParameter("name");
        nrb.setName(name);
        nrb.setIsNew(true);
        nrb.fillMetaData();
        try {
            nrb.persist();
        }
        catch (RuleException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(re.getMessage());
            nrb.setMode("saveas");
            servletInfo.setDestPage("/notRuleConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            nrb.setMode("saveas");
            servletInfo.setDestPage("/notRuleConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/NotificationRules");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        NotRulesBean nrb = (NotRulesBean)servletInfo.getBean();
        this.saveRequestValues(nrb, request);
        if (!this.convertHostNamesToIDs(nrb, servletInfo.getErrors())) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            nrb.setMode("edit");
            servletInfo.setDestPage("/notRuleDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        nrb.fillMetaData();
        try {
            nrb.persist();
        }
        catch (RuleException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(re.getMessage());
            nrb.setMode("edit");
            servletInfo.setDestPage("/notRuleDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            nrb.setMode("edit");
            servletInfo.setDestPage("/notRuleDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/NotificationRules");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleSaveAs(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        NotRulesBean nrb = (NotRulesBean)servletInfo.getBean();
        this.saveRequestValues(nrb, request);
        if (!this.convertHostNamesToIDs(nrb, servletInfo.getErrors())) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            nrb.setMode("edit");
            servletInfo.setDestPage("/notRuleDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        nrb.setMode("saveas");
        servletInfo.setDestPage("/notRuleConfirm.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/NotificationRules");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) {
        NotRulesBean nrb = (NotRulesBean)servletInfo.getBean();
        nrb.setIsNew(false);
        nrb.setMode("edit");
        servletInfo.setDestPage("/notRuleDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        NotRulesBean nrb = (NotRulesBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String desc = request.getParameter(PARAM_DESC);
        nrb.createRule(name, desc);
        nrb.setIsNew(true);
        nrb.setMode("add");
        servletInfo.setDestPage("/notRuleDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        NotRulesBean nrb = (NotRulesBean)servletInfo.getBean();
        String id = NotRulesHandleAction.assertGetParam(request, "id");
        nrb.loadSingleRule(id);
        nrb.setMode("edit");
        servletInfo.setDestPage("/notRuleDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private boolean convertHostNamesToIDs(NotRulesBean nrb, ServletErrors errors) {
        String[] hosts = Util.arrayifyCommaSemiSeparated(nrb.getHostNames());
        HostID[] hostIDs = new HostID[hosts.length];
        boolean isAllValid = true;
        for (int i = 0; i < hosts.length; ++i) {
            try {
                hostIDs[i] = HostsBean.getSummaryHostByName(hosts[i]).getID();
                continue;
            }
            catch (RaplixException e) {
                isAllValid = false;
                Logger.debug("Couldn't convert hostName (" + hosts[i] + ")to ID", this);
                errors.addMinorErrorKey(MSG_ERROR_SAVE_INVALID_HOST, hosts[i]);
            }
        }
        nrb.setTmpHostIDs(hostIDs);
        return isAllValid;
    }

    private void saveRequestValues(NotRulesBean nrb, HttpServletRequest request) throws RaplixException {
        String name = request.getParameter("name");
        String desc = request.getParameter(PARAM_DESC);
        String eventType = request.getParameter(PARAM_EVENTTYPE);
        String eventPattern = request.getParameter(PARAM_EVENTPATTERN);
        String hostNames = request.getParameter(PARAM_HOSTNAMES);
        String hostSetID = request.getParameter(PARAM_HOSTSETID);
        String severity = request.getParameter(PARAM_SEVERITY);
        String severityComparison = request.getParameter(PARAM_SEVERITYCOMPARISON);
        String emailAddress = request.getParameter(PARAM_EMAILADDRESS);
        String typeOrSeverity = request.getParameter(PARAM_TYPE_OR_SEVERITY);
        nrb.setName(name);
        nrb.setDescription(desc);
        nrb.setEventType(eventType);
        nrb.setEventPattern(eventPattern);
        nrb.setHostNames(hostNames);
        nrb.setHostSetID(hostSetID);
        nrb.setHostSetNamefromID(hostSetID);
        nrb.setSeverity(severity);
        nrb.setSeverityComparison(severityComparison);
        nrb.setEmailAddress(emailAddress);
        nrb.setTypeOrSeverity(typeOrSeverity);
    }
}

