/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.rule.ActionID;
import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaID;
import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.MultiRuleQuery;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataManager;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.logger.Logger;
import java.util.Arrays;
import org.apache.struts.util.MessageResources;

public class NotRulesBean
extends ServletListBean {
    private String[] mNames = new String[0];
    private String[] mDescriptions = new String[0];
    private String[] mRuleIDs = new String[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    protected RuleMetaData mRuleMetaData = null;
    protected String mTypeOrSeverity = "";
    protected String mEventType = "";
    protected String mEventTypeLabel = "";
    protected String[] mEventTypeLabels = new String[0];
    protected String mEventPattern = "";
    protected String mHostNames = "";
    protected String[] mAllHostSetNames = new String[0];
    protected String[] mAllHostSetIDs = new String[0];
    protected String mHostSetID = "";
    protected String mHostSetName = "";
    protected HostID[] mTmpHostIDs = new HostID[0];
    protected String[] mAllSeverities = new String[0];
    protected String[] mSeverityLabels = new String[0];
    protected String mSeverity = "";
    protected String mSeverityLabel = "";
    protected String[] mAllSeverityComparisons = new String[0];
    protected String[] mSeverityComparisonLabels = new String[0];
    protected String mSeverityComparison = "";
    protected String mSeverityComparisonLabel = "";
    protected String mEmailAddress = "";
    protected String mMode = "";
    protected boolean mIsNew = false;
    protected String mName = "";
    protected String mDescription = "";
    protected String mRuleID = "";
    protected int mUpdateCount = 0;
    protected String mCriteriaID = "";
    protected String mActionID = "";
    private RuleMetaDataManager mRuleMetaDataMgr = null;
    protected MessageResources mMessages = null;
    private static final int numEventTypes = 10;
    private static final String[] eventTypeNames = new String[10];
    private static final String[][] eventTypeClasses = new String[10][];
    private static final int[] eventTaskTypes = new int[10];
    private static final int[] eventHostStatuses = new int[10];
    private boolean mHasWriteOnRules = true;

    public NotRulesBean(RuleMetaDataManager ruleMetaDataMgr) {
        this.mRuleMetaDataMgr = ruleMetaDataMgr;
        this.mMessages = ApplicationResources.getMessageResources();
        this.initializeMessageConstants();
        this.loadPermissionLookaheads();
    }

    public String[] getNames() {
        return this.mNames;
    }

    public String[] getDescriptions() {
        return this.mDescriptions;
    }

    public String[] getRuleIDs() {
        return this.mRuleIDs;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public void setTypeOrSeverity(String inValue) {
        this.mTypeOrSeverity = inValue;
    }

    public void setEventType(String inValue) {
        this.mEventType = inValue;
        this.mEventTypeLabel = this.mMessages.getMessage(inValue);
    }

    public void setEventTypeLabels(String[] inValue) {
        this.mEventTypeLabels = inValue;
    }

    public void setEventPattern(String inValue) {
        this.mEventPattern = inValue;
    }

    public void setHostNames(String inValue) {
        this.mHostNames = inValue;
    }

    public void setAllHostSetNames(String[] inValue) {
        this.mAllHostSetNames = inValue;
    }

    public void setAllHostSetIDs(String[] inValue) {
        this.mAllHostSetIDs = inValue;
    }

    public void setHostSetID(String inValue) {
        this.mHostSetID = inValue;
    }

    public void setHostSetName(String inValue) {
        this.mHostSetName = inValue;
    }

    public void setTmpHostIDs(HostID[] inValue) {
        this.mTmpHostIDs = inValue;
    }

    public void setAllSeverities(String[] inValue) {
        this.mAllSeverities = inValue;
    }

    public void setSeverityLabels(String[] inValue) {
        this.mSeverityLabels = inValue;
    }

    public void setSeverity(String inValue) {
        this.mSeverity = inValue;
        this.mSeverityLabel = this.mMessages.getMessage(inValue);
    }

    public void setAllSeverityComparisons(String[] inValue) {
        this.mAllSeverityComparisons = inValue;
    }

    public void setSeverityComparisonLabels(String[] inValue) {
        this.mSeverityComparisonLabels = inValue;
    }

    public void setSeverityComparison(String inValue) {
        this.mSeverityComparison = inValue;
        this.mSeverityComparisonLabel = this.mMessages.getMessage(inValue);
    }

    public void setEmailAddress(String inValue) {
        this.mEmailAddress = inValue;
    }

    public void setMode(String inValue) {
        this.mMode = inValue;
    }

    public void setIsNew(boolean inValue) {
        this.mIsNew = inValue;
    }

    public void setName(String inValue) {
        this.mName = inValue;
    }

    public void setDescription(String inValue) {
        this.mDescription = inValue;
    }

    public void setRuleID(String inValue) {
        this.mRuleID = inValue;
    }

    public String getTypeOrSeverity() {
        return this.mTypeOrSeverity;
    }

    public String getEventType() {
        return this.mEventType;
    }

    public String getEventTypeLabel() {
        return this.mEventTypeLabel;
    }

    public String[] getEventTypeNames() {
        return eventTypeNames;
    }

    public String[] getEventTypeLabels() {
        return this.mEventTypeLabels;
    }

    public String getEventPattern() {
        return this.mEventPattern;
    }

    public String getHostNames() {
        return this.mHostNames;
    }

    public String[] getAllHostSetNames() {
        return this.mAllHostSetNames;
    }

    public String[] getAllHostSetIDs() {
        return this.mAllHostSetIDs;
    }

    public String getHostSetID() {
        return this.mHostSetID;
    }

    public String getHostSetName() {
        return this.mHostSetName;
    }

    public HostID[] getTmpHostIDs() {
        return this.mTmpHostIDs;
    }

    public String[] getAllSeverities() {
        return this.mAllSeverities;
    }

    public String[] getSeverityLabels() {
        return this.mSeverityLabels;
    }

    public String getSeverity() {
        return this.mSeverity;
    }

    public String getSeverityLabel() {
        return this.mSeverityLabel;
    }

    public String[] getAllSeverityComparisons() {
        return this.mAllSeverityComparisons;
    }

    public String[] getSeverityComparisonLabels() {
        return this.mSeverityComparisonLabels;
    }

    public String getSeverityComparison() {
        return this.mSeverityComparison;
    }

    public String getSeverityComparisonLabel() {
        return this.mSeverityComparisonLabel;
    }

    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getRuleID() {
        return this.mRuleID;
    }

    public String getID() {
        if (!this.mRuleID.equals("")) {
            return this.mRuleID;
        }
        return super.getID();
    }

    public String getRuleID(int index) {
        String ruleID = "";
        if (index < this.mRuleIDs.length) {
            ruleID = this.mRuleIDs[index];
        }
        return ruleID;
    }

    public boolean getHasWriteOnRules() {
        return this.mHasWriteOnRules;
    }

    public RuleMetaDataManager getRuleMetaDataManager() {
        return this.mRuleMetaDataMgr;
    }

    public void generateList() throws RaplixException {
        MultiRuleQuery mrq = MultiRuleQuery.all();
        this.prepQuery(mrq, null);
        this.generateOutputArrays(mrq.select());
    }

    public void generateOutputArrays(RuleMetaData[] rules) throws RaplixException {
        int numRules = rules.length;
        this.mNames = new String[numRules];
        this.mDescriptions = new String[numRules];
        this.mRuleIDs = new String[numRules];
        for (int i = 0; i < numRules; ++i) {
            RuleMetaData rule = rules[i];
            this.mNames[i] = rule.getName();
            this.mDescriptions[i] = rule.getDescription();
            this.mRuleIDs[i] = rule.getRuleID().toString();
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mRuleIDs);
    }

    public void createRule(String name, String desc) throws RaplixException {
        this.mName = name;
        this.mDescription = desc;
        this.mRuleID = "";
        this.mIsNew = true;
        this.mAcceptInput = true;
        this.mTypeOrSeverity = "type";
        this.mEventType = "label.notrules.notRuleAny";
        this.mEventPattern = "";
        this.mHostNames = "";
        this.mHostSetID = "---";
        this.loadAllHostSets();
        this.mSeverity = "label.notrules.info";
        this.mSeverityComparison = "label.notrules.only";
        this.mEmailAddress = "";
    }

    public void loadSingleRule(String inRuleID) throws RaplixException {
        ActionMetaData[] actions;
        this.mRuleMetaData = this.mRuleMetaDataMgr.retrieveRule(new RuleID(inRuleID));
        this.mIsNew = false;
        this.mAcceptInput = true;
        this.mName = this.mRuleMetaData.getName();
        this.mRuleID = this.mRuleMetaData.getRuleID().toString();
        this.mDescription = this.mRuleMetaData.getDescription();
        this.mUpdateCount = this.mRuleMetaData.getUpdateCount();
        CriteriaMetaData[] criteria = this.mRuleMetaData.getCriteria();
        if (criteria.length > 0) {
            this.loadCriteriaFields(criteria[0]);
        }
        if ((actions = this.mRuleMetaData.getActions()).length > 0) {
            this.loadActionFields(actions[0]);
        }
    }

    public void setHostSetNamefromID(String hostSetID) throws RaplixException {
        if (hostSetID.equals("---")) {
            this.mHostSetName = "";
            return;
        }
        this.mHostSetName = HostSetsBean.getSummaryHostSetByID(hostSetID).getName();
    }

    public void fillMetaData() {
        this.mRuleMetaData = new RuleMetaData();
        ActionMetaData action = new ActionMetaData();
        CriteriaMetaData criteria = new CriteriaMetaData();
        this.mRuleMetaData.setName(this.mName);
        this.mRuleMetaData.setDescription(this.mDescription);
        this.mRuleMetaData.setIsActive(true);
        if (!this.mIsNew) {
            this.mRuleMetaData.setRuleID(new RuleID(this.mRuleID));
            this.mRuleMetaData.setUpdateCount(this.mUpdateCount);
            criteria.setCriteriaID(new CriteriaID(this.mCriteriaID));
            action.setActionID(new ActionID(this.mActionID));
        }
        if (this.mTypeOrSeverity.equals("type")) {
            criteria.setEventTypes(this.eventNameToClass(this.mEventType));
            criteria.setTaskEventType(this.eventNameToTaskType(this.mEventType));
            criteria.setHostStatus(this.eventNameToHostStatus(this.mEventType));
            criteria.setSeverities(new int[0]);
        } else {
            criteria.setEventTypes(this.eventNameToClass("label.notrules.notRuleAny"));
            criteria.setTaskEventType(this.eventNameToTaskType("label.notrules.notRuleAny"));
            criteria.setHostStatus(this.eventNameToHostStatus("label.notrules.notRuleAny"));
            criteria.setSeverities(this.createSeverityArray());
        }
        criteria.setMessagePattern(this.mEventPattern);
        criteria.setHosts(this.mTmpHostIDs);
        if (!this.mHostSetID.equals("---")) {
            criteria.setHostSet(new HostSetID(this.mHostSetID));
        }
        this.mRuleMetaData.setCriteria(new CriteriaMetaData[]{criteria});
        action.setActionType("EMAIL");
        action.setEmailAddress(this.mEmailAddress);
        this.mRuleMetaData.setActions(new ActionMetaData[]{action});
    }

    public void persist() throws RaplixException {
        if (this.mIsNew) {
            this.mRuleID = this.mRuleMetaDataMgr.saveRule(this.mRuleMetaData).toString();
        } else {
            this.mRuleMetaDataMgr.saveRule(this.mRuleMetaData);
        }
    }

    private int[] createSeverityArray() {
        int[] newArray = new int[]{};
        if (this.mSeverity.equals("label.notrules.info") && this.mSeverityComparison.equals("label.notrules.only")) {
            newArray = new int[]{2};
        } else if (this.mSeverity.equals("label.notrules.info") && this.mSeverityComparison.equals("label.notrules.orWorse")) {
            newArray = new int[]{2, 3, 4};
        } else if (this.mSeverity.equals("label.notrules.warning") && this.mSeverityComparison.equals("label.notrules.only")) {
            newArray = new int[]{3};
        } else if (this.mSeverity.equals("label.notrules.warning") && this.mSeverityComparison.equals("label.notrules.orWorse")) {
            newArray = new int[]{3, 4};
        } else if (this.mSeverity.equals("label.notrules.error") && this.mSeverityComparison.equals("label.notrules.only")) {
            newArray = new int[]{4};
        } else if (this.mSeverity.equals("label.notrules.error") && this.mSeverityComparison.equals("label.notrules.orWorse")) {
            newArray = new int[]{4};
        }
        return newArray;
    }

    private void loadActionFields(ActionMetaData action) {
        this.mActionID = action.getActionID().toString();
        this.mEmailAddress = action.getEmailAddress();
    }

    private void loadCriteriaFields(CriteriaMetaData criteria) throws RaplixException {
        this.mEventType = this.classToEventName(criteria.getEventTypes(), criteria.getTaskEventType(), criteria.getHostStatus());
        this.mEventTypeLabel = this.mMessages.getMessage(this.mEventType);
        this.mCriteriaID = criteria.getCriteriaID().toString();
        this.mEventPattern = criteria.getMessagePattern();
        int[] severities = criteria.getSeverities();
        this.severityArrayToParams(severities);
        this.mTypeOrSeverity = severities.length == 0 ? "type" : "severity";
        this.mHostNames = this.hostIDsToString(criteria.getHosts());
        if (criteria.getHostSet() == null) {
            this.mHostSetID = "---";
            this.mHostSetName = "---";
        } else {
            this.mHostSetID = criteria.getHostSet().toString();
            this.mHostSetName = HostSetsBean.getSummaryHostSetByID(criteria.getHostSet()).getName();
        }
        this.loadAllHostSets();
    }

    private void loadAllHostSets() throws RaplixException {
        HostSetsListBean setsList = new HostSetsListBean();
        if (this.mHostSetID.equals("---")) {
            setsList.loadAllHostSets();
        } else {
            setsList.loadAllHostSetsPlusExtras(new String[]{this.mHostSetID});
        }
        this.mAllHostSetNames = setsList.getNames();
        this.mAllHostSetIDs = setsList.getIDs();
    }

    private String hostIDsToString(HostID[] hosts) throws RaplixException {
        String allHosts = "";
        int i = 0;
        for (i = 0; i < hosts.length; ++i) {
            allHosts = allHosts + HostsBean.getSummaryHostByID(hosts[i]).getName();
            if (i >= hosts.length - 1) continue;
            allHosts = allHosts + " ";
        }
        return allHosts;
    }

    private void severityArrayToParams(int[] severityArray) {
        if (severityArray.length == 0) {
            this.mSeverity = "label.notrules.info";
            this.mSeverityComparison = "label.notrules.orWorse";
            this.mSeverityLabel = this.mMessages.getMessage(this.mSeverity);
            this.mSeverityComparisonLabel = this.mMessages.getMessage(this.mSeverityComparison);
            return;
        }
        Arrays.sort(severityArray);
        if (severityArray[0] == 2) {
            this.mSeverity = "label.notrules.info";
        } else if (severityArray[0] == 3) {
            this.mSeverity = "label.notrules.warning";
        } else if (severityArray[0] == 4) {
            this.mSeverity = "label.notrules.error";
        } else {
            this.mSeverity = "Unknown severity setting";
            this.mSeverityComparison = "Unknown severity setting";
            Logger.debug("Couldn't convert severityArray(" + severityArray + ") to severity Parameters in NotRulesBean", this);
            return;
        }
        this.mSeverityComparison = severityArray.length > 1 ? "label.notrules.orWorse" : "label.notrules.only";
        this.mSeverityLabel = this.mMessages.getMessage(this.mSeverity);
        this.mSeverityComparisonLabel = this.mMessages.getMessage(this.mSeverityComparison);
    }

    private void initializeMessageConstants() {
        NotRulesBean.eventTypeNames[0] = "label.notrules.notRuleAny";
        NotRulesBean.eventTypeNames[1] = "label.notrules.planStarts";
        NotRulesBean.eventTypeNames[2] = "label.notrules.planFails";
        NotRulesBean.eventTypeNames[3] = "label.notrules.planSucceeds";
        NotRulesBean.eventTypeNames[4] = "label.notrules.diffStarts";
        NotRulesBean.eventTypeNames[5] = "label.notrules.diffFails";
        NotRulesBean.eventTypeNames[6] = "label.notrules.diffSucceeds";
        NotRulesBean.eventTypeNames[7] = "label.notrules.notRuleSystem";
        NotRulesBean.eventTypeNames[8] = "label.notrules.notRuleAdmin";
        NotRulesBean.eventTypeNames[9] = "label.notrules.notRuleCustom";
        NotRulesBean.eventTypeClasses[0] = new String[0];
        NotRulesBean.eventTypeClasses[1] = new String[]{"com.raplix.rolloutexpress.event.ROXTaskStartEvent"};
        NotRulesBean.eventTypeClasses[2] = new String[]{"com.raplix.rolloutexpress.event.ROXTaskFailedEvent"};
        NotRulesBean.eventTypeClasses[3] = new String[]{"com.raplix.rolloutexpress.event.ROXTaskCompleteEvent"};
        NotRulesBean.eventTypeClasses[4] = new String[]{"com.raplix.rolloutexpress.event.ROXDifferenceStartEvent"};
        NotRulesBean.eventTypeClasses[5] = new String[]{"com.raplix.rolloutexpress.event.ROXDifferenceCompleteEvent", "com.raplix.rolloutexpress.event.ROXDifferenceAbortEvent"};
        NotRulesBean.eventTypeClasses[6] = new String[]{"com.raplix.rolloutexpress.event.ROXDifferenceCompleteEvent"};
        NotRulesBean.eventTypeClasses[7] = new String[]{"com.raplix.rolloutexpress.event.ROXNodeStartEvent", "com.raplix.rolloutexpress.event.ROXNodeStopEvent", "com.raplix.rolloutexpress.event.ROXErrorEvent", "com.raplix.rolloutexpress.event.ROXWarningEvent"};
        NotRulesBean.eventTypeClasses[8] = new String[]{"com.raplix.rolloutexpress.event.ROXUserLoginEvent", "com.raplix.rolloutexpress.event.ROXUserLoginFailedEvent", "com.raplix.rolloutexpress.event.ROXUserLogoutEvent"};
        NotRulesBean.eventTypeClasses[9] = new String[]{"com.raplix.rolloutexpress.event.ROXStepCustomStepEvent"};
        NotRulesBean.eventTaskTypes[0] = 0;
        NotRulesBean.eventTaskTypes[1] = 2;
        NotRulesBean.eventTaskTypes[2] = 2;
        NotRulesBean.eventTaskTypes[3] = 2;
        NotRulesBean.eventTaskTypes[4] = 0;
        NotRulesBean.eventTaskTypes[5] = 0;
        NotRulesBean.eventTaskTypes[6] = 0;
        NotRulesBean.eventTaskTypes[7] = 0;
        NotRulesBean.eventTaskTypes[8] = 0;
        NotRulesBean.eventTaskTypes[9] = 0;
        NotRulesBean.eventHostStatuses[0] = 0;
        NotRulesBean.eventHostStatuses[1] = 0;
        NotRulesBean.eventHostStatuses[2] = 2;
        NotRulesBean.eventHostStatuses[3] = 1;
        NotRulesBean.eventHostStatuses[4] = 0;
        NotRulesBean.eventHostStatuses[5] = 2;
        NotRulesBean.eventHostStatuses[6] = 1;
        NotRulesBean.eventHostStatuses[7] = 0;
        NotRulesBean.eventHostStatuses[8] = 0;
        NotRulesBean.eventHostStatuses[9] = 0;
        this.mAllSeverities = new String[3];
        this.mAllSeverities[0] = "label.notrules.info";
        this.mAllSeverities[1] = "label.notrules.warning";
        this.mAllSeverities[2] = "label.notrules.error";
        this.mAllSeverityComparisons = new String[2];
        this.mAllSeverityComparisons[0] = "label.notrules.only";
        this.mAllSeverityComparisons[1] = "label.notrules.orWorse";
        this.mSeverityLabels = new String[3];
        this.mSeverityLabels[0] = this.mMessages.getMessage(this.mAllSeverities[0]);
        this.mSeverityLabels[1] = this.mMessages.getMessage(this.mAllSeverities[1]);
        this.mSeverityLabels[2] = this.mMessages.getMessage(this.mAllSeverities[2]);
        this.mSeverityComparisonLabels = new String[2];
        this.mSeverityComparisonLabels[0] = this.mMessages.getMessage(this.mAllSeverityComparisons[0]);
        this.mSeverityComparisonLabels[1] = this.mMessages.getMessage(this.mAllSeverityComparisons[1]);
        this.mEventTypeLabels = new String[10];
        for (int i = 0; i < 10; ++i) {
            this.mEventTypeLabels[i] = this.mMessages.getMessage(eventTypeNames[i]);
        }
    }

    private String classToEventName(String[] className, int eventTaskType, int eventHostStatus) {
        for (int i = 0; i < 10; ++i) {
            if (!Arrays.equals(className, eventTypeClasses[i]) || eventTaskType != eventTaskTypes[i] || eventHostStatus != eventHostStatuses[i]) continue;
            return eventTypeNames[i];
        }
        Logger.debug("Couldn't convert class(" + className + ") to eventName in NotRulesBean", this);
        return "Unknown class type";
    }

    private String[] eventNameToClass(String eventName) {
        for (int i = 0; i < 10; ++i) {
            if (!eventName.equals(eventTypeNames[i])) continue;
            return eventTypeClasses[i];
        }
        Logger.debug("Couldn't convert event name(" + eventName + ") to class in NotRulesBean", this);
        return new String[0];
    }

    private int eventNameToTaskType(String eventName) {
        for (int i = 0; i < 10; ++i) {
            if (!eventName.equals(eventTypeNames[i])) continue;
            return eventTaskTypes[i];
        }
        Logger.debug("Couldn't convert event name(" + eventName + ") to task type in NotRulesBean", this);
        return 0;
    }

    private int eventNameToHostStatus(String eventName) {
        for (int i = 0; i < 10; ++i) {
            if (!eventName.equals(eventTypeNames[i])) continue;
            return eventHostStatuses[i];
        }
        Logger.debug("Couldn't convert event name(" + eventName + ") to host status in NotRulesBean", this);
        return 0;
    }

    private void loadPermissionLookaheads() {
        this.mHasWriteOnRules = PermissionChecker.hasWriteOnRules();
    }
}

