/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataManager;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.ui.web.DeleteConfirmNode;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class NotRuleDeleteNode
extends UITreeNode {
    private static final int DELETE_CONFIRM_COLSPAN = 2;
    private RuleID mRuleID = null;
    private String mName = "";
    private String mDescription = "";
    private boolean mIsUndeletable = false;
    private int mRowLevel = 0;
    private String mPrologue = "";
    private String mContents = "";

    public NotRuleDeleteNode(DeleteSessionCandidate candidate, RuleMetaDataManager ruleManager) throws RaplixException {
        this.mType = UITreeNodeType.LEAF;
        DeleteSessionCandidateStatus status = candidate.getStatus();
        this.mIsUndeletable = status.equals(DeleteSessionCandidateStatus.IN_USE) || status.equals(DeleteSessionCandidateStatus.NOT_DELETABLE);
        RuleID ruleID = (RuleID)candidate.getParent().getObjectID();
        RuleMetaData rule = ruleManager.retrieveRule(ruleID);
        this.mRuleID = ruleID;
        this.mName = rule.getName();
        this.mDescription = rule.getDescription();
        this.preRender();
    }

    public void getDescendents(DeleteSessionCandidate candidate) {
        if (this.mIsUndeletable) {
            PersistenceManagerException pme = (PersistenceManagerException)candidate.getException();
            String errMsg = pme.getMessage();
            DeleteConfirmNode confirmNode = new DeleteConfirmNode(errMsg, 2, 2);
            this.addChild(confirmNode);
            if (pme instanceof ObjectInUseException) {
                UsingObject[] blockers = ((ObjectInUseException)pme).getUsingObjects();
                for (int j = 0; j < blockers.length; ++j) {
                    DeleteConfirmNode blockerNode = new DeleteConfirmNode(blockers[j], 2, 2);
                    confirmNode.addChild(blockerNode);
                }
            }
        }
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String editURI = UriUtil.ruleDetailsURI(this.mRuleID.toString());
        String toolTip = "Show notification rule details";
        String nameLink = Util.standardLink(editURI, toolTip, this.mName, "name=\"nameLink-" + this.mRuleID + "\"");
        String descLink = Util.standardLink(editURI, toolTip, Util.escapeHTML(this.mDescription));
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }

    public void addChild(UITreeNode node) {
        this.mChildren.add(node);
        node.setTree(this.mTree);
        this.mType = UITreeNodeType.BRANCH_CLOSED;
    }

    public String finishRender(StringBuffer sb, String path) {
        String rowspanStr = "rowspan=\"" + this.getVisibleChildCount() + "\"";
        this.mPrologue = "<tr>\n" + Util.introStandardCell(rowspanStr, this.mRowLevel) + Util.standardCellStart(0, "nowrap", this.mRowLevel);
        return this.mPrologue + sb + this.mContents;
    }

    public void finishOpen() {
    }

    public void finishClose() {
    }

    protected String getJavascriptFunction() {
        return "sendTree";
    }
}

