/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.NewFolderBean;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class NewFolderAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_INIT = "error.newFolder.init";
    private static final String MSG_ERROR_CREATE = "error.newFolder.create";
    private static final String MSG_ERROR_SELECTED_FOLDER_NOT_WRITABLE = "error.newFolder.foldPerm";
    private static final String MSG_ERROR_SELECTED_FOLDER_FROM_PLUGIN = "error.newFolder.fromPlugin";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = NewFolderAction.assertGetParam(request, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through NewFolderAction:" + mode, this);
        }
        if (mode.equals("init")) {
            this.handleInit(request, servletInfo);
        } else if (mode.equals("create")) {
            this.handleCreate(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
    }

    private void handleCreate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        NewFolderBean nfb = (NewFolderBean)servletInfo.getBean();
        String newFolder = NewFolderAction.assertGetParam(request, "newFolder");
        String newFolderText = NewFolderAction.assertGetParam(request, "selectedFolder");
        nfb.setSelectedFolder(newFolderText);
        nfb.setNewFolder(newFolder);
        SingleFolderQuery sfq = SingleFolderQuery.byPath(newFolderText);
        FolderID fid = sfq.select().getID();
        try {
            FolderID newFolderID = fid.create(newFolder);
            nfb.setRequestingWindowClose(true);
            ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
            spb.setString(Preference.FILE_PATH, newFolderID.toString());
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_CREATE);
            servletInfo.getErrors().addMinorError(re);
            nfb.setRequestingWindowClose(false);
        }
        servletInfo.setDestPage("/newFolder.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(true);
    }

    private void handleInit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        NewFolderBean nfb = (NewFolderBean)servletInfo.getBean();
        String newFolderText = NewFolderAction.assertGetParam(request, "selectedFolder");
        Folder parentFolder = this.findClosestParent(newFolderText);
        FolderID fid = parentFolder.getID();
        if (!PermissionChecker.hasWriteOnFolder(fid)) {
            HttpSession session = request.getSession();
            String loggedInUser = (String)session.getAttribute("session.loggedinuser");
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_INIT);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_SELECTED_FOLDER_NOT_WRITABLE, (Object)Util.preserveSpace(loggedInUser), Util.preserveSpace(newFolderText));
            nfb.setBadSelectedFolder(true);
        } else if (parentFolder.getPluginID() != null) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_INIT);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_SELECTED_FOLDER_FROM_PLUGIN, Util.preserveSpace(newFolderText));
            nfb.setBadSelectedFolder(true);
        }
        nfb.setSelectedFolder(parentFolder.getFullPathString());
        servletInfo.setDestPage("/newFolder.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(true);
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = NewFolderAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("NewFolderAction::getMajorError with mode: " + mode, this);
        }
        if (mode.equals("init")) {
            return MSG_ERROR_INIT;
        }
        if (mode.equals("create")) {
            return MSG_ERROR_CREATE;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to NewFolderAction.");
    }

    public String getDefaultPage() {
        return "/newFolder.jsp";
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new NewFolderBean();
    }

    protected boolean isPopup(HttpServletRequest request) {
        return true;
    }

    private Folder findClosestParent(String fromChild) throws RaplixException {
        SingleFolderQuery sfq = SingleFolderQuery.byPath(fromChild);
        while (!sfq.selectExists()) {
            int slashPos = fromChild.lastIndexOf(47);
            fromChild = slashPos == -1 ? "/" : fromChild.substring(0, slashPos);
            sfq = SingleFolderQuery.byPath(fromChild);
        }
        return sfq.select();
    }
}

