/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.util.string.StringUtil;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class MultiCheckbox
extends ServletBean {
    public static final String SIZE_SUFFIX = "_size";
    private String mName = null;
    private String[] mValues = null;
    private boolean[] mCheckeds = null;
    private int mSize = 0;

    public MultiCheckbox(String name, HttpServletRequest request) {
        String sizeString = request.getParameter(name + SIZE_SUFFIX);
        this.mName = name;
        this.mSize = sizeString == null ? 0 : Integer.parseInt(sizeString);
        this.mValues = new String[this.mSize];
        this.mCheckeds = new boolean[this.mSize];
        for (int i = 0; i < this.mSize; ++i) {
            String s;
            this.mValues[i] = s = request.getParameter(name + i);
            this.mCheckeds[i] = s != null;
        }
    }

    public MultiCheckbox(String name, String[] values) {
        this.mName = name;
        this.mSize = values.length;
        this.mValues = values;
        this.mCheckeds = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.mCheckeds[i] = false;
        }
    }

    public String getName() {
        return this.mName;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getValue(int i) {
        if (i < 0 || i > this.mValues.length) {
            return "";
        }
        return this.mValues[i];
    }

    public boolean getChecked(int i) {
        if (i < 0 || i > this.mCheckeds.length) {
            return false;
        }
        return this.mCheckeds[i];
    }

    public String[] getValues() {
        return this.mValues;
    }

    public String[] getSelected() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.mCheckeds.length; ++i) {
            if (!this.mCheckeds[i]) continue;
            v.add(this.mValues[i]);
        }
        return v.toArray(new String[0]);
    }

    public void setSelected(MultiCheckbox mc) {
        this.mCheckeds = new boolean[this.mCheckeds.length];
        String[] values = mc.mValues;
        for (int i = 0; i < values.length; ++i) {
            if (!mc.getChecked(i)) continue;
            for (int j = 0; j < this.mValues.length; ++j) {
                if (!this.mValues[j].equals(values[i])) continue;
                this.mCheckeds[j] = true;
            }
        }
    }

    public void setSelected(String s) {
        if (s == null) {
            return;
        }
        this.mCheckeds = new boolean[this.mCheckeds.length];
        String[] subscripts = StringUtil.split(s, ",", "");
        for (int i = 0; i < subscripts.length; ++i) {
            int sub = Integer.parseInt(subscripts[i]);
            if (sub < 0 && sub >= this.mCheckeds.length) continue;
            this.mCheckeds[sub] = true;
        }
    }

    public void setSelected(boolean[] selected) {
        this.mCheckeds = selected;
    }

    public void setSelectedAll() {
        this.mCheckeds = new boolean[this.mCheckeds.length];
        for (int i = 0; i < this.mCheckeds.length; ++i) {
            this.mCheckeds[i] = true;
        }
    }
}

