/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class LogoutAction
extends LoggedOnServlet {
    public static final String MSG_ERROR = "error.logout";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletErrors errors = new ServletErrors();
        try {
            Logger.debug("at beginning of execute servlet for LogoutAction", this);
            HttpSession session = request.getSession();
            session.invalidate();
            SessionManager sessionManager = LogoutAction.getApplication().getUserSessionManager();
            Logger.debug("xxx - retrieved session manager:" + sessionManager + ", now logging in", this);
            sessionManager.logout();
            response.sendRedirect("/Login");
        }
        catch (RaplixException e) {
            Logger.debug("Exception caught in Logout: " + e.getMessage(), e, this);
            errors.setMajorErrorKey(MSG_ERROR);
            errors.addMinorError(e.getMessage());
            request.setAttribute("error.location", (Object)errors);
            response.sendRedirect("/CustomPage?name=commonTasks.html&title=common%20tasks");
        }
    }
}

