/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.ServerWebUIApplication;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDecryptionException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.ui.web.ROXServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class LoginAction
extends ROXServlet {
    public static final String MSG_ERROR_MAJOR = "error.login.major";
    public static final String MSG_ERROR_FAILED = "error.login.failed";
    public static final String MSG_ERROR_SESSION_TIMEOUT = "error.login.sessionTimeout";
    public static final String MSG_ERROR_NOT_LOGGEDIN = "error.login.noLoggedIn";
    public static final String MSG_ERROR_UNKNOWN = "error.login.unknown";
    public static final String MSG_SESSION_ERROR_MAJOR = "error.loginDecrypt.major";

    /*
     * Unable to fully structure code
     */
    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        errors = new ServletErrors();
        try {
            Logger.debug("at beginning of execute servlet for LoginAction", this);
            session = request.getSession();
            errorflag = request.getParameter("errorflag");
            if (errorflag != null) {
                if (errorflag.equals("sessiontimedout")) {
                    errors.addMinorErrorKey("error.login.sessionTimeout");
                    errors.setMajorErrorKey("error.login.major");
                    request.setAttribute("error.location", (Object)errors);
                } else if (!errorflag.equals("notloggedin")) {
                    errors.addMinorErrorKey("error.login.unknown");
                    errors.setMajorErrorKey("error.login.major");
                    request.setAttribute("error.location", (Object)errors);
                }
            }
            login = request.getParameter("login");
            Logger.debug("user submitted login request with login:" + login, this);
            if (login == null) {
                Logger.debug("login is null, forwarding to:/login.jsp", this);
                this.forwardRequest(request, response, "/login.jsp");
                return;
            }
            sessionManager = LoginAction.getApplication().getUserSessionManager();
            sessionMode = request.getParameter("mode");
            password = null;
            if (sessionMode != null && (sessionMode.equals("flush") || sessionMode.equals("reencrypt"))) {
                try {
                    if (sessionMode.equals("flush")) {
                        password = request.getParameter("currentpassword2");
                        sessionManager.recryptSessionVariables(true, login, password, null);
                    }
                    if (!sessionMode.equals("reencrypt")) ** GOTO lbl45
                    oldPassword = request.getParameter("oldpassword");
                    password = request.getParameter("currentpassword1");
                    sessionManager.recryptSessionVariables(false, login, password, oldPassword);
                }
                catch (UserDBException udbe) {
                    errors.setMajorErrorKey("error.loginDecrypt.major");
                    errors.addMinorError(udbe.getMessage());
                    request.setAttribute("error.location", (Object)errors);
                    request.setAttribute("request.beanid", (Object)login);
                    request.setAttribute("request.mode", (Object)sessionMode);
                    this.forwardRequest(request, response, "/loginDecrypt.jsp");
                    return;
                }
            } else {
                password = request.getParameter("currentpassword1");
            }
lbl45:
            // 4 sources

            try {
                sessionID = sessionManager.login(login, password);
                tmpUIContextServices = LoginAction.getApplication().getUIContextServices();
                tmpUIContextServices.setSessionID(sessionID);
            }
            catch (SessionVarDecryptionException s) {
                errors.setMajorError(s.getMessage());
                request.setAttribute("error.location", (Object)errors);
                request.setAttribute("request.beanid", (Object)login);
                request.setAttribute("request.mode", (Object)"flush");
                this.forwardRequest(request, response, "/loginDecrypt.jsp");
                return;
            }
            catch (UserDBException e) {
                Logger.debug("Login failed, login and password not authenticated", this);
                errors.setMajorErrorKey("error.login.major");
                errors.addMinorError(e.getMessage());
                request.setAttribute("error.location", (Object)errors);
                this.forwardRequest(request, response, "/login.jsp");
                return;
            }
            Logger.debug("successfully logged in and got a session id of:" + sessionID, this);
            svs = sessionManager.getSessionVariables();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Pre-purge svs: " + svs.toString(), this);
            }
            svs = svs.purgeNonDescriptorVars();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Post-purge svs: " + svs.toString(), this);
            }
            sessionManager.setSessionVariables(svs);
            session.setAttribute("session.user", (Object)sessionID);
            session.setAttribute("session.loggedinuser", (Object)login);
            session.setMaxInactiveInterval(1100 * this.getROXSessionTimeout());
            destination = "/CustomPage?name=commonTasks.html&title=common%20tasks";
            Logger.debug("Forwarding to " + destination, this);
            response.sendRedirect(destination);
            return;
        }
        catch (RaplixException e) {
            Logger.debug("Exception caught in Login: " + e.getMessage(), e, this);
            errors.setMajorErrorKey("error.login.major");
            errors.addMinorError(e.getMessage());
            request.setAttribute("error.location", (Object)errors);
            this.forwardRequest(request, response, "/login.jsp");
            return;
        }
    }

    private int getROXSessionTimeout() throws RaplixException {
        try {
            ServerWebUIApplication app = (ServerWebUIApplication)LoginAction.getApplication();
            UserDBSubsystem userDB = app.getUserDBSubsystem();
            return userDB.getConfigSessionTimeout();
        }
        catch (ClassCastException cce) {
            return 36000000;
        }
    }
}

