/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.net.rpc.InvalidContext;
import com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.ui.UIContextServices;
import com.raplix.rolloutexpress.ui.web.ROXServlet;
import com.raplix.util.logger.Logger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class LoggedOnServlet
extends ROXServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SessionID user = this.getCurrentUser(request);
        if (user == null) {
            this.handleLoginInvalidError(request, response, "notloggedin");
            return;
        }
        UIContextServices tmpUIContextServices = LoggedOnServlet.getApplication().getUIContextServices();
        try {
            tmpUIContextServices.setSessionID(user);
        }
        catch (InvalidContext icException) {
            this.handleLoginInvalidError(request, response, "sessiontimedout");
            return;
        }
        try {
            String userAgent = request.getHeader("User-Agent").toLowerCase();
            boolean ie = false;
            boolean ns6 = false;
            boolean ns4 = false;
            if (userAgent.indexOf("msie") != -1) {
                ie = true;
            } else if (userAgent.indexOf("netscape6") != -1) {
                ns6 = true;
            } else if (userAgent.indexOf("mozilla") != -1) {
                ns4 = true;
            }
            if (!ns4 || !"POST".equals(request.getMethod())) {
                response.setHeader("Expires", "0");
            }
            final HttpServletRequest theRequest = request;
            final HttpServletResponse theResponse = response;
            if (LoggedOnServlet.isMonolithicApp()) {
                this.doPrivilegedAction(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        LoggedOnServlet.this.executeServlet(theRequest, theResponse);
                        return null;
                    }
                });
            } else {
                this.executeServlet(request, response);
            }
        }
        finally {
            tmpUIContextServices.setSessionID(null);
        }
    }

    private Object doPrivilegedAction(PrivilegedExceptionAction action) throws Exception {
        Server theServer = (Server)((Object)LoggedOnServlet.getApplication());
        AccessControlManager theControl = theServer.getUserDBSubsystem().getAccessControlManager();
        AccessControlContext ctx = theControl.getCurrentUserAccessControlContext();
        try {
            return AccessController.doPrivileged(action, ctx);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    protected String getPagePath(HttpServletRequest request) {
        return request.getRequestURI();
    }

    protected String getNotLoggedOnRedirect() {
        return "Login";
    }

    protected SessionID getCurrentUser(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (SessionID)session.getAttribute("session.user");
    }

    private void handleLoginInvalidError(HttpServletRequest request, HttpServletResponse response, String errorkey) throws Exception {
        String uri = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null) {
            uri = uri + "?" + query;
        }
        Logger.info(uri, this);
        request.getSession().setAttribute("session.login.destination", (Object)uri);
        String redirectURI = (this.isPopup(request) ? "/loginpopup.jsp" : "/Login") + "?" + "errorflag" + "=" + errorkey;
        response.sendRedirect(redirectURI);
    }
}

