/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ui.web.FileInfo;
import com.raplix.rolloutexpress.ui.web.HttpMultiPartParser;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import com.raplix.util.iowrappers.ReaderWrapper;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpMultipartRequestWrapper {
    public static final String MSG_ERROR_UNSUPPORTED_ENCODING_MAJOR = "error.HttpMultipartRequestWrapper.UnsupportedEncoding.major";
    public static final String cacheKey = "__MULTIPART_WRAPPER__";
    private Hashtable mParameters = null;
    private HttpServletRequest mParentRequest;
    private boolean mIsMultipart;
    private static final String BOUNDARY_SPECIFIER = "boundary=";

    public static HttpMultipartRequestWrapper wrapRequest(HttpServletRequest originalRequest) throws IllegalStateException, IOException {
        Object cachedWrapper = originalRequest.getAttribute(cacheKey);
        if (cachedWrapper != null && cachedWrapper instanceof HttpMultipartRequestWrapper) {
            return (HttpMultipartRequestWrapper)cachedWrapper;
        }
        HttpMultipartRequestWrapper wrappedRequest = new HttpMultipartRequestWrapper(originalRequest);
        originalRequest.setAttribute(cacheKey, (Object)wrappedRequest);
        return wrappedRequest;
    }

    private HttpMultipartRequestWrapper(HttpServletRequest request) throws IOException, IllegalStateException {
        this.mParentRequest = request;
        if (this.mParentRequest == null) {
            throw new IllegalArgumentException("Request is null");
        }
        String contentType = this.mParentRequest.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            this.mIsMultipart = true;
            int index = contentType.indexOf(BOUNDARY_SPECIFIER);
            if (index == -1) {
                throw new IllegalStateException("No boundary string specified in content type.");
            }
            String boundary = contentType.substring(index + BOUNDARY_SPECIFIER.length()).trim();
            HttpMultiPartParser hmpp = new HttpMultiPartParser();
            this.mParameters = hmpp.parseData(request.getInputStream(), boundary, Application.getApp().getTmpDirAbsPath(), request.getCharacterEncoding());
        } else {
            this.mIsMultipart = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String name) {
        if (this.mIsMultipart) {
            Object o = this.mParameters.get(name);
            String val = "";
            if (o != null && o instanceof FileInfo) {
                FileInfo fi = (FileInfo)o;
                Closer c = new Closer();
                try {
                    FileInputStream fis = new FileInputStream(fi.getLocalFile());
                    InputStreamWrapper isw = new InputStreamWrapper(fis);
                    c.register(isw);
                    UnicodeInputStreamReader uisr = new UnicodeInputStreamReader(fis, this.mParentRequest.getCharacterEncoding());
                    ReaderWrapper rw = new ReaderWrapper(uisr);
                    c.register(rw);
                    val = new String(CopyUtil.readText(uisr));
                }
                catch (IOException ioe) {
                    val = MSG_ERROR_UNSUPPORTED_ENCODING_MAJOR;
                }
                finally {
                    c.closeAll();
                }
            } else {
                val = o != null ? o.toString() : null;
            }
            return val;
        }
        return this.mParentRequest.getParameter(name);
    }

    public File getParameterLocalFile(String name) {
        Object o;
        if (this.mIsMultipart && (o = this.mParameters.get(name)) != null && o instanceof FileInfo) {
            return ((FileInfo)o).getLocalFile();
        }
        return null;
    }

    public String getParameterClientFileName(String name) {
        Object o;
        String returnVal = null;
        if (this.mIsMultipart && (o = this.mParameters.get(name)) != null && o instanceof FileInfo) {
            FileInfo fi = (FileInfo)o;
            returnVal = fi.getClientFileName();
        }
        return returnVal;
    }

    public HttpServletRequest getRequest() {
        return this.mParentRequest;
    }

    public String assertGetParameter(String inParamName) throws IllegalArgumentException {
        String val = this.getParameter(inParamName);
        if (val == null) {
            throw new IllegalArgumentException("Required parameter \"" + inParamName + "\" missing.");
        }
        return val;
    }

    public String getAuthType() {
        return this.mParentRequest.getAuthType();
    }

    public String getContextPath() {
        return this.mParentRequest.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.mParentRequest.getCookies();
    }

    public long getDateHeader(String p0) {
        return this.mParentRequest.getDateHeader(p0);
    }

    public String getHeader(String p0) {
        return this.mParentRequest.getHeader(p0);
    }

    public Enumeration getHeaderNames() {
        return this.mParentRequest.getHeaderNames();
    }

    public Enumeration getHeaders(String p0) {
        return this.mParentRequest.getHeaders(p0);
    }

    public int getIntHeader(String p0) {
        return this.mParentRequest.getIntHeader(p0);
    }

    public String getMethod() {
        return this.mParentRequest.getMethod();
    }

    public String getPathInfo() {
        return this.mParentRequest.getPathInfo();
    }

    public String getPathTranslated() {
        return this.mParentRequest.getPathTranslated();
    }

    public String getQueryString() {
        return this.mParentRequest.getQueryString();
    }

    public String getRemoteUser() {
        return this.mParentRequest.getRemoteUser();
    }

    public String getRequestURI() {
        return this.mParentRequest.getRequestURI();
    }

    public String getRequestedSessionId() {
        return this.mParentRequest.getRequestedSessionId();
    }

    public String getServletPath() {
        return this.mParentRequest.getServletPath();
    }

    public HttpSession getSession() {
        return this.mParentRequest.getSession();
    }

    public HttpSession getSession(boolean p0) {
        return this.mParentRequest.getSession(p0);
    }

    public Principal getUserPrincipal() {
        return this.mParentRequest.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.mParentRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.mParentRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.mParentRequest.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String p0) {
        return this.mParentRequest.isUserInRole(p0);
    }

    public void setAttribute(String s, Object o) {
        this.mParentRequest.setAttribute(s, o);
    }

    public Object getAttribute(String p0) {
        return this.mParentRequest.getAttribute(p0);
    }

    public void removeAttribute(String s) {
        this.mParentRequest.removeAttribute(s);
    }

    public boolean isSecure() {
        return this.mParentRequest.isSecure();
    }

    public Enumeration getAttributeNames() {
        return this.mParentRequest.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.mParentRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.getContentLength();
    }

    public String getContentType() {
        return this.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getInputStream();
    }

    public Locale getLocale() {
        return this.getLocale();
    }

    public Enumeration getLocales() {
        return this.getLocales();
    }

    public Enumeration getParameterNames() {
        if (this.mIsMultipart) {
            return this.mParameters.keys();
        }
        return this.mParentRequest.getParameterNames();
    }

    public String getProtocol() {
        return this.mParentRequest.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return this.mParentRequest.getReader();
    }

    public String getRemoteAddr() {
        return this.mParentRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.mParentRequest.getRemoteHost();
    }

    public RequestDispatcher getRequestDispatcher(String p0) {
        return this.mParentRequest.getRequestDispatcher(p0);
    }

    public String getScheme() {
        return this.mParentRequest.getScheme();
    }

    public String getServerName() {
        return this.mParentRequest.getServerName();
    }

    public int getServerPort() {
        return this.mParentRequest.getServerPort();
    }
}

