/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.ui.web.FileInfo;
import com.raplix.util.logger.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;

public class HttpMultiPartParser {
    private final int ONE_MB = 0x100000;
    private static String mCharacterEncoding;

    public Hashtable parseData(ServletInputStream data, String boundary, String saveInDir, String characterEncoding) throws IllegalArgumentException, IOException {
        return this.processData(data, boundary, saveInDir, characterEncoding);
    }

    public Hashtable parseData(ServletInputStream data, String boundary, String characterEncoding) throws IllegalArgumentException, IOException {
        return this.processData(data, boundary, null, characterEncoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable processData(ServletInputStream is, String boundary, String saveInDir, String characterEncoding) throws IllegalArgumentException, IOException {
        mCharacterEncoding = characterEncoding;
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null");
        }
        if (boundary == null || boundary.trim().length() < 1) {
            throw new IllegalArgumentException("Boundary string is null");
        }
        boundary = "--" + boundary;
        StringTokenizer stLine = null;
        StringTokenizer stFields = null;
        FileInfo fileInfo = null;
        Hashtable<String, Object> dataTable = new Hashtable<String, Object>(5);
        String line = null;
        String field = null;
        String paramName = null;
        boolean saveFiles = saveInDir != null && saveInDir.trim().length() > 0;
        boolean isFile = false;
        if (saveFiles) {
            File f = new File(saveInDir);
            f.mkdirs();
        }
        if ((line = this.getLine(is)) == null || !line.startsWith(boundary)) {
            throw new IOException("Boundary not found; boundary = " + boundary + ", line = " + line);
        }
        while (true) {
            if (line == null) {
                is.close();
                return dataTable;
            }
            if (line == null || !line.startsWith(boundary)) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Expected boundary line, giving up", this);
                }
                return dataTable;
            }
            line = this.getLine(is);
            if (line == null) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Expected Content-Disposition: line, giving up", this);
                }
                return dataTable;
            }
            stLine = new StringTokenizer(line, ";\r\n");
            if (stLine.countTokens() < 2) {
                throw new IllegalArgumentException("Bad data in second line");
            }
            line = stLine.nextToken().toLowerCase();
            if (line.indexOf("form-data") < 0) {
                throw new IllegalArgumentException("Bad data in second line");
            }
            stFields = new StringTokenizer(stLine.nextToken(), "=\"");
            if (stFields.countTokens() < 2) {
                throw new IllegalArgumentException("Bad data in second line");
            }
            fileInfo = new FileInfo();
            stFields.nextToken();
            paramName = stFields.nextToken();
            isFile = false;
            if (stLine.hasMoreTokens()) {
                field = stLine.nextToken();
                stFields = new StringTokenizer(field, "=\"");
                if (stFields.countTokens() > 1) {
                    if (stFields.nextToken().trim().equalsIgnoreCase("filename")) {
                        fileInfo.setName(paramName);
                        String value = stFields.nextToken();
                        if (value != null && value.trim().length() > 0) {
                            fileInfo.setClientFileName(value);
                            isFile = true;
                        } else {
                            if (Logger.isDebugEnabled(this)) {
                                Logger.debug("Failed to parse filename of: [" + value + "]", this);
                            }
                            this.getLine(is);
                            this.getLine(is);
                            line = this.getLine(is);
                            if (line.startsWith(boundary)) continue;
                            line = this.getLine(is);
                            continue;
                        }
                    }
                } else if (field.toLowerCase().indexOf("filename") >= 0) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Failed to parse: [" + field + "]", this);
                    }
                    this.getLine(is);
                    this.getLine(is);
                    line = this.getLine(is);
                    if (line.startsWith(boundary)) continue;
                    line = this.getLine(is);
                    continue;
                }
            }
            boolean skipBlankLine = true;
            if (isFile) {
                line = this.getLine(is);
                if (line == null) {
                    return dataTable;
                }
                if (line.trim().length() < 1) {
                    skipBlankLine = false;
                } else {
                    stLine = new StringTokenizer(line, ": ");
                    if (stLine.countTokens() < 2) {
                        throw new IllegalArgumentException("Bad data in third line");
                    }
                    stLine.nextToken();
                    fileInfo.setFileContentType(stLine.nextToken());
                }
            }
            if (skipBlankLine && (line = this.getLine(is)) == null) {
                return dataTable;
            }
            if (!isFile) {
                StringBuffer stuff = new StringBuffer();
                line = this.getLine(is);
                boolean firstLine = true;
                while (!line.startsWith(boundary)) {
                    if (!firstLine) {
                        stuff.append("\n");
                    }
                    stuff.append(line);
                    line = this.getLine(is);
                    firstLine = false;
                }
                dataTable.put(paramName, stuff.toString());
                continue;
            }
            try {
                OutputStream os = null;
                String path = null;
                if (saveFiles) {
                    File file = File.createTempFile("multipart_cache.", null, new File(saveInDir));
                    file.deleteOnExit();
                    path = file.getCanonicalPath();
                    os = new FileOutputStream(path);
                } else {
                    os = new ByteArrayOutputStream(0x100000);
                }
                boolean readingContent = true;
                byte[] b = new byte[0x200000];
                byte[] b2 = null;
                while (readingContent) {
                    int read = is.readLine(b, 0, b.length);
                    if (read == -1) {
                        line = null;
                        break;
                    }
                    if (read < 3) {
                        b2 = new byte[read];
                        System.arraycopy(b, 0, b2, 0, b2.length);
                        read = is.readLine(b, 0, b.length);
                        if (read == -1) {
                            line = null;
                            break;
                        }
                    }
                    if (this.compareBoundary(boundary, b)) {
                        line = new String(b, 0, read, mCharacterEncoding);
                        break;
                    }
                    if (b2 != null) {
                        os.write(b2);
                        b2 = null;
                    }
                    os.write(b, 0, read);
                    os.flush();
                }
                os.close();
                b = null;
                if (!saveFiles) {
                    OutputStream baos = os;
                    fileInfo.setFileContents(((ByteArrayOutputStream)baos).toByteArray());
                } else {
                    fileInfo.setLocalFile(new File(path));
                    os = null;
                }
                dataTable.put(paramName, fileInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private boolean compareBoundary(String boundary, byte[] ba) throws IOException {
        if (boundary == null || ba == null) {
            return false;
        }
        for (int i = 0; i < boundary.length(); ++i) {
            if (new String(new char[]{boundary.charAt(i)}).getBytes(mCharacterEncoding)[0] == ba[i]) continue;
            return false;
        }
        return true;
    }

    private synchronized String getLine(ServletInputStream sis) throws IOException {
        int index;
        byte[] b = new byte[1024];
        int read = sis.readLine(b, 0, b.length);
        String line = null;
        if (read != -1 && (index = (line = new String(b, 0, read, mCharacterEncoding)).indexOf(10)) >= 0) {
            line = line.substring(0, index - 1);
        }
        b = null;
        return line;
    }
}

