/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXDifferenceStartEvent;
import com.raplix.rolloutexpress.event.query.bean.RunningDiffBean;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import java.util.Vector;
import org.apache.struts.util.MessageResources;

public class HomeBean
extends ServletBean {
    private static final String MSG_COMPLETION_STATUS_NOTRUNNING = "homePage.taskCompletion.completed";
    private static final String MSG_COMPLETION_STATUS_RUNNING = "homePage.taskCompletion.running";
    private String[] mPlanNames = new String[0];
    private String[] mPlanCompletes = new String[0];
    private String[] mPlanIDs = new String[0];
    private String[] mTaskIDs = new String[0];
    private boolean[] mPlanIsRunning = new boolean[0];
    private String[] mComparisonNames = new String[0];
    private String[] mComparisonCompletes = new String[0];
    private String[] mJobIDs = new String[0];
    private String[] mSettingIDs = new String[0];
    private boolean[] mDiffIsRunning = new boolean[0];
    private NotificationRPCInterface mNotMgr = null;
    private DifferenceDBInterface mDiffDB = null;
    protected MessageResources mMessages = null;
    private static final int NUM_MAX_PLANS = 5;
    private static final int NUM_MAX_DIFFS = 5;

    public HomeBean(NotificationRPCInterface notMgr, DifferenceDBInterface diffDB) {
        this.mNotMgr = notMgr;
        this.mDiffDB = diffDB;
        this.mMessages = ApplicationResources.getMessageResources();
    }

    public String[] getPlanIDs() {
        return this.mPlanIDs;
    }

    public String[] getTaskIDs() {
        return this.mTaskIDs;
    }

    public String[] getPlanNames() {
        return this.mPlanNames;
    }

    public String[] getPlanCompletes() {
        return this.mPlanCompletes;
    }

    public boolean[] getPlanIsRunning() {
        return this.mPlanIsRunning;
    }

    public String[] getJobIDs() {
        return this.mJobIDs;
    }

    public String[] getSettingIDs() {
        return this.mSettingIDs;
    }

    public String[] getComparisonNames() {
        return this.mComparisonNames;
    }

    public String[] getComparisonCompletes() {
        return this.mComparisonCompletes;
    }

    public boolean[] getDiffIsRunning() {
        return this.mDiffIsRunning;
    }

    public void loadPlans() throws RaplixException {
        RunningPlanBean[] newPlans = this.mNotMgr.queryRunningOrCompletedPlans(null, 5).toArray(new RunningPlanBean[0]);
        int len = newPlans.length;
        this.mPlanNames = new String[len];
        this.mPlanCompletes = new String[len];
        this.mPlanIDs = new String[len];
        this.mTaskIDs = new String[len];
        this.mPlanIsRunning = new boolean[len];
        for (int i = 0; i < newPlans.length; ++i) {
            this.mPlanNames[i] = newPlans[i].getExecutionPlan().getFullName();
            this.mPlanIDs[i] = newPlans[i].getExecutionPlanID().toString();
            this.mTaskIDs[i] = newPlans[i].getTaskID().toString();
            if (newPlans[i].getIsRunning()) {
                this.mPlanIsRunning[i] = true;
                this.mPlanCompletes[i] = ApplicationResources.getMessage(MSG_COMPLETION_STATUS_RUNNING, newPlans[i].getStartDate());
                continue;
            }
            this.mPlanIsRunning[i] = false;
            this.mPlanCompletes[i] = ApplicationResources.getMessage(MSG_COMPLETION_STATUS_NOTRUNNING, newPlans[i].getCompleteDate());
        }
    }

    public void loadDiffs() throws RaplixException {
        RunningDiffBean[] newDiffs = this.mNotMgr.queryRunningOrCompletedDiffs(5).toArray(new RunningDiffBean[0]);
        int len = newDiffs.length;
        this.mComparisonNames = new String[len];
        this.mComparisonCompletes = new String[len];
        this.mSettingIDs = new String[len];
        this.mJobIDs = new String[len];
        this.mDiffIsRunning = new boolean[len];
        for (int i = 0; i < len; ++i) {
            this.mJobIDs[i] = newDiffs[i].getDifferenceJobID().toString();
            if (newDiffs[i].getIsRunning()) {
                this.mDiffIsRunning[i] = true;
                this.mComparisonCompletes[i] = ApplicationResources.getMessage(MSG_COMPLETION_STATUS_RUNNING, newDiffs[i].getStartDate());
            } else {
                this.mDiffIsRunning[i] = false;
                this.mComparisonCompletes[i] = ApplicationResources.getMessage(MSG_COMPLETION_STATUS_NOTRUNNING, newDiffs[i].getCompleteDate());
            }
            this.mSettingIDs[i] = newDiffs[i].getDifferenceSettingsID().toString();
            this.mComparisonNames[i] = newDiffs[i].getDifferenceSettings().getName();
        }
    }

    private String getSettingIDFromJobID(String jobID) throws RaplixException {
        DifferenceJobID jobIDObj = new DifferenceJobID(jobID);
        ROXDifferenceStartEvent startedEventProto = new ROXDifferenceStartEvent();
        Vector<ROXDifferenceStartEvent> protos = new Vector<ROXDifferenceStartEvent>();
        startedEventProto.setDifferenceJobID(jobIDObj);
        protos.add(startedEventProto);
        Vector startedEventArray = this.mNotMgr.query(protos);
        ROXDifferenceStartEvent startedEvent = (ROXDifferenceStartEvent)startedEventArray.get(0);
        return startedEvent.getDifferenceSettingsID().toString();
    }
}

