/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferenceInterface;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXDifferenceStartEvent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.DiffsBean;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class DiffsHandleAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_CREATE = "error.diffs.create";
    private static final String MSG_ERROR_EDIT = "error.diffs.edit";
    private static final String MSG_ERROR_CANCEL = "error.diffs.cancel";
    private static final String MSG_ERROR_REMOVE_IGNORE = "error.diffs.removeIgnore";
    private static final String MSG_ERROR_ADD_IGNORE = "error.diffs.addIgnore";
    private static final String MSG_ERROR_RUN = "error.diffs.run";
    private static final String MSG_ERROR_SAVE_MAJOR = "error.diffs.save.major";
    private static final String MSG_ERROR_SAVE_BAD_TIME_VALUE = "error.diffs.save.badTimeValue";
    private static final String MSG_ERROR_PREVIOUS_RESULTS = "error.diffs.previousResults";
    private static final String MSG_ERROR_PREVIOUS_RESULTS_NO_JOBS = "error.diffs.previousResults.noJobs";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = DiffsHandleAction.assertGetParam(request, "mode");
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        bean.setIncomingMode(mode);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through DiffsHandleAction's doUIAction: " + mode, this);
        }
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("notconfirmed")) {
            this.handleNotConfirmed(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("saveas")) {
            this.handleSaveAs(request, servletInfo);
        } else if (mode.equals("saveconfirmed")) {
            this.handleSaveAsConfirmed(request, servletInfo);
        } else if (mode.equals("addignore")) {
            this.handleAddIgnore(request, servletInfo);
        } else if (mode.equals("removeignore")) {
            this.handleRemoveIgnore(request, servletInfo);
        } else if (mode.equals("run")) {
            this.handleRun(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("previousresults")) {
            this.handlePreviousResults(request, servletInfo);
        } else if (mode.equals("previousresultsfromlist")) {
            this.handlePreviousResultsFromList(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to DiffsHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        String mode = DiffsHandleAction.assertGetParam(request, "mode");
        DiffsBean bean = null;
        if (mode.equals("cancel") || mode.equals("add") || mode.equals("delete") || mode.equals("previousresultsfromlist") || mode.equals("edit") || mode.equals("editfromlist")) {
            DifferenceDBInterface diffDB = DiffsHandleAction.getApplication().getDifferenceDBInterface();
            DifferenceInterface diffInf = DiffsHandleAction.getApplication().getDifferenceInterface();
            NotificationRPCInterface notificationMan = DiffsHandleAction.getApplication().getNotificationInterface();
            InstallDBManager installDB = DiffsHandleAction.getApplication().getInstallDBManager();
            bean = new DiffsBean(diffDB, diffInf, notificationMan, installDB);
        } else {
            String id = request.getParameter("id");
            bean = (DiffsBean)request.getSession().getAttribute(id);
            if (bean == null) {
                throw new IllegalArgumentException("Expected Bean not found.");
            }
        }
        return bean;
    }

    public String getDefaultPage() {
        return "/diffs.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = DiffsHandleAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through DiffsHandleAction's getMajorError: " + mode, this);
        }
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("notconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveas")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("addignore")) {
            return MSG_ERROR_ADD_IGNORE;
        }
        if (mode.equals("removeignore")) {
            return MSG_ERROR_REMOVE_IGNORE;
        }
        if (mode.equals("run")) {
            return MSG_ERROR_RUN;
        }
        if (mode.equals("refresh")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("previousresults")) {
            return MSG_ERROR_PREVIOUS_RESULTS;
        }
        if (mode.equals("previousresultsfromlist")) {
            return MSG_ERROR_PREVIOUS_RESULTS;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to DiffsHandleAction.");
    }

    protected void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        bean.generateList();
        bean.setIsNew(true);
        this.persistNameAndDescription(request, bean);
        bean.loadGlobalIgnoreSettings();
        bean.loadPermissionLookaheads();
        servletInfo.setDestPage("/diffDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        String id = DiffsHandleAction.assertGetParam(request, "id");
        bean.loadDiffSettings(id);
        bean.loadGlobalIgnoreSettings();
        bean.loadPermissionLookaheads();
        this.loadAdditionalDetails(request, bean);
        servletInfo.setDestPage("/diffDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        bean.rollbackState();
        bean.loadGlobalIgnoreSettings();
        this.loadAdditionalDetails(request, bean);
        servletInfo.setDestPage("/diffDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/Diffs");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        this.persistNameAndDescription(request, bean);
        this.persistDetails(request, bean);
        try {
            this.loadAdditionalDetails(request, bean);
            if (!this.isValidValues(bean, servletInfo.getErrors())) {
                servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
                bean.setMode("edit");
                servletInfo.setDestPage("/diffDetails.jsp");
                servletInfo.setShouldRedirect(false);
                return;
            }
            bean.persistToDB();
        }
        catch (RaplixException e) {
            this.handleErrorOnDetailsPage(request, servletInfo, e);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorError(request));
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            bean.setMode("edit");
            servletInfo.setDestPage("/diffDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/Diffs");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleSaveAs(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        this.persistNameAndDescription(request, bean);
        this.persistDetails(request, bean);
        try {
            this.loadAdditionalDetails(request, bean);
            if (!this.isValidValues(bean, servletInfo.getErrors())) {
                servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
                bean.setMode("edit");
                servletInfo.setDestPage("/diffDetails.jsp");
                servletInfo.setShouldRedirect(false);
                return;
            }
        }
        catch (RaplixException e) {
            this.handleErrorOnDetailsPage(request, servletInfo, e);
            return;
        }
        bean.setMode("saveas");
        bean.checkpointState();
        servletInfo.setDestPage("/diffConfirm.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleSaveAsConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        this.persistNameAndDescription(request, bean);
        try {
            bean.persistCopyToDB();
        }
        catch (RaplixException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            bean.setMode("saveas");
            servletInfo.setDestPage("/diffConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorError(request));
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            bean.setMode("saveas");
            servletInfo.setDestPage("/diffConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/Diffs");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleAddIgnore(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        this.persistNameAndDescription(request, bean);
        this.persistDetails(request, bean);
        try {
            this.loadAdditionalDetails(request, bean);
        }
        catch (RaplixException e) {
            this.handleErrorOnDetailsPage(request, servletInfo, e);
            return;
        }
        bean.handleAddIgnore();
        servletInfo.setDestPage("/diffDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRemoveIgnore(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        this.persistNameAndDescription(request, bean);
        this.persistDetails(request, bean);
        try {
            this.loadAdditionalDetails(request, bean);
        }
        catch (RaplixException e) {
            this.handleErrorOnDetailsPage(request, servletInfo, e);
            return;
        }
        String removeIndex = request.getParameter("ruleIndex");
        int idx = Integer.parseInt(removeIndex);
        bean.removeIgnore(idx);
        servletInfo.setDestPage("/diffDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRun(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DifferenceJobID jobID;
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        this.persistNameAndDescription(request, bean);
        this.persistDetails(request, bean);
        try {
            this.loadAdditionalDetails(request, bean);
            if (!this.isValidValues(bean, servletInfo.getErrors())) {
                servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
                bean.setMode("edit");
                servletInfo.setDestPage("/diffDetails.jsp");
                servletInfo.setShouldRedirect(false);
                return;
            }
            jobID = bean.runDiff();
        }
        catch (RaplixException e) {
            this.handleErrorOnDetailsPage(request, servletInfo, e);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorError(request));
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            bean.setMode("edit");
            servletInfo.setDestPage("/diffDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        String forwardAddress = "/DiffTaskDetails?jobid=" + jobID.toString() + "&" + "settingsid" + "=" + bean.getID() + "&" + "mode" + "=" + "view";
        servletInfo.setDestPage(forwardAddress);
        servletInfo.setShouldRedirect(true);
    }

    protected void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        this.persistNameAndDescription(request, bean);
        this.persistDetails(request, bean);
        try {
            this.loadAdditionalDetails(request, bean);
        }
        catch (RaplixException e) {
            this.handleErrorOnDetailsPage(request, servletInfo, e);
            return;
        }
        servletInfo.setDestPage("/diffDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handlePreviousResults(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        DifferenceJobID jobID = this.getLastJobIDFromSettingsID(new DifferenceSettingsID(bean.getID()));
        if (jobID == null) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_PREVIOUS_RESULTS);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_PREVIOUS_RESULTS_NO_JOBS);
            bean.setMode("edit");
            servletInfo.setDestPage("/diffDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        String forwardAddress = "/DiffTaskDetails?jobid=" + jobID.toString() + "&" + "mode" + "=" + "view";
        servletInfo.setDestPage(forwardAddress);
        servletInfo.setShouldRedirect(true);
    }

    protected void handlePreviousResultsFromList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String id = DiffsHandleAction.assertGetParam(request, "id");
        DifferenceSettingsID dsID = this.getLatestDifferenceSettingsID(new DifferenceSettingsID(id));
        DifferenceJobID jobID = this.getLastJobIDFromSettingsID(dsID);
        if (jobID == null) {
            servletInfo.setDestPage("/Diffs");
            servletInfo.setShouldRedirect(false);
            return;
        }
        String forwardAddress = "/DiffTaskDetails?jobid=" + jobID.toString() + "&" + "mode" + "=" + "view";
        servletInfo.setDestPage(forwardAddress);
        servletInfo.setShouldRedirect(true);
    }

    private void persistNameAndDescription(HttpServletRequest request, DiffsBean bean) {
        String description;
        String name = request.getParameter("name");
        if (name != null) {
            bean.setName(name);
        }
        if ((description = request.getParameter("description")) != null) {
            bean.setDescription(description);
        }
    }

    private void persistDetails(HttpServletRequest request, DiffsBean bean) {
        String useSteps;
        String dstCleanupSteps;
        String srcCleanupSteps;
        String dstPrepareSteps;
        String spec;
        String newIgnoreSpec;
        String destDir;
        String srcDir;
        String destHostName;
        String srcHostName;
        String srcInstalledComponentID;
        String scope;
        String inst2InstLOD;
        if (bean.getStyle().equals("inst2inst")) {
            String followSymbolicLinks = request.getParameter("followSymbolicLinks");
            if (followSymbolicLinks != null) {
                bean.setFollowSymbolicLinks(true);
            } else {
                bean.setFollowSymbolicLinks(false);
            }
        }
        String style = DiffsHandleAction.assertGetParam(request, "style");
        bean.setStyle(style);
        String repo2InstLOD = request.getParameter("repo2InstLevelOfDetail");
        if (repo2InstLOD != null) {
            bean.setRepo2InstLOD(repo2InstLOD);
        }
        if ((inst2InstLOD = request.getParameter("inst2InstLevelOfDetail")) != null) {
            bean.setInst2InstLOD(inst2InstLOD);
        }
        if ((scope = request.getParameter("scope")) != null) {
            bean.setScope(scope);
        } else {
            bean.setScope("host");
        }
        String srcHostSetID = request.getParameter("srcHostSetID");
        if (srcHostSetID != null) {
            bean.setSrcHostSetID(srcHostSetID);
        }
        if ((srcInstalledComponentID = request.getParameter("srcInstalledComponentID")) != null) {
            bean.setSrcInstalledComponentID(srcInstalledComponentID);
        }
        if ((srcHostName = request.getParameter("srcHostName")) != null) {
            bean.setSrcHostName(srcHostName);
        }
        if ((destHostName = request.getParameter("destHostName")) != null) {
            bean.setDestHostName(destHostName);
        }
        if ((srcDir = request.getParameter("srcDir")) != null) {
            bean.setSrcDir(srcDir);
        }
        if ((destDir = request.getParameter("destDir")) != null) {
            bean.setDestDir(destDir);
        }
        if ((newIgnoreSpec = request.getParameter("newIgnoreSpec")) != null) {
            bean.setNewIgnoreSpec(newIgnoreSpec);
        }
        int counter = 0;
        while ((spec = request.getParameter("ignoreSpecs" + counter)) != null) {
            if (counter == 0) {
                bean.clearIgnores();
            }
            ++counter;
            bean.addIgnore(spec);
        }
        String inst2InstRec = request.getParameter("inst2InstRecurse");
        if (inst2InstRec != null) {
            bean.setInst2InstRecurse(true);
        } else {
            bean.setInst2InstRecurse(false);
        }
        String srcPrepareSteps = request.getParameter("srcPrepareSteps");
        if (srcPrepareSteps != null) {
            bean.setSrcPrepareSteps(srcPrepareSteps);
        }
        if ((dstPrepareSteps = request.getParameter("dstPrepareSteps")) != null) {
            bean.setDstPrepareSteps(dstPrepareSteps);
        }
        if ((srcCleanupSteps = request.getParameter("srcCleanupSteps")) != null) {
            bean.setSrcCleanupSteps(srcCleanupSteps);
        }
        if ((dstCleanupSteps = request.getParameter("dstCleanupSteps")) != null) {
            bean.setDstCleanupSteps(dstCleanupSteps);
        }
        if ((useSteps = request.getParameter("useSteps")) != null && useSteps.equals("on")) {
            bean.setUseSteps(true);
            String useSamePrepareSteps = request.getParameter("useSamePrepareSteps");
            if (useSamePrepareSteps != null && useSamePrepareSteps.equals("on")) {
                bean.setUseSamePrepareSteps(true);
            } else {
                bean.setUseSamePrepareSteps(false);
            }
            String useSameCleanupSteps = request.getParameter("useSameCleanupSteps");
            if (useSameCleanupSteps != null && useSameCleanupSteps.equals("on")) {
                bean.setUseSameCleanupSteps(true);
            } else {
                bean.setUseSameCleanupSteps(false);
            }
        } else if (bean.getStyle().equals("inst2inst") && request.getParameter("srcPrepareSteps") != null) {
            bean.setUseSteps(false);
        }
        String timeLimitUnits = request.getParameter("timeLimitUnits");
        bean.setTimeLimitUnits(timeLimitUnits);
        String timeLimitValue = request.getParameter("timeLimitValue");
        bean.setTimeLimitValue(timeLimitValue);
    }

    private void loadAdditionalDetails(HttpServletRequest request, DiffsBean bean) throws RaplixException {
        String id = DiffsHandleAction.assertGetParam(request, "id");
        if (id.equals("")) {
            id = bean.getID();
        }
        bean.setIsJobRunning(bean.checkIsJobRunning(id));
        String style = bean.getStyle();
        if (style.equals("repo2repo")) {
            this.loadRepo2RepoDetails(request, bean);
        } else if (style.equals("repo2inst")) {
            this.loadRepo2InstDetails(request, bean);
        } else {
            this.loadInst2InstDetails(request, bean);
        }
    }

    private void loadRepo2RepoDetails(HttpServletRequest request, DiffsBean bean) throws RaplixException {
        bean.loadGlobalIgnoreSettings();
    }

    private void loadRepo2InstDetails(HttpServletRequest request, DiffsBean bean) throws RaplixException {
        String scope = bean.getScope();
        if (scope.equals("host")) {
            bean.loadHostIgnoreSettings();
        } else if (scope.equals("hostset")) {
            bean.loadHostSetList();
        } else if (scope.equals("component")) {
            bean.loadComponentList();
            bean.loadComponentIgnoreSettings();
        }
    }

    private void loadInst2InstDetails(HttpServletRequest request, DiffsBean bean) throws RaplixException {
        bean.loadGlobalIgnoreSettings();
    }

    private void handleErrorOnDetailsPage(HttpServletRequest request, ServletInfo servletInfo, Exception e) {
        servletInfo.getErrors().setMajorErrorKey(this.getMajorError(request));
        servletInfo.getErrors().addMinorError(e.getMessage());
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        bean.setMode("edit");
        servletInfo.setDestPage("/diffDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private DifferenceJobID getLastJobIDFromSettingsID(DifferenceSettingsID settingID) throws RaplixException {
        Vector startedEvents;
        NotificationRPCInterface notMan = DiffsHandleAction.getApplication().getNotificationInterface();
        ROXDifferenceStartEvent startedEventProto = new ROXDifferenceStartEvent();
        Vector<ROXDifferenceStartEvent> protos = new Vector<ROXDifferenceStartEvent>();
        startedEventProto.setDifferenceSettingsID(settingID);
        protos.add(startedEventProto);
        try {
            startedEvents = notMan.query(protos);
        }
        catch (EmptyQueryException e) {
            return null;
        }
        ROXDifferenceStartEvent startedEvent = (ROXDifferenceStartEvent)startedEvents.get(startedEvents.size() - 1);
        return startedEvent.getDifferenceJobID();
    }

    private DifferenceSettingsID getLatestDifferenceSettingsID(DifferenceSettingsID dsID) throws RaplixException {
        DifferenceSettingsID latestID = dsID;
        DifferenceDBInterface diffDB = DiffsHandleAction.getApplication().getDifferenceDBInterface();
        DifferenceSettings ds = diffDB.getDifferenceSettings(dsID);
        DifferenceSettings latestDS = (DifferenceSettings)ds.retrieveLatest();
        if (!latestDS.equals(ds)) {
            latestID = (DifferenceSettingsID)latestDS.getObjectID();
        }
        return latestID;
    }

    private boolean isValidValues(DiffsBean bean, ServletErrors errors) {
        boolean isAllValid = true;
        try {
            Integer.parseInt(bean.getTimeLimitValue());
        }
        catch (NumberFormatException e) {
            errors.addMinorErrorKey(MSG_ERROR_SAVE_BAD_TIME_VALUE);
            isAllValid = false;
        }
        return isAllValid;
    }
}

