/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferenceInterface;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsIDSet;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsOrder;
import com.raplix.rolloutexpress.difference.differencedb.MultiDifferenceSettingsQuery;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.event.query.bean.RunningDiffBean;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ParameterConstants;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.ArrayEdit;
import com.raplix.util.logger.Logger;
import java.util.Arrays;
import java.util.Vector;

public class DiffsBean
extends ServletListBean
implements ParameterConstants {
    protected static final String DUMMY_ID = "0";
    private static final DifferenceSettingsOrder DEFAULT_SORT_ORDER = DifferenceSettingsOrder.BY_NAME_ASC;
    protected String mMode = "";
    protected String mIncomingMode = "";
    protected DifferenceJobID mDiffJob = null;
    protected DifferenceDBInterface mDiffDB = null;
    protected DifferenceInterface mDiffInf = null;
    protected NotificationRPCInterface mNotInf = null;
    protected InstallDBManager mInstallDB = null;
    protected String[] mJobNames = new String[0];
    protected String[] mJobDescriptions = new String[0];
    protected String[] mJobIDs = new String[0];
    protected String[] mIsRunning = new String[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    protected DifferenceSettings mDifferenceSetting = null;
    protected DifferenceSettings mOldDifferenceSetting = null;
    protected DifferenceSettings[] mDifferenceSettingsArray = null;
    protected String mName = "";
    protected String mDescription = "";
    protected String mCatNamesString = "";
    protected CategoryIDSet mCategoryIDSet = null;
    protected String mStyle = "repo2repo";
    protected String mRepo2InstLOD = "dircontent";
    protected String mInst2InstLOD = "dircontent";
    protected String mScope = "host";
    protected String[] mHostSetIDs = new String[0];
    protected String[] mHostSetNames = new String[0];
    protected String mSrcHostSetID = "";
    protected String[] mInstalledComponentIDs = null;
    protected String[] mComponentNames = null;
    protected String mSrcInstalledComponentID = "";
    protected String mSrcHostName = "";
    protected String mDestHostName = "";
    protected String mSrcDir = "";
    protected String mDestDir = "";
    protected boolean mIsNew = false;
    protected boolean mIsJobRunning = false;
    protected String mNewIgnoreSpec = "";
    protected boolean mInst2InstRecurse = true;
    protected Vector mIgnoreSpecs = new Vector();
    protected boolean mFollowSymbolicLinks = true;
    protected boolean mUseSteps = false;
    protected boolean mUseSamePrepareSteps = true;
    protected String mSrcPrepareSteps = "";
    protected String mDstPrepareSteps = "";
    protected boolean mUseSameCleanupSteps = true;
    protected String mSrcCleanupSteps = "";
    protected String mDstCleanupSteps = "";
    protected SummaryComponent[] mComponents = null;
    protected InstalledComponent[] mInstalledComponents = null;
    protected String[] mStaticIgnoreSources = new String[0];
    protected String[] mStaticIgnoreSpecs = new String[0];
    protected String mTimeLimitValue = "4";
    protected String mTimeLimitUnits = "hours";
    protected String[] mTimeUnits = new String[]{"hours", "minutes"};
    protected String[] mTimeLabels = new String[]{"hours", "minutes"};
    protected String[] mGlobalIgnoreSpecs = null;
    protected boolean mHasDiffRun = true;
    protected boolean mHasWriteOnDiffs = true;

    public DiffsBean(DifferenceDBInterface diffDB, DifferenceInterface diffInf, NotificationRPCInterface notInf, InstallDBManager installDB) {
        this.mDiffDB = diffDB;
        this.mDiffInf = diffInf;
        this.mNotInf = notInf;
        this.mDifferenceSetting = new DifferenceSettings();
        this.mInstallDB = installDB;
    }

    public String getMode() {
        return this.mMode;
    }

    public String getIncomingMode() {
        return this.mIncomingMode;
    }

    public String[] getJobNames() {
        return this.mJobNames;
    }

    public String[] getJobDescriptions() {
        return this.mJobDescriptions;
    }

    public String[] getJobIDs() {
        return this.mJobIDs;
    }

    public String[] getIsRunning() {
        return this.mIsRunning;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public DifferenceDBInterface getDiffDB() {
        return this.mDiffDB;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getCatNamesString() {
        return this.mCatNamesString;
    }

    public CategoryIDSet getCategoryIDSet() {
        return this.mCategoryIDSet;
    }

    public String getID() {
        if (this.mDifferenceSetting.getObjectID() == null) {
            return super.getID();
        }
        return this.mDifferenceSetting.getObjectID().toString();
    }

    public String getStyle() {
        return this.mStyle;
    }

    public String getRepo2InstLevelOfDetail() {
        return this.mRepo2InstLOD;
    }

    public String getInst2InstLevelOfDetail() {
        return this.mInst2InstLOD;
    }

    public String getScope() {
        return this.mScope;
    }

    public String[] getHostSetIDs() {
        return this.mHostSetIDs;
    }

    public String[] getHostSetNames() {
        return this.mHostSetNames;
    }

    public String getSrcHostSetID() {
        return this.mSrcHostSetID;
    }

    public String[] getInstalledComponentIDs() {
        return this.mInstalledComponentIDs;
    }

    public String[] getComponentNames() {
        return this.mComponentNames;
    }

    public String getSrcInstalledComponentID() {
        return this.mSrcInstalledComponentID;
    }

    public String getSrcHostName() {
        return this.mSrcHostName;
    }

    public String getDestHostName() {
        return this.mDestHostName;
    }

    public String getSrcDir() {
        return this.mSrcDir;
    }

    public String getDestDir() {
        return this.mDestDir;
    }

    public String[] getIgnoreSpecs() {
        return this.mIgnoreSpecs.toArray(new String[0]);
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public boolean getIsJobRunning() {
        return this.mIsJobRunning;
    }

    public String getNewIgnoreSpec() {
        return this.mNewIgnoreSpec;
    }

    public boolean getInst2InstRecurse() {
        return this.mInst2InstRecurse;
    }

    public boolean getFollowSymbolicLinks() {
        return this.mFollowSymbolicLinks;
    }

    public DifferenceJobID getDiffJobID() {
        return this.mDiffJob;
    }

    public SummaryComponent[] getComponents() {
        return this.mComponents;
    }

    public String[] getTimeUnits() {
        return this.mTimeUnits;
    }

    public String[] getTimeLabels() {
        return this.mTimeLabels;
    }

    public String[] getStaticIgnoreSources() {
        return this.mStaticIgnoreSources;
    }

    public String[] getStaticIgnoreSpecs() {
        return this.mStaticIgnoreSpecs;
    }

    public String getTimeLimitValue() {
        return this.mTimeLimitValue;
    }

    public String getTimeLimitUnits() {
        return this.mTimeLimitUnits;
    }

    public boolean getHasDiffRun() {
        return this.mHasDiffRun;
    }

    public boolean getHasWriteOnDiffs() {
        return this.mHasWriteOnDiffs;
    }

    public void setComponents(SummaryComponent[] inValue) {
        this.mComponents = inValue;
    }

    public void setTimeUnits(String[] inValue) {
        this.mTimeUnits = inValue;
    }

    public void setTimeLabels(String[] inValue) {
        this.mTimeLabels = inValue;
    }

    public void setStaticIgnoreSources(String[] inValue) {
        this.mStaticIgnoreSources = inValue;
    }

    public void setStaticIgnoreSpecs(String[] inValue) {
        this.mStaticIgnoreSpecs = inValue;
    }

    public void setTimeLimitValue(String inValue) {
        this.mTimeLimitValue = inValue;
    }

    public void setTimeLimitUnits(String inValue) {
        this.mTimeLimitUnits = inValue;
    }

    public void setDiffJobID(DifferenceJobID inDiffJob) {
        this.mDiffJob = inDiffJob;
    }

    public void setDiffDB(DifferenceDBInterface inDiffDB) {
        this.mDiffDB = inDiffDB;
    }

    public void setInst2InstRecurse(boolean in) {
        this.mInst2InstRecurse = in;
    }

    public void setFollowSymbolicLinks(boolean inValue) {
        this.mFollowSymbolicLinks = inValue;
    }

    public void setStyle(String inStyle) {
        this.mStyle = inStyle;
    }

    public void setSrcHostName(String inName) {
        if (!inName.equals(this.mSrcHostName) || this.mComponents != null && this.mComponents.length == 0) {
            this.mSrcHostName = inName;
            this.mComponents = null;
            this.mInstalledComponentIDs = null;
            this.mComponentNames = null;
        }
    }

    public void setDestHostName(String inName) {
        this.mDestHostName = inName;
    }

    public void setRepo2InstLOD(String in) {
        this.mRepo2InstLOD = in;
    }

    public void setInst2InstLOD(String in) {
        this.mInst2InstLOD = in;
    }

    public void setScope(String in) {
        this.mScope = in;
    }

    public void setSrcHostSetID(String in) {
        if (!in.equals(this.mSrcHostSetID)) {
            this.mSrcHostSetID = in;
            this.mComponents = null;
        }
    }

    public void setSrcInstalledComponentID(String in) {
        this.mSrcInstalledComponentID = in;
    }

    public void setSrcDir(String in) {
        this.mSrcDir = in;
    }

    public void setDestDir(String in) {
        this.mDestDir = in;
    }

    public void setNewIgnoreSpec(String in) {
        this.mNewIgnoreSpec = in;
    }

    public void setMode(String in) {
        this.mMode = in;
    }

    public void setIncomingMode(String in) {
        this.mIncomingMode = in;
    }

    public void setName(String inName) {
        this.mName = inName;
    }

    public void setDescription(String inDesc) {
        this.mDescription = inDesc;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setIsJobRunning(boolean isJobRunning) {
        this.mIsJobRunning = isJobRunning;
    }

    public boolean getUseSteps() {
        return this.mUseSteps;
    }

    public void setUseSteps(boolean inUseSteps) {
        this.mUseSteps = inUseSteps;
    }

    public boolean getUseSamePrepareSteps() {
        return this.mUseSamePrepareSteps;
    }

    public void setUseSamePrepareSteps(boolean inUseSamePrepareSteps) {
        this.mUseSamePrepareSteps = inUseSamePrepareSteps;
    }

    public String getSrcPrepareSteps() {
        return this.mSrcPrepareSteps;
    }

    public void setSrcPrepareSteps(String inSrcPrepareSteps) {
        this.mSrcPrepareSteps = inSrcPrepareSteps;
    }

    public String getDstPrepareSteps() {
        return this.mDstPrepareSteps;
    }

    public void setDstPrepareSteps(String inDstPrepareSteps) {
        this.mDstPrepareSteps = inDstPrepareSteps;
    }

    public boolean getUseSameCleanupSteps() {
        return this.mUseSameCleanupSteps;
    }

    public void setUseSameCleanupSteps(boolean inUseSameCleanupSteps) {
        this.mUseSameCleanupSteps = inUseSameCleanupSteps;
    }

    public String getSrcCleanupSteps() {
        return this.mSrcCleanupSteps;
    }

    public void setSrcCleanupSteps(String inSrcCleanupSteps) {
        this.mSrcCleanupSteps = inSrcCleanupSteps;
    }

    public String getDstCleanupSteps() {
        return this.mDstCleanupSteps;
    }

    public void setDstCleanupSteps(String inDstCleanupSteps) {
        this.mDstCleanupSteps = inDstCleanupSteps;
    }

    public void loadHostSetList() throws RaplixException {
        HostSetsListBean hslb = new HostSetsListBean();
        if (this.getSrcHostSetID().equals("")) {
            hslb.loadAllHostSets();
        } else {
            hslb.loadAllHostSetsPlusExtras(new String[]{this.getSrcHostSetID()});
        }
        this.mHostSetIDs = hslb.getIDs();
        this.mHostSetNames = hslb.getNames();
    }

    public void generateList() throws RaplixException {
        int i;
        MultiDifferenceSettingsQuery query = MultiDifferenceSettingsQuery.all();
        query.setCategoryFilter(this.getCategoryFilter());
        this.prepQuery(query, this.getSortOrderByName(this.getSortName()));
        this.mDifferenceSettingsArray = query.select();
        int arrLen = this.mDifferenceSettingsArray.length;
        this.mJobNames = new String[arrLen];
        this.mJobDescriptions = new String[arrLen];
        this.mJobIDs = new String[arrLen];
        this.mIsRunning = new String[arrLen];
        Vector runningDiffs = null;
        runningDiffs = this.mNotInf.queryRunningDiffs(Integer.MAX_VALUE);
        if (runningDiffs == null) {
            runningDiffs = new Vector();
        }
        RunningDiffBean[] diffBeans = runningDiffs.toArray(new RunningDiffBean[0]);
        Vector<String> runningDiffIDs = new Vector<String>();
        for (i = 0; i < diffBeans.length; ++i) {
            runningDiffIDs.add(diffBeans[i].getDifferenceSettingsID().toString());
        }
        for (i = 0; i < arrLen; ++i) {
            this.mJobNames[i] = this.mDifferenceSettingsArray[i].getName();
            this.mJobDescriptions[i] = this.mDifferenceSettingsArray[i].getDescription();
            this.mJobIDs[i] = this.mDifferenceSettingsArray[i].getObjectID().toString();
            this.mIsRunning[i] = runningDiffIDs.contains(this.mJobIDs[i]) ? new Boolean(true).toString() : new Boolean(false).toString();
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mJobIDs);
    }

    public void loadDiffSettings(String id) throws RaplixException {
        DifferenceSettings ds = this.mDiffDB.getDifferenceSettings(new DifferenceSettingsID(id));
        this.loadDiffSettings(ds);
    }

    private void loadDiffSettings(DifferenceSettings inSettings) throws RaplixException {
        String dstDir;
        String srcDir;
        String hostSetID;
        String destHostID;
        this.setName(inSettings.getName());
        this.setDescription(inSettings.getDescription());
        int scopeInt = inSettings.getDiffScope();
        if (scopeInt == 0) {
            this.setScope("component");
        } else if (scopeInt == 3) {
            this.setScope("hostset");
        } else {
            this.setScope("host");
        }
        int diffLevel = inSettings.getDiffLevel();
        int style = inSettings.getDiffStyle();
        switch (style) {
            case 0: {
                this.setStyle("repo2repo");
                break;
            }
            case 1: {
                this.setStyle("repo2inst");
                if (diffLevel == 1) {
                    this.setRepo2InstLOD("dircontent");
                    break;
                }
                this.setRepo2InstLOD("filecontent");
                break;
            }
            case 2: {
                this.setStyle("inst2inst");
                if (diffLevel == 1) {
                    this.setInst2InstLOD("dircontent");
                    break;
                }
                this.setInst2InstLOD("filecontent");
            }
        }
        String srcHostID = inSettings.getSrcHostID();
        if (srcHostID != null) {
            SummaryHost tempHost = HostsBean.getSummaryHostByID(srcHostID);
            String hostName = tempHost.getName();
            this.setSrcHostName(hostName);
        }
        if ((destHostID = inSettings.getDstHostID()) != null) {
            SummaryHost tempHost = HostsBean.getSummaryHostByID(destHostID);
            String hostName = tempHost.getName();
            this.setDestHostName(hostName);
        }
        if (inSettings.getDiffStyle() == 1) {
            String temp = this.getDestHostName();
            this.setDestHostName(this.getSrcHostName());
            this.setSrcHostName(temp);
        }
        if ((hostSetID = inSettings.getDstHostSetID()) != null) {
            this.setSrcHostSetID(hostSetID);
        }
        if ((srcDir = inSettings.getSrcDir()) != null) {
            this.setSrcDir(srcDir);
        }
        if ((dstDir = inSettings.getDstDir()) != null) {
            this.setDestDir(dstDir);
        }
        this.setInst2InstRecurse(inSettings.getIncludeSubdirectories());
        this.setFollowSymbolicLinks(inSettings.getFollowSymlinks());
        this.setUseSteps(inSettings.getUseMiniPlans());
        this.setUseSamePrepareSteps(inSettings.getDstUseSrcP());
        this.setSrcPrepareSteps(inSettings.getSrcPrepare());
        this.setDstPrepareSteps(inSettings.getDstPrepare());
        this.setUseSameCleanupSteps(inSettings.getDstUseSrcC());
        this.setSrcCleanupSteps(inSettings.getSrcCleanup());
        this.setDstCleanupSteps(inSettings.getDstCleanup());
        this.clearIgnores();
        String[] ignoreSpecs = inSettings.getIgnorePaths();
        for (int i = 0; i < ignoreSpecs.length; ++i) {
            this.addIgnore(ignoreSpecs[i]);
        }
        this.mSrcInstalledComponentID = inSettings.getInstalledComponentID() == null ? "" : inSettings.getInstalledComponentID().toString();
        int timeLimit = inSettings.getTimeoutSecs();
        this.setTimeLimitUnits("minutes");
        this.setTimeLimitValue("" + timeLimit / 60);
        int diffScope = inSettings.getDiffScope();
        if (diffScope == 0) {
            this.setScope("component");
        } else if (diffScope == 3) {
            this.setScope("hostset");
        } else {
            this.setScope("host");
        }
        this.mCategoryIDSet = inSettings.getCategories();
        this.mCatNamesString = CategoriesBean.getCategoryNamesString(this.mCategoryIDSet);
        this.mDifferenceSetting = inSettings;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("The ID after rehydrating the object is: " + this.mDifferenceSetting.getObjectID(), this);
            Logger.debug("The ID's class after rehydrating the object is: " + this.mDifferenceSetting.getObjectID().getClass(), this);
        }
    }

    public void loadComponentList() throws RaplixException {
        if (this.getComponents() != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Installed components already loaded.", this);
                Logger.debug("# of installed components: " + this.getComponents().length, this);
            }
            return;
        }
        String srcHost = this.getSrcHostName();
        if (srcHost == null || srcHost.trim().equals("")) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Host not yet set.", this);
            }
            return;
        }
        SummaryHost host = HostsBean.getSummaryHostByName(srcHost);
        HostID hostID = host.getID();
        MultiInstalledComponentQuery installedComponentsQuery = MultiInstalledComponentQuery.byHost(hostID, TargetType.CURRENT);
        installedComponentsQuery.setCategoryFilter(this.getCategoryFilter());
        InstalledComponentBean[] icbArray = installedComponentsQuery.select();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("# of installed components: " + icbArray.length, this);
        }
        this.mInstalledComponentIDs = new String[icbArray.length];
        this.mComponentNames = new String[icbArray.length];
        this.mInstalledComponents = new InstalledComponent[icbArray.length];
        SummaryComponent[] theComps = new SummaryComponent[icbArray.length];
        for (int i = 0; i < icbArray.length; ++i) {
            this.mInstalledComponents[i] = icbArray[i].getInstalledComponent();
            this.mInstalledComponentIDs[i] = this.mInstalledComponents[i].getID().toString();
            theComps[i] = icbArray[i].getComponent();
            this.mComponentNames[i] = theComps[i].getFullName() + " (" + this.mInstalledComponents[i].getInstallPath() + ")";
        }
        this.setComponents(theComps);
        this.setCorrectInstalledComponentID();
    }

    public void setCorrectInstalledComponentID() {
        block12: {
            String srcInstalledComponentID = this.getSrcInstalledComponentID();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("sicID: " + srcInstalledComponentID, this);
            }
            if (!this.getScope().equals("component")) {
                this.mSrcInstalledComponentID = "";
                return;
            }
            if (srcInstalledComponentID == null || srcInstalledComponentID.equals("")) {
                if (this.getInstalledComponentIDs() != null && this.getInstalledComponentIDs().length > 0) {
                    this.mSrcInstalledComponentID = this.getInstalledComponentIDs()[0];
                }
                return;
            }
            String[] installedComponentIDs = this.getInstalledComponentIDs();
            String[] installedComponentNames = this.getComponentNames();
            if (!srcInstalledComponentID.equals(DUMMY_ID)) {
                for (int i = 0; i < installedComponentIDs.length; ++i) {
                    if (!srcInstalledComponentID.equals(installedComponentIDs[i])) continue;
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("sicID exists in list.", this);
                    }
                    return;
                }
                try {
                    InstalledComponentID icID = new InstalledComponentID(srcInstalledComponentID);
                    InstalledComponent ic = icID.getByIDQuery().select();
                    ComponentID cID = ic.getComponentID();
                    Component c = cID.getByIDQuery().select();
                    String icNameAndPath = c.getName() + " (" + ic.getInstallPath() + ")";
                    for (int i = 0; i < installedComponentIDs.length; ++i) {
                        if (!icNameAndPath.equals(installedComponentNames[i])) continue;
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("newer ic version exists.", this);
                        }
                        this.mSrcInstalledComponentID = installedComponentIDs[i];
                        return;
                    }
                }
                catch (RaplixException e) {
                    if (!Logger.isDebugEnabled(this)) break block12;
                    Logger.debug("Exception in setCorrectInstalledComponentID(): " + e.toString(), this);
                }
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("sicID and name set to dummy value.", this);
        }
        this.mSrcInstalledComponentID = DUMMY_ID;
        this.mInstalledComponentIDs = (String[])ArrayEdit.prepend(this.mInstalledComponentIDs, DUMMY_ID, false);
        this.mComponentNames = (String[])ArrayEdit.prepend(this.mComponentNames, "select a component (path)", false);
    }

    public boolean checkIsJobRunning(String id) throws RaplixException {
        Vector runningDiffs = null;
        runningDiffs = this.mNotInf.queryRunningDiffs(Integer.MAX_VALUE);
        if (runningDiffs == null) {
            return false;
        }
        RunningDiffBean[] diffBeans = runningDiffs.toArray(new RunningDiffBean[0]);
        for (int i = 0; i < diffBeans.length; ++i) {
            if (!id.equals(diffBeans[i].getDifferenceSettingsID().toString())) continue;
            return true;
        }
        return false;
    }

    public void clearIgnores() {
        this.mIgnoreSpecs.clear();
    }

    public void addIgnore(String spec) {
        this.mIgnoreSpecs.add(spec);
    }

    public void handleAddIgnore() {
        this.mIgnoreSpecs.add(this.getNewIgnoreSpec());
        this.setNewIgnoreSpec("");
    }

    public void removeIgnore(int ignoreIndex) {
        this.mIgnoreSpecs.remove(ignoreIndex);
    }

    public void persistToDB() throws RaplixException {
        this.copyToDifferenceSettingsObject();
        DifferenceSettingsID id = this.mDiffDB.saveDifferenceSettings(this.mDifferenceSetting);
        this.mDifferenceSetting.setObjectID(id);
    }

    public void persistCopyToDB() throws RaplixException {
        this.mDifferenceSetting = new DifferenceSettings();
        this.persistToDB();
    }

    public void checkpointState() throws RaplixException {
        this.copyToDifferenceSettingsObject();
        this.mOldDifferenceSetting = this.mDifferenceSetting;
    }

    public void rollbackState() throws RaplixException {
        this.mDifferenceSetting = this.mOldDifferenceSetting;
        this.mOldDifferenceSetting = null;
        this.loadDiffSettings(this.mDifferenceSetting);
    }

    public DifferenceJobID runDiff() throws RaplixException {
        this.persistToDB();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to run a diff", this);
            Logger.debug("DifferenceSettings Scope: " + this.mDifferenceSetting.getDiffScope(), this);
        }
        DifferenceJobID dti = this.mDiffInf.diff(this.mDifferenceSetting);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Difference Job ID Recieved: " + dti.toString(), this);
        }
        return dti;
    }

    public void copyToDifferenceSettingsObject() throws RaplixException {
        this.mDifferenceSetting.setName(this.getName());
        this.mDifferenceSetting.setDescription(this.getDescription());
        if (this.getStyle().equals("repo2repo")) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Setting style to repo2repo", this);
            }
            this.mDifferenceSetting.setDiffStyle(0);
            this.mDifferenceSetting.setDiffLevel(0);
            this.mDifferenceSetting.setDiffScope(2);
        } else if (this.getStyle().equals("repo2inst")) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Setting style to repo2inst", this);
            }
            this.mDifferenceSetting.setDiffStyle(1);
            if (this.getRepo2InstLevelOfDetail().equals("filecontent")) {
                this.mDifferenceSetting.setDiffLevel(2);
            } else {
                this.mDifferenceSetting.setDiffLevel(1);
            }
            if (this.getScope().equals("component")) {
                this.mDifferenceSetting.setDiffScope(0);
            } else if (this.getScope().equals("hostset")) {
                this.mDifferenceSetting.setDiffScope(3);
            } else {
                this.mDifferenceSetting.setDiffScope(2);
            }
            this.setDestHostName(this.getSrcHostName());
        } else if (this.getStyle().equals("inst2inst")) {
            this.mDifferenceSetting.setDiffStyle(2);
            if (this.getInst2InstLevelOfDetail().equals("filecontent")) {
                this.mDifferenceSetting.setDiffLevel(2);
            } else {
                this.mDifferenceSetting.setDiffLevel(1);
            }
            this.mDifferenceSetting.setDiffScope(2);
            this.mDifferenceSetting.setFollowSymlinks(this.getFollowSymbolicLinks());
            this.mDifferenceSetting.setUseMiniPlans(this.getUseSteps());
            this.mDifferenceSetting.setDstUseSrcP(this.getUseSamePrepareSteps());
            this.mDifferenceSetting.setSrcPrepare(this.getSrcPrepareSteps());
            if (this.getUseSamePrepareSteps()) {
                this.mDifferenceSetting.setDstPrepare(this.getSrcPrepareSteps());
            } else {
                this.mDifferenceSetting.setDstPrepare(this.getDstPrepareSteps());
            }
            this.mDifferenceSetting.setDstUseSrcC(this.getUseSameCleanupSteps());
            this.mDifferenceSetting.setSrcCleanup(this.getSrcCleanupSteps());
            if (this.getUseSameCleanupSteps()) {
                this.mDifferenceSetting.setDstCleanup(this.getSrcCleanupSteps());
            } else {
                this.mDifferenceSetting.setDstCleanup(this.getDstCleanupSteps());
            }
        }
        if (!this.getScope().equals("hostset")) {
            String hostName = this.getSrcHostName();
            SummaryHost tmpHost = HostsBean.getSummaryHostByName(hostName);
            this.mDifferenceSetting.setSrcHostID(tmpHost.getID().toString());
            hostName = this.getDestHostName();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Destination Host Name: " + hostName, this);
            }
            tmpHost = HostsBean.getSummaryHostByName(hostName);
            this.mDifferenceSetting.setDstHostID(tmpHost.getID().toString());
            this.mDifferenceSetting.setDstHostSetID(null);
        } else if (this.getScope().equals("hostset")) {
            if (!this.getSrcHostSetID().equals("")) {
                this.mDifferenceSetting.setDstHostSetID(this.getSrcHostSetID());
            }
            this.mDifferenceSetting.setSrcHostID(null);
            this.mDifferenceSetting.setDstHostID(null);
        }
        this.mDifferenceSetting.setSrcDir(this.getSrcDir());
        this.mDifferenceSetting.setDstDir(this.getDestDir());
        this.mDifferenceSetting.setIncludeSubdirectories(this.getInst2InstRecurse());
        this.mDifferenceSetting.setIgnorePaths(this.getIgnoreSpecs());
        this.mDifferenceSetting.setInstalledComponentID(new InstalledComponentID(this.mSrcInstalledComponentID));
        int timeLimit = Integer.parseInt(this.getTimeLimitValue());
        timeLimit = this.getTimeLimitUnits().equals("hours") ? timeLimit * 60 * 60 : (timeLimit *= 60);
        this.mDifferenceSetting.setTimeoutSecs(timeLimit);
    }

    public void loadGlobalIgnoreSettings() throws RaplixException {
        if (this.mGlobalIgnoreSpecs == null) {
            this.mGlobalIgnoreSpecs = this.mDiffInf.getGlobalIgnorePaths();
            if (this.mGlobalIgnoreSpecs == null) {
                this.mGlobalIgnoreSpecs = new String[0];
            }
        }
        String[] staticIgnoreSpecs = new String[this.mGlobalIgnoreSpecs.length];
        String[] staticIgnoreSources = new String[this.mGlobalIgnoreSpecs.length];
        for (int i = 0; i < this.mGlobalIgnoreSpecs.length; ++i) {
            staticIgnoreSpecs[i] = this.mGlobalIgnoreSpecs[i];
            staticIgnoreSources[i] = "global";
        }
        this.setStaticIgnoreSpecs(staticIgnoreSpecs);
        this.setStaticIgnoreSources(staticIgnoreSources);
    }

    public void loadHostIgnoreSettings() throws RaplixException {
        int i;
        String srcHost = this.getSrcHostName();
        String[] componentIgnoreSpecs = new String[]{};
        String[] componentIgnoreSources = new String[]{};
        if (srcHost != null && !srcHost.trim().equals("")) {
            this.loadComponentList();
            Vector<String> componentIgnoreSpecsVector = new Vector<String>();
            Vector<String> componentIgnoreSourcesVector = new Vector<String>();
            SummaryComponent[] comps = this.getComponents();
            for (int i2 = 0; i2 < comps.length; ++i2) {
                Component theComp = comps[i2].getID().getByIDQuery().select();
                String[] ignorePaths = theComp.getIgnorePaths(null);
                for (int j = 0; j < ignorePaths.length; ++j) {
                    componentIgnoreSpecsVector.add(ignorePaths[j]);
                    componentIgnoreSourcesVector.add("component: " + comps[i2].getName());
                }
            }
            componentIgnoreSpecs = componentIgnoreSpecsVector.toArray(componentIgnoreSpecs);
            componentIgnoreSources = componentIgnoreSourcesVector.toArray(componentIgnoreSources);
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug("Host is not set, so not loading ignore settings.", this);
        }
        String[] staticIgnoreSpecs = new String[componentIgnoreSpecs.length + this.mGlobalIgnoreSpecs.length];
        String[] staticIgnoreSources = new String[componentIgnoreSources.length + this.mGlobalIgnoreSpecs.length];
        for (i = 0; i < componentIgnoreSpecs.length; ++i) {
            staticIgnoreSpecs[i] = componentIgnoreSpecs[i];
            staticIgnoreSources[i] = componentIgnoreSources[i];
        }
        for (i = 0; i < this.mGlobalIgnoreSpecs.length; ++i) {
            staticIgnoreSpecs[componentIgnoreSpecs.length + i] = this.mGlobalIgnoreSpecs[i];
            staticIgnoreSources[componentIgnoreSpecs.length + i] = "global";
        }
        this.setStaticIgnoreSources(staticIgnoreSources);
        this.setStaticIgnoreSpecs(staticIgnoreSpecs);
    }

    public void loadComponentIgnoreSettings() throws RaplixException {
        int i;
        String srcInstalledComponentID = this.getSrcInstalledComponentID();
        String[] componentIgnoreSpecs = new String[]{};
        String[] componentIgnoreSources = new String[]{};
        SummaryComponent[] comps = this.getComponents();
        if (srcInstalledComponentID != null && !srcInstalledComponentID.trim().equals("") && comps != null) {
            Vector<String> componentIgnoreSpecsVector = new Vector<String>();
            Vector<String> componentIgnoreSourcesVector = new Vector<String>();
            for (i = 0; i < comps.length; ++i) {
                if (!srcInstalledComponentID.equals(this.mInstalledComponents[i].getID().toString())) continue;
                Component theComp = comps[i].getID().getByIDQuery().select();
                String[] ignorePaths = theComp.getIgnorePaths(null);
                for (int j = 0; j < ignorePaths.length; ++j) {
                    componentIgnoreSpecsVector.add(ignorePaths[j]);
                    componentIgnoreSourcesVector.add("component: " + comps[i].getName());
                }
                componentIgnoreSpecs = componentIgnoreSpecsVector.toArray(componentIgnoreSpecs);
                componentIgnoreSources = componentIgnoreSourcesVector.toArray(componentIgnoreSources);
            }
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug("Component is not set, so not loading ignore settings.", this);
        }
        String[] staticIgnoreSpecs = new String[componentIgnoreSpecs.length + this.mGlobalIgnoreSpecs.length];
        String[] staticIgnoreSources = new String[componentIgnoreSources.length + this.mGlobalIgnoreSpecs.length];
        for (i = 0; i < componentIgnoreSpecs.length; ++i) {
            staticIgnoreSpecs[i] = componentIgnoreSpecs[i];
            staticIgnoreSources[i] = componentIgnoreSources[i];
        }
        for (i = 0; i < this.mGlobalIgnoreSpecs.length; ++i) {
            staticIgnoreSpecs[componentIgnoreSpecs.length + i] = this.mGlobalIgnoreSpecs[i];
            staticIgnoreSources[componentIgnoreSpecs.length + i] = "global";
        }
        this.setStaticIgnoreSources(staticIgnoreSources);
        this.setStaticIgnoreSpecs(staticIgnoreSpecs);
    }

    public void loadPermissionLookaheads() {
        this.mHasDiffRun = PermissionChecker.hasDiffRun();
        this.mHasWriteOnDiffs = PermissionChecker.hasWriteOnDiffs();
    }

    public void updateCategories(String[] ids, String[] catIDs, boolean replaceExisting, boolean allVersions) throws RaplixException {
        int numSettings = ids.length;
        DifferenceSettingsID[] settingIDs = new DifferenceSettingsID[numSettings];
        for (int i = 0; i < numSettings; ++i) {
            settingIDs[i] = new DifferenceSettingsID(ids[i]);
        }
        int numCatIDS = catIDs.length;
        CategoryID[] categoryIDs = new CategoryID[numCatIDS];
        for (int i = 0; i < numCatIDS; ++i) {
            categoryIDs[i] = new CategoryID(catIDs[i]);
        }
        CategoryIDSet catIDSet = new CategoryIDSet(Arrays.asList(categoryIDs));
        CategoryUpdateContext ctx = new CategoryUpdateContext(catIDSet);
        ctx.setReplaceExisting(replaceExisting);
        ctx.setAllVersions(allVersions);
        DifferenceSettingsIDSet idSet = new DifferenceSettingsIDSet(Arrays.asList(settingIDs));
        idSet.getByIDsQuery().updateCategories(ctx);
    }

    public void debugObject(String inStage) {
        block4: {
            try {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Starting SystemDiffBean dump for stage: " + inStage, this);
                }
                String[] tmpArray = this.getJobNames();
                String[] tmpArrayB = this.getJobDescriptions();
                String[] tmpArrayC = this.getJobIDs();
                this.debugArray(tmpArray, "getJobNames");
                this.debugArray(tmpArrayB, "getJobDescriptions");
                this.debugArray(tmpArrayC, "getJobIDs");
                this.debugArray(this.getIsRunning(), "getIsRunning");
                this.debugArray(this.getHostSetIDs(), "getHostSetIDs");
                this.debugArray(this.getHostSetNames(), "getHostSetNames");
                this.debugArray(this.getInstalledComponentIDs(), "getInstalledComponentIDs");
                this.debugArray(this.getComponentNames(), "getComponentNames");
                this.debugArray(this.getIgnoreSpecs(), "getIgnoreSpecs");
                this.debugValue(this.getName(), "getName");
                this.debugValue(this.getDescription(), "getDescription");
                this.debugValue(this.getID(), "getID");
                this.debugValue(this.getStyle(), "getStyle");
                this.debugValue(this.getRepo2InstLevelOfDetail(), "getRepo2InstLevelOfDetail");
                this.debugValue(this.getInst2InstLevelOfDetail(), "getInst2InstLevelOfDetail");
                this.debugValue(this.getScope(), "getScope");
                this.debugValue(this.getSrcHostSetID(), "getSrcHostSetID");
                this.debugValue(this.getSrcInstalledComponentID(), "getSrcInstalledComponentID");
                this.debugValue(this.getSrcHostName(), "getSrcHost");
                this.debugValue(this.getDestHostName(), "getDestHost");
                this.debugValue(this.getSrcDir(), "getSrcDir");
                this.debugValue(this.getDestDir(), "getDestDir");
                this.debugValue(this.getNewIgnoreSpec(), "getNewIgnoreSpec");
                this.debugValue("BOOLEAN " + this.getIsNew(), "getIsNew");
                this.debugValue("BOOLEAN " + this.getAcceptInput(), "getAcceptInput");
                this.debugValue("BOOLEAN " + this.getInst2InstRecurse(), "getInst2InstRecurse");
                this.debugValue("BOOLEAN " + this.getFollowSymbolicLinks(), "getFollowSymbolicLinks");
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Ending SystemDiffBean dump for stage: " + inStage, this);
                }
            }
            catch (Exception e) {
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Exception in debugObject(): " + e.toString(), this);
            }
        }
    }

    public void debugValue(String value, String label) {
        if (value != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug(label + ": " + value, this);
            }
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug(label + " has null value", this);
        }
    }

    public void debugArray(String[] inArray, String inLabel) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Printing Array: " + inLabel, this);
        }
        if (inArray == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("inLabel is a null array", this);
            }
            return;
        }
        for (int i = 0; i < inArray.length; ++i) {
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug(inLabel + "[" + i + "]" + inArray[i], this);
        }
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(DifferenceSettingsOrder.FACTORY, sortName);
    }
}

