/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.DiffsBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class DiffsAction
extends UIActionListServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_LIST = "error.diffs.list";
    private static final String MSG_ERROR_CATEGORIES = "error.diffs.categories";
    private static final String MSG_ERROR_NO_SELECTION = "error.diffs.noselection";
    private static final String MSG_ERROR_PREVIOUS_RESULTS = "error.diffs.previousResults";
    private static final String MSG_ERROR_PREVIOUS_RESULTS_NO_JOBS = "error.diffs.previousResults.noJobs";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through DiffsAction: " + mode, this);
        }
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        if (mode.equals("list")) {
            this.handleList(request, servletInfo);
        } else if (mode.equals("applycategories")) {
            this.handleApplyCategories(request, servletInfo);
        } else if (mode.equals("updatecategories")) {
            this.handleUpdateCategories(request, servletInfo);
        } else if (mode.equals("errors")) {
            this.handleCategoriesErrors(request, servletInfo);
        } else if (mode.equals("previousresultsfromlist")) {
            this.handleNoPreviousResults(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Invalid Mode: " + mode);
        }
    }

    public void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String minorErrorKey;
        DiffsBean db = (DiffsBean)servletInfo.getBean();
        String majorErrorKey = request.getParameter("majorErrorKey");
        if (majorErrorKey != null) {
            servletInfo.getErrors().setMajorErrorKey(majorErrorKey);
        }
        if ((minorErrorKey = request.getParameter("minorErrorKey")) != null) {
            servletInfo.getErrors().addMinorErrorKey(minorErrorKey);
        }
        db.loadPermissionLookaheads();
        db.loadCategoryFilters();
        this.loadListParameters(request, db);
        db.generateList();
        MultiCheckbox mc = db.getMultiCheckbox();
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(mc.getID(), mc);
        servletInfo.setDestPage("/diffs.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public void handleApplyCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String settingMCID = DiffsAction.assertGetParam(request, "multiLocation");
        String selected = DiffsAction.assertGetParam(request, "selected");
        String redirectURI = DiffsAction.assertGetParam(request, "redirecturi");
        MultiCheckbox settingMC = (MultiCheckbox)request.getSession().getAttribute(settingMCID);
        settingMC.setSelected(selected);
        String[] settingIDs = settingMC.getSelected();
        Vector<DifferenceSettingsID> settingList = new Vector<DifferenceSettingsID>();
        for (int i = 0; i < settingIDs.length; ++i) {
            settingList.addElement(new DifferenceSettingsID(settingIDs[i]));
        }
        DifferenceSettingsIDSet idSet = new DifferenceSettingsIDSet(settingList);
        CategoryID[] catIDs = idSet.getByIDsQuery().selectSharedCategories().toIDArray();
        int numCatIDs = catIDs.length;
        String[] categoryIDs = new String[numCatIDs];
        for (int i = 0; i < numCatIDs; ++i) {
            categoryIDs[i] = catIDs[i].toString();
        }
        MultiCheckbox sharedCategoryMC = new MultiCheckbox("", categoryIDs);
        sharedCategoryMC.setSelectedAll();
        String sharedCategoryMCID = sharedCategoryMC.getID();
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(sharedCategoryMCID, sharedCategoryMC);
        String destPage = "/CategoriesPicker?mode=list&redirecturi=" + Util.encodeURL(redirectURI) + "&" + "categoryItemID" + "=" + settingMCID + "&" + "categoryID" + "=" + sharedCategoryMCID;
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(false);
    }

    public void handleUpdateCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffsBean bean = (DiffsBean)servletInfo.getBean();
        String settingMCID = DiffsAction.assertGetParam(request, "categoryItemID");
        String categoryMCID = DiffsAction.assertGetParam(request, "categoryID");
        String selected = DiffsAction.assertGetParam(request, "selected");
        boolean replaceExisting = "true".equals(DiffsAction.assertGetParam(request, "replaceExisting"));
        boolean allVersions = request.getParameter("allVersions") != null;
        MultiCheckbox settingMC = (MultiCheckbox)request.getSession().getAttribute(settingMCID);
        String[] settingIDs = settingMC.getSelected();
        MultiCheckbox categoryMC = (MultiCheckbox)request.getSession().getAttribute(categoryMCID);
        categoryMC.setSelected(selected);
        String[] categoryIDs = categoryMC.getSelected();
        bean.updateCategories(settingIDs, categoryIDs, replaceExisting, allVersions);
        servletInfo.setDestPage("/Diffs");
        servletInfo.setShouldRedirect(true);
    }

    public void handleCategoriesErrors(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_CATEGORIES);
        servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SELECTION);
        this.handleList(request, servletInfo);
    }

    private void handleNoPreviousResults(HttpServletRequest inRequest, ServletInfo inServletInfo) throws RaplixException {
        inServletInfo.getErrors().setMajorErrorKey(MSG_ERROR_PREVIOUS_RESULTS);
        inServletInfo.getErrors().addMinorErrorKey(MSG_ERROR_PREVIOUS_RESULTS_NO_JOBS);
        this.handleList(inRequest, inServletInfo);
    }

    public ServletBean createBean(HttpServletRequest request) {
        String mode = request.getParameter("mode");
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        return new DiffsBean(DiffsAction.getApplication().getDifferenceDBInterface(), DiffsAction.getApplication().getDifferenceInterface(), DiffsAction.getApplication().getNotificationInterface(), DiffsAction.getApplication().getInstallDBManager());
    }

    public String getDefaultPage() {
        return "/diffs.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        String mode = DiffsAction.assertGetParam(request, "mode");
        if (mode.equals("list")) {
            return MSG_ERROR_LIST;
        }
        if (mode.equals("applycategories") || mode.equals("updatecategories") || mode.equals("errors")) {
            return MSG_ERROR_CATEGORIES;
        }
        if (mode.equals("previousresultsfromlist")) {
            return MSG_ERROR_PREVIOUS_RESULTS;
        }
        throw new IllegalArgumentException("Invalid Mode: " + mode);
    }
}

